/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.hdfsUser;

import io.hops.hopsworks.common.dao.AbstractReadOnlyFacade;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsers;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;

@Stateless
public class HdfsUsersFacade
extends AbstractReadOnlyFacade<HdfsUsers> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public HdfsUsersFacade() {
        super(HdfsUsers.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public HdfsUsers findById(int id) {
        return (HdfsUsers)this.em.find(HdfsUsers.class, (Object)id);
    }

    public HdfsUsers findByName(String name) {
        try {
            return (HdfsUsers)this.em.createNamedQuery("HdfsUsers.findByName", HdfsUsers.class).setParameter("name", (Object)name).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<HdfsUsers> findProjectUsers(String projectName) {
        ArrayList<HdfsUsers> users = this.em.createNamedQuery("HdfsUsers.findProjectUsers", HdfsUsers.class).setParameter("name", (Object)projectName).getResultList();
        try {
            HdfsUsers user = (HdfsUsers)this.em.createNamedQuery("HdfsUsers.findByName", HdfsUsers.class).setParameter("name", (Object)projectName).getSingleResult();
            if (user != null) {
                if (users == null) {
                    users = new ArrayList<HdfsUsers>();
                }
                users.add(user);
            }
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return users;
    }
}

