/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.metadata;

import io.hops.hopsworks.common.dao.hdfs.inode.Inode;
import io.hops.hopsworks.common.dao.metadata.EntityIntf;
import io.hops.hopsworks.common.dao.metadata.RawData;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="hopsworks.meta_tuple_to_file")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="TupleToFile.findAll", query="SELECT t FROM TupleToFile t"), @NamedQuery(name="TupleToFile.findById", query="SELECT t FROM TupleToFile t WHERE t.tupleid = :tupleid"), @NamedQuery(name="TupleToFile.findByInodeid", query="SELECT t FROM TupleToFile t WHERE t.inode.inodePK.parentId = :parentid AND t.inode.inodePK.name = :name"), @NamedQuery(name="TupleToFile.findByTupleidAndInodeid", query="SELECT t FROM TupleToFile t WHERE t.tupleid = :tupleid AND t.inode.inodePK.parentId = :parentid AND t.inode.inodePK.name = :name")})
public class TupleToFile
implements Serializable,
EntityIntf {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @NotNull
    @Column(name="tupleid")
    private Integer tupleid;
    @Basic(optional=false)
    @NotNull
    @Column(name="inodeid")
    private Long inodeid;
    @JoinColumns(value={@JoinColumn(name="inode_pid", referencedColumnName="parent_id"), @JoinColumn(name="inode_name", referencedColumnName="name"), @JoinColumn(name="partition_id", referencedColumnName="partition_id")})
    @ManyToOne(optional=false)
    private Inode inode;
    @OneToMany(mappedBy="tupleToFile", targetEntity=RawData.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<RawData> raw;

    public TupleToFile() {
    }

    public TupleToFile(int tupleid, Inode inode) {
        this.tupleid = tupleid;
        this.inode = inode;
        this.inodeid = inode.getId();
    }

    public TupleToFile(Integer tupleid) {
        this.tupleid = tupleid;
    }

    @Override
    public void copy(EntityIntf ttf) {
        TupleToFile t = (TupleToFile)ttf;
        this.tupleid = t.getId();
        this.inode = new Inode(t.getInode());
        this.raw = t.getRawData();
    }

    @Override
    public Integer getId() {
        return this.tupleid;
    }

    @Override
    public void setId(Integer id) {
        this.tupleid = id;
    }

    public void setInodeId(Long inodeid) {
        this.inodeid = inodeid;
    }

    public Long getInodeId() {
        return this.inodeid;
    }

    public Inode getInode() {
        return this.inode;
    }

    public void setInode(Inode inode) {
        this.inode = inode;
    }

    public List<RawData> getRawData() {
        return this.raw;
    }

    public void setRawData(List<RawData> raw) {
        this.raw = raw;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.tupleid != null ? this.tupleid.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TupleToFile)) {
            return false;
        }
        TupleToFile other = (TupleToFile)object;
        return (this.tupleid != null || other.tupleid == null) && (this.tupleid == null || this.tupleid.equals(other.tupleid));
    }

    public String toString() {
        return "se.kth.meta.entity.TupleToFile[ id=" + this.tupleid + ", inode=" + this.inode + " ]";
    }
}

