/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.spark;

import io.hops.hopsworks.common.jobs.configuration.JobType;
import io.hops.hopsworks.common.jobs.spark.DistributionStrategy;
import io.hops.hopsworks.common.jobs.spark.ExperimentType;
import io.hops.hopsworks.common.jobs.yarn.YarnJobConfiguration;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class SparkJobConfiguration
extends YarnJobConfiguration {
    @XmlElement
    private String appPath;
    @XmlElement
    private String mainClass;
    @XmlElement
    private String properties;
    @XmlElement
    private ExperimentType experimentType;
    @XmlElement
    private DistributionStrategy distributionStrategy;
    @XmlElement(name="spark.executor.instances")
    private int executorInstances = 1;
    @XmlElement(name="spark.executor.cores")
    private int executorCores = 1;
    @XmlElement(name="spark.executor.memory")
    private int executorMemory = 4096;
    @XmlElement(name="spark.executor.gpus")
    private int executorGpus = 0;
    @XmlElement(name="spark.tensorflow.num.ps")
    private int numPs = 1;
    @XmlElement(name="spark.dynamicAllocation.enabled")
    private boolean dynamicAllocationEnabled = true;
    @XmlElement(name="spark.dynamicAllocation.minExecutors")
    private int dynamicAllocationMinExecutors = 1;
    @XmlElement(name="spark.dynamicAllocation.maxExecutors")
    private int dynamicAllocationMaxExecutors = 2;
    @XmlElement(name="spark.dynamicAllocation.initialExecutors")
    private int dynamicAllocationInitialExecutors = 1;
    @XmlElement(name="spark.blacklist.enabled")
    private boolean blacklistingEnabled = false;
    @XmlElement(name="spark.yarn.dist.pyFiles")
    private String pyFiles;
    @XmlElement(name="spark.yarn.dist.files")
    private String files;
    @XmlElement(name="spark.yarn.dist.jars")
    private String jars;
    @XmlElement(name="spark.yarn.dist.archives")
    private String archives;

    public SparkJobConfiguration() {
    }

    public SparkJobConfiguration(ExperimentType experimentType) {
        this.experimentType = experimentType;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public void setAppPath(String appPath) {
        this.appPath = appPath;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public int getExecutorInstances() {
        return this.executorInstances;
    }

    public void setExecutorInstances(int executorInstances) {
        this.executorInstances = executorInstances;
    }

    public int getExecutorCores() {
        return this.executorCores;
    }

    public void setExecutorCores(int executorCores) {
        this.executorCores = executorCores;
    }

    public int getExecutorMemory() {
        return this.executorMemory;
    }

    public void setExecutorMemory(int executorMemory) {
        this.executorMemory = executorMemory;
    }

    public int getExecutorGpus() {
        return this.executorGpus;
    }

    public void setExecutorGpus(int executorGpus) {
        this.executorGpus = executorGpus;
    }

    public int getNumPs() {
        return this.numPs;
    }

    public void setNumPs(int numPs) {
        this.numPs = numPs;
    }

    public boolean isDynamicAllocationEnabled() {
        return this.dynamicAllocationEnabled;
    }

    public void setDynamicAllocationEnabled(boolean dynamicAllocationEnabled) {
        this.dynamicAllocationEnabled = dynamicAllocationEnabled;
    }

    public int getDynamicAllocationMinExecutors() {
        return this.dynamicAllocationMinExecutors;
    }

    public void setDynamicAllocationMinExecutors(int dynamicAllocationMinExecutors) {
        this.dynamicAllocationMinExecutors = dynamicAllocationMinExecutors;
    }

    public int getDynamicAllocationMaxExecutors() {
        return this.dynamicAllocationMaxExecutors;
    }

    public void setDynamicAllocationMaxExecutors(int dynamicAllocationMaxExecutors) {
        this.dynamicAllocationMaxExecutors = dynamicAllocationMaxExecutors;
    }

    public int getDynamicAllocationInitialExecutors() {
        return this.dynamicAllocationInitialExecutors;
    }

    public void setDynamicAllocationInitialExecutors(int dynamicAllocationInitialExecutors) {
        this.dynamicAllocationInitialExecutors = dynamicAllocationInitialExecutors;
    }

    public boolean isBlacklistingEnabled() {
        return this.blacklistingEnabled;
    }

    public void setBlacklistingEnabled(boolean blacklistingEnabled) {
        this.blacklistingEnabled = blacklistingEnabled;
    }

    public ExperimentType getExperimentType() {
        return this.experimentType;
    }

    public void setExperimentType(ExperimentType experimentType) {
        this.experimentType = experimentType;
    }

    public DistributionStrategy getDistributionStrategy() {
        return this.distributionStrategy;
    }

    public void setDistributionStrategy(DistributionStrategy distributionStrategy) {
        this.distributionStrategy = distributionStrategy;
    }

    @Override
    @XmlElement(name="jobType")
    public JobType getJobType() {
        if (this.mainClass == null) {
            return null;
        }
        if (this.mainClass.equals("org.apache.spark.deploy.PythonRunner")) {
            return JobType.PYSPARK;
        }
        return JobType.SPARK;
    }

    public String getPyFiles() {
        return this.pyFiles;
    }

    public void setPyFiles(String pyFiles) {
        this.pyFiles = pyFiles;
    }

    public String getFiles() {
        return this.files;
    }

    public void setFiles(String files) {
        this.files = files;
    }

    public String getJars() {
        return this.jars;
    }

    public void setJars(String jars) {
        this.jars = jars;
    }

    public String getArchives() {
        return this.archives;
    }

    public void setArchives(String archives) {
        this.archives = archives;
    }
}

