/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.kafka;

import io.hops.hopsworks.common.dao.kafka.schemas.Compatibility;
import io.hops.hopsworks.common.dao.kafka.schemas.CompatibilityLevel;
import io.hops.hopsworks.common.dao.kafka.schemas.SchemaCompatibility;
import io.hops.hopsworks.common.dao.kafka.schemas.SubjectsCompatibility;
import io.hops.hopsworks.common.dao.kafka.schemas.SubjectsCompatibilityFacade;
import io.hops.hopsworks.common.dao.kafka.schemas.SubjectsFacade;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.exceptions.SchemaException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class SubjectsCompatibilityController {
    private static final Logger LOGGER = Logger.getLogger(SubjectsCompatibilityController.class.getName());
    @EJB
    private SubjectsCompatibilityFacade subjectsCompatibilityFacade;
    @EJB
    private SubjectsFacade subjectsFacade;

    public CompatibilityLevel getProjectCompatibilityLevel(Project project) throws SchemaException {
        SchemaCompatibility sc = this.subjectsCompatibilityFacade.getProjectCompatibility(project).orElseThrow(() -> new SchemaException(RESTCodes.SchemaRegistryErrorCode.SUBJECT_NOT_FOUND, Level.FINE, "Project compatibility not found for project " + project.getName())).getCompatibility();
        return new CompatibilityLevel(sc);
    }

    public Compatibility getProjectCompatibility(Project project) throws SchemaException {
        SchemaCompatibility sc = this.subjectsCompatibilityFacade.getProjectCompatibility(project).orElseThrow(() -> new SchemaException(RESTCodes.SchemaRegistryErrorCode.SUBJECT_NOT_FOUND, Level.FINE, "Project compatibility not found for project " + project.getName())).getCompatibility();
        return new Compatibility(sc);
    }

    public Compatibility setProjectCompatibility(Project project, Compatibility dto) throws SchemaException {
        if (dto == null || dto.getCompatibility() == null) {
            throw new SchemaException(RESTCodes.SchemaRegistryErrorCode.INVALID_COMPATIBILITY, Level.WARNING, "Compatibility cannot be null");
        }
        this.subjectsCompatibilityFacade.setProjectCompatibility(project, dto.getCompatibility());
        return this.getProjectCompatibility(project);
    }

    public Compatibility setProjectCompatibility(Project project, SchemaCompatibility sc) throws SchemaException {
        if (sc == null) {
            throw new SchemaException(RESTCodes.SchemaRegistryErrorCode.INVALID_COMPATIBILITY, Level.WARNING, "Compatibility cannot be null");
        }
        this.subjectsCompatibilityFacade.setProjectCompatibility(project, sc);
        return this.getProjectCompatibility(project);
    }

    public CompatibilityLevel getSubjectCompatibility(Project project, String subject) throws SchemaException {
        if (subject == null) {
            throw new SchemaException(RESTCodes.SchemaRegistryErrorCode.SUBJECT_NOT_FOUND, Level.WARNING, "Subject cannot be null");
        }
        Optional<SubjectsCompatibility> sc = this.subjectsCompatibilityFacade.findBySubject(project, subject);
        if (!sc.isPresent()) {
            throw new SchemaException(RESTCodes.SchemaRegistryErrorCode.SUBJECT_NOT_FOUND, Level.WARNING, "subject=" + subject);
        }
        return new CompatibilityLevel(sc.get().getCompatibility());
    }

    public Compatibility setSubjectCompatibility(Project project, String subject, Compatibility dto) throws SchemaException {
        return this.setSubjectCompatibility(project, subject, dto.getCompatibility());
    }

    public Compatibility setSubjectCompatibility(Project project, String subject, SchemaCompatibility sc) throws SchemaException {
        if (sc == null) {
            throw new SchemaException(RESTCodes.SchemaRegistryErrorCode.INVALID_COMPATIBILITY, Level.WARNING, "Compatibility cannot be null");
        }
        if (subject == null || subject.equals("projectcompatibility") || this.subjectsFacade.findSubjectByName(project, subject).isEmpty()) {
            throw new SchemaException(RESTCodes.SchemaRegistryErrorCode.SUBJECT_NOT_FOUND, Level.WARNING, "Incorrect subject");
        }
        this.subjectsCompatibilityFacade.updateSubjectCompatibility(project, subject, sc);
        CompatibilityLevel levelDto = this.getSubjectCompatibility(project, subject);
        return new Compatibility(levelDto.getCompatibilityLevel());
    }
}

