/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.serving.sklearn;

import com.google.common.io.Files;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.serving.Serving;
import io.hops.hopsworks.common.dao.serving.ServingFacade;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.serving.LocalhostServingController;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServingException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class LocalhostSkLearnServingController {
    private static final Logger logger = Logger.getLogger(LocalhostSkLearnServingController.class.getName());
    @EJB
    private ServingFacade servingFacade;
    @EJB
    private Settings settings;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    private OSProcessExecutor osProcessExecutor;

    public int getMaxNumInstances() {
        return 1;
    }

    public String getClassName() {
        return LocalhostSkLearnServingController.class.getName();
    }

    public void killServingInstance(Project project, Serving serving, boolean releaseLock) throws ServingException {
        String script = this.settings.getHopsworksDomainDir() + "/bin/sklearn_serving.sh";
        Path secretDir = Paths.get(this.settings.getStagingDir(), "/serving/" + serving.getLocalDir());
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(script).addCommand("kill").addCommand(String.valueOf(serving.getLocalPid())).addCommand(String.valueOf(serving.getLocalPort())).addCommand(secretDir.toString()).ignoreOutErrStreams(true).build();
        logger.log(Level.INFO, processDescriptor.toString());
        try {
            this.osProcessExecutor.execute(processDescriptor);
        }
        catch (IOException ex) {
            throw new ServingException(RESTCodes.ServingErrorCode.LIFECYCLEERROR, Level.SEVERE, "serving id: " + serving.getId(), ex.getMessage(), (Throwable)ex);
        }
        serving.setLocalPid(LocalhostServingController.PID_STOPPED);
        serving.setLocalPort(-1);
        this.servingFacade.updateDbObject(serving, project);
        if (releaseLock) {
            this.servingFacade.releaseLock(project, serving.getId());
        }
    }

    public void startServingInstance(Project project, Users user, Serving serving) throws ServingException {
        String script = this.settings.getHopsworksDomainDir() + "/bin/sklearn_serving.sh";
        Integer port = ThreadLocalRandom.current().nextInt(40000, 59999);
        Path secretDir = Paths.get(this.settings.getStagingDir(), "/serving/" + serving.getLocalDir());
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(script).addCommand("start").addCommand(Utils.getFileName(Paths.get(serving.getArtifactPath(), new String[0]).toString())).addCommand(Paths.get(serving.getArtifactPath(), new String[0]).toString()).addCommand(String.valueOf(port)).addCommand(secretDir.toString()).addCommand(project.getName() + "__" + user.getUsername()).addCommand(project.getName().toLowerCase()).addCommand(this.settings.getAnacondaProjectDir(project) + "/bin/python").addCommand(this.certificateMaterializer.getUserTransientKeystorePath(project, user)).addCommand(this.certificateMaterializer.getUserTransientTruststorePath(project, user)).addCommand(this.certificateMaterializer.getUserTransientPasswordPath(project, user)).addCommand(serving.getName()).setWaitTimeout(2L, TimeUnit.MINUTES).ignoreOutErrStreams(true).build();
        logger.log(Level.INFO, processDescriptor.toString());
        try {
            this.certificateMaterializer.materializeCertificatesLocal(user.getUsername(), project.getName());
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                serving.setLocalPid(LocalhostServingController.PID_STOPPED);
                this.servingFacade.updateDbObject(serving, project);
                throw new ServingException(RESTCodes.ServingErrorCode.LIFECYCLEERRORINT, Level.INFO);
            }
            Path pidFilePath = Paths.get(secretDir.toString(), "sklearn_flask_server.pid");
            String pidContents = Files.readFirstLine((File)pidFilePath.toFile(), (Charset)Charset.defaultCharset());
            serving.setLocalPid(Integer.valueOf(pidContents));
            serving.setLocalPort(port);
            this.servingFacade.updateDbObject(serving, project);
        }
        catch (Exception ex) {
            serving.setLocalPid(LocalhostServingController.PID_STOPPED);
            this.servingFacade.updateDbObject(serving, project);
            throw new ServingException(RESTCodes.ServingErrorCode.LIFECYCLEERRORINT, Level.SEVERE, null, ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (this.settings.getHopsRpcTls()) {
                this.certificateMaterializer.removeCertificatesLocal(user.getUsername(), project.getName());
            }
            this.servingFacade.releaseLock(project, serving.getId());
        }
    }
}

