/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dataset;

import io.hops.common.Pair;
import io.hops.hopsworks.common.dao.dataset.Dataset;
import io.hops.hopsworks.common.dao.dataset.DatasetFacade;
import io.hops.hopsworks.common.dao.dataset.DatasetPermissions;
import io.hops.hopsworks.common.dao.dataset.DatasetRequest;
import io.hops.hopsworks.common.dao.dataset.DatasetRequestFacade;
import io.hops.hopsworks.common.dao.dataset.DatasetSharedWith;
import io.hops.hopsworks.common.dao.dataset.DatasetSharedWithFacade;
import io.hops.hopsworks.common.dao.hdfs.inode.Inode;
import io.hops.hopsworks.common.dao.hdfs.inode.InodeFacade;
import io.hops.hopsworks.common.dao.log.operation.OperationType;
import io.hops.hopsworks.common.dao.log.operation.OperationsLog;
import io.hops.hopsworks.common.dao.log.operation.OperationsLogFacade;
import io.hops.hopsworks.common.dao.metadata.InodeBasicMetadata;
import io.hops.hopsworks.common.dao.metadata.Template;
import io.hops.hopsworks.common.dao.metadata.db.InodeBasicMetadataFacade;
import io.hops.hopsworks.common.dao.metadata.db.TemplateFacade;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.dao.user.activity.ActivityFacade;
import io.hops.hopsworks.common.dao.user.activity.ActivityFlag;
import io.hops.hopsworks.common.dataset.FilePreviewDTO;
import io.hops.hopsworks.common.dataset.FilePreviewMode;
import io.hops.hopsworks.common.dataset.FolderNameValidator;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.FsPermissions;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.jupyter.JupyterController;
import io.hops.hopsworks.common.provenance.core.HopsFSProvenanceController;
import io.hops.hopsworks.common.provenance.core.dto.ProvTypeDTO;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class DatasetController {
    private static final Logger LOGGER = Logger.getLogger(DatasetController.class.getName());
    @EJB
    private InodeFacade inodes;
    @EJB
    private InodeController inodeController;
    @EJB
    private TemplateFacade templates;
    @EJB
    private DatasetFacade datasetFacade;
    @EJB
    private DatasetSharedWithFacade datasetSharedWithFacade;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private ActivityFacade activityFacade;
    @EJB
    private InodeBasicMetadataFacade inodeBasicMetaFacade;
    @EJB
    private HdfsUsersController hdfsUsersBean;
    @EJB
    private OperationsLogFacade operationsLogFacade;
    @EJB
    private ProjectTeamFacade projectTeamFacade;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private Settings settings;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private DatasetRequestFacade datasetRequest;
    @EJB
    private HopsFSProvenanceController fsProvController;
    @EJB
    private JupyterController jupyterController;

    public void createDataset(Users user, Project project, String dataSetName, String datasetDescription, int templateId, ProvTypeDTO metaStatus, boolean stickyBit, boolean defaultDataset, DistributedFileSystemOps dfso) throws DatasetException, HopsSecurityException {
        FsAction global;
        if (user == null || project == null || dataSetName == null) {
            throw new IllegalArgumentException("User, project or dataset were not provided");
        }
        FolderNameValidator.isValidName(dataSetName, false);
        String dsPath = Utils.getProjectPath(project.getName()) + dataSetName;
        Inode parent = this.inodeController.getProjectRoot(project.getName());
        Inode ds = this.inodes.findByInodePK(parent, dataSetName, HopsUtils.dataSetPartitionId(parent, dataSetName));
        if (ds != null) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DESTINATION_EXISTS, Level.FINE, "Dataset name: " + dataSetName);
        }
        FsAction group = defaultDataset ? FsAction.ALL : FsAction.READ_EXECUTE;
        FsPermission fsPermission = new FsPermission(FsAction.ALL, group, global = FsAction.NONE, stickyBit);
        boolean success = this.createFolder(dsPath, templateId, fsPermission, dfso);
        if (success) {
            try {
                ds = this.inodes.findByInodePK(parent, dataSetName, HopsUtils.dataSetPartitionId(parent, dataSetName));
                Dataset newDS = new Dataset(ds, project);
                newDS.setSearchable(this.isSearchable(metaStatus.getMetaStatus()));
                if (datasetDescription != null) {
                    newDS.setDescription(datasetDescription);
                }
                this.datasetFacade.persistDataset(newDS);
                this.activityFacade.persistActivity(" added a new dataset named " + dataSetName, project, user, ActivityFlag.DATASET);
                this.hdfsUsersBean.addDatasetUsersGroups(user, project, newDS, dfso);
                Dataset logDs = this.getByProjectAndDsName(project, null, dataSetName);
                this.fsProvController.updateDatasetProvType(logDs, metaStatus, dfso);
                this.logDataset(project, logDs, OperationType.Add);
            }
            catch (Exception e) {
                try {
                    dfso.rm(new Path(dsPath), true);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, "Could not cleanup dataset dir after exception: " + dsPath, ex);
                }
                throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_ERROR, Level.SEVERE, "Could not create dataset: " + dataSetName, e.getMessage(), (Throwable)e);
            }
        }
        throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_ERROR, Level.INFO, "Could not create dataset: " + dataSetName);
    }

    private boolean isSearchable(Inode.MetaStatus metaStatus) {
        return !Inode.MetaStatus.DISABLED.equals((Object)metaStatus);
    }

    public void createSubDirectory(Project project, Path dirPath, int templateId, String description, boolean searchable, DistributedFileSystemOps udfso) throws DatasetException, HopsSecurityException {
        if (project == null) {
            throw new NullPointerException("Cannot create a directory under a null project.");
        }
        if (dirPath == null) {
            throw new NullPointerException("Cannot create a directory for an empty path.");
        }
        String folderName = dirPath.getName();
        String parentPath = dirPath.getParent().toString();
        FolderNameValidator.isValidName(folderName, true);
        if (this.inodeController.existsPath(dirPath.toString())) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_SUBDIR_ALREADY_EXISTS, Level.FINE, "The given path: " + dirPath.toString() + " already exists");
        }
        Inode parent = this.inodeController.getInodeAtPath(parentPath);
        if (parent == null) {
            throw new IllegalArgumentException("Path for parent folder does not exist: " + parentPath + " under " + project.getName());
        }
        boolean success = this.createFolder(dirPath.toString(), templateId, null, udfso);
        if (success) {
            long partitionId = HopsUtils.calculatePartitionId(parent.getId(), folderName, dirPath.depth());
            Inode folder = this.inodes.findByInodePK(parent, folderName, partitionId);
            InodeBasicMetadata basicMeta = new InodeBasicMetadata(folder, description, searchable);
            this.inodeBasicMetaFacade.addBasicMetadata(basicMeta);
        }
    }

    public boolean deleteDatasetDir(Dataset dataset, Path location, DistributedFileSystemOps udfso) throws IOException {
        OperationsLog log = new OperationsLog(dataset, OperationType.Delete);
        boolean success = udfso.rm(location, true);
        if (success) {
            this.operationsLogFacade.persist(log);
        }
        return success;
    }

    public void recChangeOwnershipAndPermission(Path path, FsPermission permission, String username, String group, DistributedFileSystemOps dfso, DistributedFileSystemOps udfso) throws IOException {
        if (username != null && group != null && dfso != null) {
            dfso.setOwner(path, username, group);
        }
        udfso.setPermission(path, permission);
        Inode rootInode = this.inodeController.getInodeAtPath(path.toString());
        Stack<Pair> dirs = new Stack<Pair>();
        if (rootInode.isDir()) {
            dirs.push(new Pair((Object)rootInode, (Object)path));
        }
        while (!dirs.isEmpty()) {
            Pair dirInode = (Pair)dirs.pop();
            for (Inode child : this.inodeController.getChildren((Inode)dirInode.getL())) {
                Path childPath = new Path((Path)dirInode.getR(), child.getInodePK().getName());
                if (username != null && group != null && dfso != null) {
                    dfso.setOwner(childPath, username, group);
                }
                udfso.setPermission(childPath, permission);
                if (!child.isDir()) continue;
                dirs.push(new Pair((Object)child, (Object)childPath));
            }
        }
    }

    private boolean createFolder(String path, int template, FsPermission fsPermission, DistributedFileSystemOps dfso) throws HopsSecurityException {
        boolean success;
        Path location = new Path(path);
        try {
            if (fsPermission == null) {
                fsPermission = dfso.getParentPermission(location);
            }
            if (success = dfso.mkdir(location, fsPermission)) {
                dfso.setPermission(location, fsPermission);
            }
            if (success && template != 0 && template != -1) {
                Inode created = this.inodeController.getInodeAtPath(path);
                Template templ = this.templates.findByTemplateId(template);
                if (templ != null) {
                    templ.getInodes().add(created);
                    this.templates.updateTemplatesInodesMxN(templ);
                }
            }
        }
        catch (IOException ex) {
            throw new HopsSecurityException(RESTCodes.SecurityErrorCode.HDFS_ACCESS_CONTROL, Level.WARNING, "path: " + path, ex.getMessage(), (Throwable)ex);
        }
        return success;
    }

    public void generateReadme(DistributedFileSystemOps udfso, String dsName, String description, String project) {
        if (udfso != null) {
            String readmeFile = String.format("*This is an auto-generated README.md file for your Dataset!*\nTo replace it, go into your DataSet and edit the README.md file.\n\n*%s* DataSet\n===\n\n## %s", dsName, description);
            StringBuilder readmeSb = new StringBuilder();
            readmeSb.append(Utils.getProjectPath(project)).append(dsName).append(File.separator).append("README.md");
            String readMeFilePath = readmeSb.toString();
            try (FSDataOutputStream fsOut = udfso.create(readMeFilePath);){
                fsOut.writeBytes(readmeFile);
                fsOut.flush();
                udfso.setPermission(new Path(readMeFilePath), FsPermissions.rwxr_x___);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "README.md could not be generated for project {0} and dataset {1}.", new Object[]{project, dsName});
            }
        } else {
            LOGGER.log(Level.WARNING, "README.md could not be generated for project {0} and dataset {1}. DFS client was null", new Object[]{project, dsName});
        }
    }

    public FilePreviewDTO getReadme(String path, DistributedFileSystemOps dfso) throws IOException {
        if (path == null || dfso == null) {
            throw new IllegalArgumentException("One or more arguments are not set.");
        }
        if (!path.endsWith("README.md")) {
            throw new IllegalArgumentException("Path does not contain readme file.");
        }
        FilePreviewDTO filePreviewDTO = null;
        try (FilterInputStream dis = null;){
            if (!dfso.exists(path) || dfso.isDir(path)) {
                throw new IOException("The file does not exist");
            }
            dis = new DataInputStream((InputStream)dfso.open(path));
            long fileSize = dfso.getFileStatus(new Path(path)).getLen();
            if (fileSize > 393216L) {
                throw new IllegalArgumentException("README.md must be smaller than393216 to be previewd");
            }
            byte[] headContent = new byte[(int)fileSize];
            ((DataInputStream)dis).readFully(headContent, 0, (int)fileSize);
            filePreviewDTO = new FilePreviewDTO("text", "md", new String(headContent));
        }
        return filePreviewDTO;
    }

    public void logDataset(Project project, Dataset dataset, OperationType type) {
        if (dataset.isShared(project) || !dataset.isSearchable()) {
            return;
        }
        this.operationsLogFacade.persist(new OperationsLog(dataset, type));
    }

    public Path getDatasetPath(Dataset ds) {
        Path path = null;
        switch (ds.getDsType()) {
            case DATASET: {
                Project owningProject = this.getOwningProject(ds);
                path = new Path(Utils.getProjectPath(owningProject.getName()), ds.getInode().getInodePK().getName());
                break;
            }
            case FEATURESTORE: 
            case HIVEDB: {
                path = new Path(this.settings.getHiveWarehouse(), ds.getInode().getInodePK().getName());
            }
        }
        return path;
    }

    public Project getOwningProject(Dataset ds) {
        return ds.getProject();
    }

    public Project getOwningProject(Inode ds) {
        String datasetName;
        Inode parent = this.inodes.findParent(ds);
        Project proj = this.projectFacade.findByName(parent.getInodePK().getName());
        if (proj == null && (datasetName = ds.getInodePK().getName()).endsWith(".db")) {
            String projectName = datasetName.endsWith("_featurestore.db") ? datasetName.substring(0, datasetName.lastIndexOf("_")) : datasetName.substring(0, datasetName.lastIndexOf("."));
            proj = this.projectFacade.findByNameCaseInsensitive(projectName);
        }
        return proj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDownloadAllowed(Project project, Users user, String path) {
        String role = this.projectTeamFacade.findCurrentRole(project, user);
        if (role.equals("Data owner")) {
            return true;
        }
        if (role.equals("Data scientist")) {
            DistributedFileSystemOps udfso = null;
            try {
                String username = this.hdfsUsersBean.getHdfsUserName(project, user);
                udfso = this.dfs.getDfsOps(username);
                String owner = udfso.getFileStatus(new Path(path)).getOwner();
                String projectUser = this.hdfsUsersBean.getHdfsUserName(project, user);
                if (owner.equals(projectUser)) {
                    boolean bl = true;
                    if (udfso != null) {
                        this.dfs.closeDfsClient(udfso);
                    }
                    return bl;
                }
                if (udfso != null) {
                    this.dfs.closeDfsClient(udfso);
                }
            }
            catch (IOException ex) {
                try {
                    LOGGER.log(Level.SEVERE, "Could not get owner of file: " + path, ex);
                    if (udfso != null) {
                        this.dfs.closeDfsClient(udfso);
                    }
                }
                catch (Throwable throwable) {
                    if (udfso != null) {
                        this.dfs.closeDfsClient(udfso);
                    }
                    throw throwable;
                }
            }
        }
        return false;
    }

    public Dataset getDatasetByInodeId(Long inodeId) {
        Inode inode = this.inodes.findById(inodeId);
        return this.datasetFacade.findByInode(inode);
    }

    public Dataset getByProjectAndDsName(Project currentProject, String inodeParentPath, String dsName) {
        Inode parentInode = this.inodeController.getInodeAtPath(inodeParentPath == null ? Utils.getProjectPath(currentProject.getName()) : inodeParentPath);
        Inode dsInode = this.inodes.findByInodePK(parentInode, dsName, HopsUtils.calculatePartitionId(parentInode.getId(), dsName, 3));
        if (dsInode == null && dsName.endsWith(".db")) {
            parentInode = this.inodeController.getInodeAtPath(this.settings.getHiveWarehouse());
            dsInode = this.inodes.findByInodePK(parentInode, dsName, HopsUtils.calculatePartitionId(parentInode.getId(), dsName, 3));
        }
        if (currentProject == null || dsInode == null) {
            return null;
        }
        return this.getByProjectAndInode(currentProject, dsInode);
    }

    public Dataset getByProjectAndInode(Project project, Inode inode) {
        DatasetSharedWith datasetSharedWith;
        Dataset dataset = this.datasetFacade.findByInode(inode);
        if (dataset != null && !dataset.getProject().equals(project) && (datasetSharedWith = this.datasetSharedWithFacade.findByProjectAndDataset(project, dataset)) == null) {
            dataset = null;
        }
        return dataset;
    }

    public Dataset getByProjectAndFullPath(Project project, String fullPath) throws DatasetException {
        Inode inode = this.inodeController.getInodeAtPath(fullPath);
        if (project == null || inode == null) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_NOT_FOUND, Level.FINE, "path: " + fullPath);
        }
        Dataset dataset = this.datasetFacade.findByProjectAndInode(project, inode);
        if (dataset == null) {
            dataset = this.datasetFacade.findByInode(inode);
            if (dataset == null) {
                throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_NOT_FOUND, Level.FINE, "path: " + fullPath);
            }
            DatasetSharedWith datasetSharedWith = this.datasetSharedWithFacade.findByProjectAndDataset(project, dataset);
            if (datasetSharedWith == null) {
                throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_NOT_FOUND, Level.FINE, "path: " + fullPath);
            }
            return datasetSharedWith.getDataset();
        }
        return dataset;
    }

    public FilePreviewDTO filePreview(Project project, Users user, Path fullPath, FilePreviewMode mode, List<String> allowedImgExtension) throws DatasetException {
        FilePreviewDTO filePreviewDTO;
        block31: {
            String username = this.hdfsUsersController.getHdfsUserName(project, user);
            DistributedFileSystemOps udfso = null;
            FSDataInputStream is = null;
            filePreviewDTO = null;
            String fileName = fullPath.getName();
            try {
                udfso = this.dfs.getDfsOps(username);
                is = udfso.open(fullPath);
                String fileExtension = "txt";
                if (fileName.contains(".")) {
                    fileExtension = fileName.substring(fileName.lastIndexOf(".")).replace(".", "").toUpperCase();
                }
                long fileSize = udfso.getFileStatus(fullPath).getLen();
                if (allowedImgExtension.contains(fileExtension)) {
                    if (fileSize < (long)this.settings.getFilePreviewImageSize()) {
                        byte[] imageInBytes = new byte[(int)fileSize];
                        is.readFully(imageInBytes);
                        String base64Image = new Base64().encodeAsString(imageInBytes);
                        filePreviewDTO = new FilePreviewDTO("image", fileExtension.toLowerCase(), base64Image);
                        break block31;
                    }
                    throw new DatasetException(RESTCodes.DatasetErrorCode.IMAGE_SIZE_INVALID, Level.FINE);
                }
                if (fileExtension.equalsIgnoreCase("ipynb")) {
                    String html = this.jupyterController.convertIPythonNotebook(username, fullPath.toString(), project, "''", JupyterController.NotebookConversion.HTML);
                    filePreviewDTO = new FilePreviewDTO("html", fileExtension.toLowerCase(), html);
                    break block31;
                }
                try (DataInputStream dis = new DataInputStream((InputStream)is);){
                    int sizeThreshold = 393216;
                    if (fileSize > (long)sizeThreshold && !fileName.endsWith("README.md") && mode.equals((Object)FilePreviewMode.TAIL)) {
                        dis.skipBytes((int)(fileSize - (long)sizeThreshold));
                    } else {
                        if (fileName.endsWith("README.md") && fileSize > 393216L) {
                            throw new DatasetException(RESTCodes.DatasetErrorCode.FILE_PREVIEW_ERROR, Level.FINE, "File must be smaller than 384 KB to be previewed");
                        }
                        if ((int)fileSize < sizeThreshold) {
                            sizeThreshold = (int)fileSize;
                        }
                    }
                    byte[] headContent = new byte[sizeThreshold];
                    dis.readFully(headContent, 0, sizeThreshold);
                    filePreviewDTO = new FilePreviewDTO("text", fileExtension.toLowerCase(), new String(headContent));
                }
            }
            catch (ServiceException | IOException ex) {
                throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_ERROR, Level.SEVERE, "path: " + fullPath.toString(), ex.getMessage(), ex);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.SEVERE, "Error while closing stream.", ex);
                    }
                }
                if (udfso != null) {
                    this.dfs.closeDfsClient(udfso);
                }
            }
        }
        return filePreviewDTO;
    }

    public void checkFileExists(Path filePath, String username) throws DatasetException {
        boolean exist;
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(username);
            exist = udfso.exists(filePath);
        }
        catch (AccessControlException ae) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_ACCESS_PERMISSION_DENIED, Level.FINE, "path: " + filePath.toString(), ae.getMessage(), (Throwable)ae);
        }
        catch (IOException ex) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.INODE_NOT_FOUND, Level.FINE, "path: " + filePath.toString(), ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
        if (!exist) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.INODE_NOT_FOUND, Level.FINE, "path: " + filePath.toString());
        }
    }

    public void unzip(Project project, Users user, Path path) throws DatasetException {
        String hdfsUser = this.hdfsUsersController.getHdfsUserName(project, user);
        this.checkFileExists(path, hdfsUser);
        String localDir = DigestUtils.sha256Hex((String)path.toString());
        String stagingDir = this.settings.getStagingDir() + File.separator + localDir;
        File unzipDir = new File(stagingDir);
        unzipDir.mkdirs();
        this.settings.addUnzippingState(path.toString());
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand(this.settings.getHopsworksDomainDir() + "/bin/unzip-background.sh").addCommand(stagingDir).addCommand(path.toString()).addCommand(hdfsUser).ignoreOutErrStreams(true).build();
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            int result = processResult.getExitCode();
            if (result == 2) {
                throw new DatasetException(RESTCodes.DatasetErrorCode.COMPRESSION_SIZE_ERROR, Level.WARNING);
            }
            if (result != 0) {
                throw new DatasetException(RESTCodes.DatasetErrorCode.COMPRESSION_ERROR, Level.WARNING, "path: " + path.toString() + ", result: " + result);
            }
        }
        catch (IOException ex) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.COMPRESSION_ERROR, Level.SEVERE, "path: " + path.toString(), ex.getMessage(), (Throwable)ex);
        }
    }

    public void zip(Project project, Users user, Path path) throws DatasetException {
        String hdfsUser = this.hdfsUsersController.getHdfsUserName(project, user);
        this.checkFileExists(path, hdfsUser);
        String localDir = DigestUtils.sha256Hex((String)path.toString());
        String stagingDir = this.settings.getStagingDir() + File.separator + localDir;
        File zipDir = new File(stagingDir);
        zipDir.mkdirs();
        this.settings.addZippingState(path.toString());
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand(this.settings.getHopsworksDomainDir() + "/bin/zip-background.sh").addCommand(stagingDir).addCommand(path.toString()).addCommand(hdfsUser).ignoreOutErrStreams(true).build();
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            int result = processResult.getExitCode();
            if (result == 2) {
                throw new DatasetException(RESTCodes.DatasetErrorCode.COMPRESSION_SIZE_ERROR, Level.WARNING);
            }
            if (result != 0) {
                throw new DatasetException(RESTCodes.DatasetErrorCode.COMPRESSION_ERROR, Level.WARNING, "path: " + path.toString() + ", result: " + result);
            }
        }
        catch (IOException ex) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.COMPRESSION_ERROR, Level.SEVERE, "path: " + path.toString(), ex.getMessage(), (Throwable)ex);
        }
    }

    public void share(String targetProjectName, String fullPath, Project project, Users user) throws DatasetException, ProjectException {
        Project targetProject = this.projectFacade.findByName(targetProjectName);
        Dataset ds = this.getByProjectAndFullPath(project, fullPath);
        if (targetProject == null) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "Target project not found.");
        }
        DatasetSharedWith datasetSharedWith = this.datasetSharedWithFacade.findByProjectAndDataset(targetProject, ds);
        if (datasetSharedWith != null) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DESTINATION_EXISTS, Level.FINE, "Dataset already in " + targetProject.getName());
        }
        datasetSharedWith = new DatasetSharedWith(targetProject, ds, true);
        DatasetRequest dsReq = this.datasetRequest.findByProjectAndDataset(targetProject, ds);
        if (dsReq == null || dsReq.getProjectTeam().getTeamRole().equals("Data scientist")) {
            datasetSharedWith.setAccepted(false);
        } else {
            this.hdfsUsersController.shareDataset(targetProject, ds);
        }
        this.datasetSharedWithFacade.save(datasetSharedWith);
        if (dsReq != null) {
            this.datasetRequest.remove(dsReq);
        }
        this.activityFacade.persistActivity(" shared dataset " + ds.getName() + " with project " + targetProject.getName(), project, user, ActivityFlag.DATASET);
    }

    public void acceptShared(Project project, DatasetSharedWith datasetSharedWith) throws DatasetException {
        if (datasetSharedWith == null) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_NOT_FOUND, Level.FINE);
        }
        this.hdfsUsersController.shareDataset(project, datasetSharedWith.getDataset());
        datasetSharedWith.setAccepted(true);
        this.datasetSharedWithFacade.update(datasetSharedWith);
    }

    public void rejectShared(DatasetSharedWith datasetSharedWith) throws DatasetException {
        if (datasetSharedWith == null) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_NOT_FOUND, Level.FINE);
        }
        this.datasetSharedWithFacade.remove(datasetSharedWith);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDirectory(Project project, Users user, Path fullPath, String name, Boolean isDataset, Integer templateId, String description, ProvTypeDTO metaStatus, Boolean generateReadme) throws DatasetException, HopsSecurityException {
        DistributedFileSystemOps dfso = this.dfs.getDfsOps();
        String username = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(username);
        if (templateId == null) {
            templateId = -1;
        }
        if (description == null) {
            description = "";
        }
        try {
            if (isDataset.booleanValue()) {
                this.createDataset(user, project, name, description, templateId, metaStatus, false, false, dfso);
                if (generateReadme != null && generateReadme.booleanValue()) {
                    this.generateReadme(udfso, name, description, project.getName());
                }
            } else {
                boolean searchable = !Inode.MetaStatus.DISABLED.equals((Object)metaStatus.getMetaStatus());
                this.createSubDirectory(project, fullPath, templateId, description, searchable, udfso);
            }
        }
        finally {
            if (dfso != null) {
                dfso.close();
            }
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void move(Project project, Users user, Path sourcePath, Path destPath, Dataset sourceDataset, Dataset destDataset) throws DatasetException, HopsSecurityException {
        String username = this.hdfsUsersBean.getHdfsUserName(project, user);
        if (!this.getOwningProject(sourceDataset).equals(destDataset.getProject())) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_FORBIDDEN, Level.FINE, "Cannot copy file/folder from another project.");
        }
        if (destDataset.isPublicDs()) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_FORBIDDEN, Level.FINE, "Can not move to a public dataset.");
        }
        DistributedFileSystemOps udfso = null;
        DistributedFileSystemOps dfso = null;
        try {
            Project owning = this.getOwningProject(sourceDataset);
            boolean isMember = this.projectTeamFacade.isUserMemberOfProject(owning, user);
            udfso = isMember && this.projectTeamFacade.findCurrentRole(owning, user).equals("Data owner") && owning.equals(project) ? this.dfs.getDfsOps() : this.dfs.getDfsOps(username);
            dfso = this.dfs.getDfsOps();
            if (udfso.exists(destPath.toString())) {
                throw new DatasetException(RESTCodes.DatasetErrorCode.DESTINATION_EXISTS, Level.FINE, "destination: " + destPath.toString());
            }
            FsPermission permission = udfso.getFileStatus(destPath.getParent()).getPermission();
            String group = udfso.getFileStatus(destPath.getParent()).getGroup();
            String owner = udfso.getFileStatus(sourcePath).getOwner();
            udfso.moveWithinHdfs(sourcePath, destPath);
            this.recChangeOwnershipAndPermission(destPath, permission, owner, group, dfso, udfso);
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
            if (dfso == null) return;
            dfso.close();
            return;
        }
        catch (AccessControlException ex) {
            try {
                throw new HopsSecurityException(RESTCodes.SecurityErrorCode.HDFS_ACCESS_CONTROL, Level.FINE, "Operation: move, from: " + sourcePath.toString() + " to: " + destPath.toString());
                catch (IOException ex2) {
                    throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_ERROR, Level.SEVERE, "move operation failed for: " + sourcePath.toString(), ex2.getMessage(), (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                if (udfso != null) {
                    this.dfs.closeDfsClient(udfso);
                }
                if (dfso == null) throw throwable;
                dfso.close();
                throw throwable;
            }
        }
    }

    public void copy(Project project, Users user, Path sourcePath, Path destPath, Dataset sourceDataset, Dataset destDataset) throws DatasetException {
        String username = this.hdfsUsersBean.getHdfsUserName(project, user);
        if (!this.getOwningProject(sourceDataset).equals(destDataset.getProject())) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.COPY_FROM_PROJECT, Level.FINE);
        }
        if (destDataset.isPublicDs()) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.COPY_TO_PUBLIC_DS, Level.FINE);
        }
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(username);
            if (udfso.exists(destPath.toString())) {
                throw new DatasetException(RESTCodes.DatasetErrorCode.DESTINATION_EXISTS, Level.FINE);
            }
            FsPermission permission = udfso.getFileStatus(destPath.getParent()).getPermission();
            udfso.copyInHdfs(sourcePath, destPath);
            this.recChangeOwnershipAndPermission(destPath, permission, null, null, null, udfso);
        }
        catch (IOException ex) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_ERROR, Level.SEVERE, "move operation failed for: " + sourcePath.toString(), ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    public void setPermissions(Path path, Dataset ds, DatasetPermissions datasetPermissions, Project project, Users user) throws DatasetException {
        if (ds.isShared(project) || ds.isPublicDs() && !ds.isShared(project)) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OWNER_ERROR, Level.FINE);
        }
        try (DistributedFileSystemOps dfso = null;){
            dfso = this.dfs.getDfsOps();
            FsPermission fsPermission = null;
            if (null != datasetPermissions) {
                fsPermission = datasetPermissions.toFsPermission();
                this.recChangeOwnershipAndPermission(path, fsPermission, null, null, null, dfso);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(Project project, Users user, Path fullPath, Dataset dataset, boolean isDataset) throws DatasetException {
        boolean success;
        String username = this.hdfsUsersController.getHdfsUserName(project, user);
        Project owning = this.getOwningProject(dataset);
        DistributedFileSystemOps dfso = null;
        if (isDataset && dataset.isShared(project)) {
            this.hdfsUsersController.unShareDataset(project, dataset);
            this.datasetFacade.removeDataset(dataset);
            return;
        }
        try {
            boolean isMember = this.projectTeamFacade.isUserMemberOfProject(owning, user);
            dfso = isMember && this.projectTeamFacade.findCurrentRole(owning, user).equals("Data owner") && owning.equals(project) ? this.dfs.getDfsOps() : this.dfs.getDfsOps(username);
            success = isDataset ? this.deleteDatasetDir(dataset, fullPath, dfso) : dfso.rm(fullPath, true);
            if (dfso != null) {
                this.dfs.closeDfsClient(dfso);
            }
        }
        catch (AccessControlException ae) {
            try {
                throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_ACCESS_PERMISSION_DENIED, Level.FINE, "path: " + fullPath.toString(), ae.getMessage(), (Throwable)ae);
                catch (FileNotFoundException fnfe) {
                    throw new DatasetException(RESTCodes.DatasetErrorCode.INODE_NOT_FOUND, Level.FINE, "path: " + fullPath.toString(), fnfe.getMessage(), (Throwable)fnfe);
                }
                catch (IOException ex) {
                    throw new DatasetException(RESTCodes.DatasetErrorCode.INODE_DELETION_ERROR, Level.SEVERE, "path: " + fullPath.toString(), ex.getMessage(), (Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                if (dfso == null) throw throwable;
                this.dfs.closeDfsClient(dfso);
                throw throwable;
            }
        }
        if (!success) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.INODE_DELETION_ERROR, Level.FINE, "path: " + fullPath.toString());
        }
        if (!isDataset) return;
        try {
            this.hdfsUsersController.deleteDatasetGroup(dataset);
            return;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Error while trying to delete a dataset group", ex);
        }
    }

    public void deleteCorrupted(Project project, Users user, Path fullPath, Dataset dataset) throws DatasetException {
        DistributedFileSystemOps dfso = null;
        try {
            Project owning = this.getOwningProject(dataset);
            boolean isMember = this.projectTeamFacade.isUserMemberOfProject(owning, user);
            if (isMember && owning.equals(project)) {
                dfso = this.dfs.getDfsOps();
                FileStatus fs = dfso.getFileStatus(fullPath);
                String owner = fs.getOwner();
                long len = fs.getLen();
                if (owner.equals(this.settings.getHopsworksUser()) && len == 0L) {
                    dfso.rm(fullPath, true);
                }
            }
        }
        catch (IOException ex) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.INODE_DELETION_ERROR, Level.SEVERE, "path: " + fullPath.toString(), ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (dfso != null) {
                this.dfs.closeDfsClient(dfso);
            }
        }
    }

    public void unshare(Project project, Users user, Dataset dataset, String targetProjectName) throws DatasetException {
        Project proj = this.projectFacade.findByName(targetProjectName);
        DatasetSharedWith datasetSharedWith = this.datasetSharedWithFacade.findByProjectAndDataset(proj, dataset);
        if (datasetSharedWith == null) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_NOT_SHARED_WITH_PROJECT, Level.FINE, "project: " + proj.getName());
        }
        this.hdfsUsersController.unshareDataset(proj, dataset);
        this.datasetSharedWithFacade.remove(datasetSharedWith);
        this.activityFacade.persistActivity(" unshared dataset " + dataset.getName() + " with project " + proj.getName(), project, user, ActivityFlag.DATASET);
    }

    public void updateDescription(Project project, Users user, Dataset dataset, String description) {
        if (description != null && !dataset.getDescription().equals(description)) {
            dataset.setDescription(description);
            this.datasetFacade.update(dataset);
            this.activityFacade.persistActivity(" updated dataset description for " + dataset.getName(), project, user, ActivityFlag.DATASET);
        }
    }
}

