/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.hive;

import io.hops.hopsworks.common.dao.hdfs.inode.Inode;
import io.hops.hopsworks.common.dao.jobhistory.YarnApplicationstateFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.yarn.YarnClientService;
import io.hops.hopsworks.common.yarn.YarnClientWrapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;

@Singleton
@Startup
@DependsOn(value={"Settings"})
public class HiveScratchdirCleaner {
    @EJB
    private Settings settings;
    @EJB
    private InodeController inodeController;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private YarnClientService yarnService;
    @EJB
    private YarnApplicationstateFacade yarnApplicationstateFacade;
    @Resource
    private TimerService timerService;
    private static final Logger logger = Logger.getLogger(HiveScratchdirCleaner.class.getName());
    private Set<String> applicationTypeSet = null;
    private EnumSet<YarnApplicationState> applicationStateEnumSet = null;

    @PostConstruct
    private void init() {
        this.applicationTypeSet = new HashSet<String>(Arrays.asList("TEZ", "SPARK"));
        this.applicationStateEnumSet = this.yarnApplicationstateFacade.getRunningStates();
        String intervalRaw = this.settings.getHiveScratchdirCleanerInterval();
        Long intervalValue = this.settings.getConfTimeValue(intervalRaw);
        TimeUnit intervalTimeunit = this.settings.getConfTimeTimeUnit(intervalRaw);
        logger.log(Level.INFO, "Hive scratchdir cleaner is configured to run every " + intervalValue + " " + intervalTimeunit.name());
        intervalValue = intervalTimeunit.toMillis(intervalValue);
        this.timerService.createTimer(intervalValue.longValue(), intervalValue.longValue(), (Serializable)((Object)"Hive scratchdir cleaner"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void doCleanUp() {
        YarnClientWrapper yarnClientWrapper = null;
        DistributedFileSystemOps dfso = null;
        try {
            yarnClientWrapper = this.yarnService.getYarnClientSuper(this.settings.getConfiguration());
            YarnClient yarnClient = yarnClientWrapper.getYarnClient();
            dfso = this.dfs.getDfsOps();
            HashSet queueSet = new HashSet();
            List queueInfoList = yarnClient.getAllQueues();
            queueInfoList.forEach(queue -> queueSet.add(queue.getQueueName()));
            String scratchDirParent = this.settings.getHiveScratchdir();
            Long delayValue = this.settings.getConfTimeValue(this.settings.getHiveScratchdirDelay());
            TimeUnit delayTimeunit = this.settings.getConfTimeTimeUnit(this.settings.getHiveScratchdirDelay());
            Long threshold = System.currentTimeMillis() - delayTimeunit.toMillis(delayValue);
            List<Inode> scratchDirs = this.inodeController.getChildren(scratchDirParent);
            for (Inode scratchDir : scratchDirs) {
                if (scratchDir.getModificationTime().longValue() >= threshold || scratchDir.getInodePK().getName().equals(this.settings.getHiveSuperUser())) continue;
                Path fullScratchDirPath = new Path(scratchDirParent, scratchDir.getInodePK().getName());
                try {
                    String hiveUserStr = scratchDir.getInodePK().getName();
                    HashSet<String> hiveUser = new HashSet<String>();
                    hiveUser.add(hiveUserStr);
                    List appReports = yarnClient.getApplications(queueSet, hiveUser, this.applicationTypeSet, this.applicationStateEnumSet);
                    if (!appReports.isEmpty()) continue;
                    dfso.rm(fullScratchDirPath, true);
                }
                catch (IOException | RuntimeException | YarnException e) {
                    logger.log(Level.SEVERE, "Could not remove Hive scratchdir for user: " + scratchDir.getInodePK().getName(), e);
                }
            }
            this.yarnService.closeYarnClient(yarnClientWrapper);
            if (dfso != null) {
                this.dfs.closeDfsClient(dfso);
            }
        }
        catch (Exception e) {
            try {
                logger.log(Level.SEVERE, "Error while starting Hive scratchdir cleaning ", e);
                this.yarnService.closeYarnClient(yarnClientWrapper);
                if (dfso != null) {
                    this.dfs.closeDfsClient(dfso);
                }
            }
            catch (Throwable throwable) {
                this.yarnService.closeYarnClient(yarnClientWrapper);
                if (dfso != null) {
                    this.dfs.closeDfsClient(dfso);
                }
                throw throwable;
            }
        }
    }
}

