/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.airflow;

import io.hops.hopsworks.common.dao.airflow.AirflowDag;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.sql.DataSource;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class AirflowDagFacade {
    private static final Logger LOGGER = Logger.getLogger(AirflowDagFacade.class.getName());
    private static final String DAGS_STATUS_QUERY = "SELECT dag_id, is_paused FROM airflow.dag WHERE owners = ?";
    @Resource(name="jdbc/airflow")
    private DataSource airflowDataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AirflowDag> filterByOwner(String owner) throws IOException, SQLException {
        if (owner == null || owner.isEmpty()) {
            throw new IOException("Airflow DAG owner cannot be null or empty");
        }
        ArrayList<AirflowDag> dags = new ArrayList<AirflowDag>();
        PreparedStatement stmt = null;
        ResultSet dagsRS = null;
        try {
            Connection connection = this.airflowDataSource.getConnection();
            stmt = connection.prepareStatement(DAGS_STATUS_QUERY);
            stmt.setString(1, owner);
            dagsRS = stmt.executeQuery();
            while (dagsRS.next()) {
                AirflowDag dag = new AirflowDag(dagsRS.getString("dag_id"), dagsRS.getBoolean("is_paused"));
                dags.add(dag);
            }
            ArrayList<AirflowDag> arrayList = dags;
            return arrayList;
        }
        finally {
            try {
                if (dagsRS != null) {
                    dagsRS.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                LOGGER.log(Level.WARNING, "Could not release resources", ex);
            }
        }
    }
}

