/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.cached;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.cached.CachedFeaturegroup;
import io.hops.hopsworks.common.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.hive.HiveTableType;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.validation.ConstraintViolationException;

@Stateless
public class CachedFeaturegroupFacade
extends AbstractFacade<CachedFeaturegroup> {
    private static final Logger LOGGER = Logger.getLogger(CachedFeaturegroupFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public CachedFeaturegroupFacade() {
        super(CachedFeaturegroup.class);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void persist(CachedFeaturegroup cachedFeaturegroup) {
        try {
            this.em.persist((Object)cachedFeaturegroup);
            this.em.flush();
        }
        catch (ConstraintViolationException cve) {
            LOGGER.log(Level.WARNING, "Could not persist the new cached feature group", cve);
            throw cve;
        }
    }

    public List<FeatureDTO> getHiveFeatures(Long hiveTableId) {
        List featureObjects = this.em.createNativeQuery("SELECT c.`COLUMN_NAME`, c.`TYPE_NAME`, c.`COMMENT` FROM metastore.`TBLS` t JOIN metastore.`SDS` s JOIN metastore.`COLUMNS_V2` c ON t.`SD_ID`=s.`SD_ID` AND s.`CD_ID`=c.`CD_ID` WHERE t.`TBL_ID` = ?1;").setParameter(1, (Object)hiveTableId).getResultList();
        ArrayList<FeatureDTO> featureDTOs = new ArrayList<FeatureDTO>();
        for (Object[] featureObject : featureObjects) {
            FeatureDTO featureDTO = new FeatureDTO((String)featureObject[0], (String)featureObject[1], featureObject[2] == null ? "" : (String)featureObject[2]);
            featureDTOs.add(featureDTO);
        }
        featureDTOs.addAll(this.getHivePartitionKeys(hiveTableId));
        return featureDTOs;
    }

    public Long getHiveTableId(String hiveTableName, Long hiveDbId) {
        try {
            return (Long)this.em.createNativeQuery("SELECT `TBL_ID` FROM metastore.`TBLS` WHERE `TBL_NAME` = ?1 AND `DB_ID` = ?2;").setParameter(1, (Object)hiveTableName.toLowerCase()).setParameter(2, (Object)hiveDbId).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<FeatureDTO> getHivePartitionKeys(Long hiveTableId) {
        try {
            List featureObjects = this.em.createNativeQuery("SELECT `PKEY_NAME`, `PKEY_TYPE`, `PKEY_COMMENT` FROM metastore.`PARTITION_KEYS` WHERE `TBL_ID` = ?1;").setParameter(1, (Object)hiveTableId).getResultList();
            ArrayList<FeatureDTO> featureDTOs = new ArrayList<FeatureDTO>();
            for (Object[] featureObject : featureObjects) {
                FeatureDTO featureDTO = new FeatureDTO((String)featureObject[0], (String)featureObject[1], (String)featureObject[2], false, true, null);
                featureDTOs.add(featureDTO);
            }
            return featureDTOs;
        }
        catch (NoResultException e) {
            return new ArrayList<FeatureDTO>();
        }
    }

    public Long getHiveTableInodeId(Long hiveTableId) {
        try {
            return (Long)this.em.createNativeQuery("SELECT i.`id` FROM metastore.`TBLS` t JOIN metastore.`SDS` s JOIN hops.`hdfs_inodes` i ON t.`SD_ID`=s.`SD_ID` AND s.`PARTITION_ID`=i.`partition_id` AND s.`PARENT_ID`=i.`parent_id` AND s.`NAME`=i.`name` WHERE `TBL_ID` = ?1;").setParameter(1, (Object)hiveTableId).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public String getHiveTableComment(Long hiveTableId) {
        try {
            return (String)this.em.createNativeQuery("SELECT `PARAM_VALUE` FROM metastore.`TABLE_PARAMS` WHERE `TBL_ID` = ?1 AND `PARAM_KEY`='comment';").setParameter(1, (Object)hiveTableId).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<String> getHiveTablePrimaryKey(Long hiveTableId) {
        try {
            return this.em.createNativeQuery("SELECT c.`COLUMN_NAME` FROM metastore.`TBLS` t JOIN metastore.`SDS` s JOIN metastore.`COLUMNS_V2` c ON t.`SD_ID`=s.`SD_ID` AND s.`CD_ID`=c.`CD_ID` WHERE t.`TBL_ID` = ?1 AND EXISTS (SELECT * FROM metastore.`KEY_CONSTRAINTS` k WHERE k.`PARENT_CD_ID`=c.`CD_ID` AND k.`PARENT_TBL_ID` = ?1 AND k.`PARENT_INTEGER_IDX`=c.`INTEGER_IDX` AND k.`CONSTRAINT_TYPE`=0)").setParameter(1, (Object)hiveTableId).getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<String> getHiveTableHdfsPaths(Long hiveTblId) {
        try {
            List hdfsPathObjects = this.em.createNativeQuery("SELECT s.`LOCATION` FROM metastore.`TBLS` t JOIN metastore.`SDS` s ON t.`SD_ID` = s.`SD_ID` WHERE t.`TBL_ID` = ?1;").setParameter(1, (Object)hiveTblId).getResultList();
            return hdfsPathObjects.stream().map(o -> (String)o).collect(Collectors.toList());
        }
        catch (NoResultException e) {
            return new ArrayList<String>();
        }
    }

    public HiveTableType getHiveTableType(Long hiveTableId) {
        try {
            return HiveTableType.valueOf((String)this.em.createNativeQuery("SELECT `TBL_TYPE` FROM metastore.`TBLS` WHERE `TBL_ID`= ?1;").setParameter(1, (Object)hiveTableId).getSingleResult());
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public String getHiveInputFormat(Long hiveTableId) {
        try {
            return (String)this.em.createNativeQuery("SELECT `INPUT_FORMAT` FROM metastore.`TBLS` t JOIN metastore.`SDS` s ON t.`SD_ID`=s.`SD_ID` WHERE t.`TBL_ID`=?1").setParameter(1, (Object)hiveTableId).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public CachedFeaturegroup updateMetadata(CachedFeaturegroup cachedFeaturegroup) {
        this.em.merge((Object)cachedFeaturegroup);
        return cachedFeaturegroup;
    }
}

