/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.proxies;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Strings;
import io.hops.hopsworks.common.proxies.CAExceptionDeserializer;
import io.hops.hopsworks.common.proxies.client.HttpClient;
import io.hops.hopsworks.common.proxies.client.HttpRetryableAction;
import io.hops.hopsworks.common.proxies.client.NotRetryableClientProtocolException;
import io.hops.hopsworks.common.security.CSR;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.CAException;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class CAProxy {
    private static final Logger LOG = Logger.getLogger(CAProxy.class.getName());
    private static final String CONTENT_TYPE_JSON = "application/json; charset=utf-8";
    private static final String CA_BASE_PATH = "/hopsworks-ca/v2/certificate/";
    private static final String CERTIFICATE_IDENTIFIER = "certId";
    private ObjectMapper objectMapper;
    private ResponseHandler<CSR> CA_SIGN_RESPONSE_HANDLER = new CASignCSRResponseHandler();
    private ResponseHandler<Void> CA_REVOKE_RESPONSE_HANDLER = new CARevokeX509ResponseHandler();
    @EJB
    private HttpClient client;
    @EJB
    private Settings settings;

    @PostConstruct
    public void init() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(CAException.class, (JsonDeserializer)new CAExceptionDeserializer());
        this.objectMapper.registerModule((Module)module);
    }

    public CSR signProjectCSR(CSR csr) throws HopsSecurityException, GenericException {
        return this.signCSR(csr, CA_PATH.PROJECT_CA_PATH);
    }

    public CSR signDelaCSR(CSR csr) throws HopsSecurityException, GenericException {
        return this.signCSR(csr, CA_PATH.DELA_CA_PATH);
    }

    private CSR signCSR(CSR csr, CA_PATH path) throws HopsSecurityException, GenericException {
        try {
            String csrJSON = this.objectMapper.writeValueAsString((Object)csr);
            final HttpPost httpRequest = new HttpPost(path.path);
            httpRequest.setHeader("Content-Type", CONTENT_TYPE_JSON);
            this.client.setAuthorizationHeader((HttpRequest)httpRequest);
            httpRequest.setEntity((HttpEntity)new StringEntity(csrJSON));
            HttpRetryableAction<CSR> retryableAction = new HttpRetryableAction<CSR>(){

                @Override
                public CSR performAction() throws ClientProtocolException, IOException {
                    return (CSR)CAProxy.this.client.execute((HttpRequest)httpRequest, CAProxy.this.CA_SIGN_RESPONSE_HANDLER);
                }
            };
            return (CSR)retryableAction.tryAction();
        }
        catch (JsonProcessingException ex) {
            throw new HopsSecurityException(RESTCodes.SecurityErrorCode.CSR_ERROR, Level.SEVERE, null, null, (Throwable)ex);
        }
        catch (ClientProtocolException ex) {
            LOG.log(Level.SEVERE, "Could not sign CSR", ex);
            throw new HopsSecurityException(RESTCodes.SecurityErrorCode.CSR_ERROR, Level.SEVERE, null, null, ex.getCause());
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Could not sign CSR", ex);
            throw new GenericException(RESTCodes.GenericErrorCode.UNKNOWN_ERROR, Level.SEVERE, "Generic error while signing CSR", null, (Throwable)ex);
        }
    }

    public void revokeProjectX509(String certificateIdentifier) throws HopsSecurityException, GenericException {
        this.revokeX509(certificateIdentifier, CA_PATH.PROJECT_CA_PATH);
    }

    public void revokeDelaX509(String certificateIdentifier) throws HopsSecurityException, GenericException {
        this.revokeX509(certificateIdentifier, CA_PATH.DELA_CA_PATH);
    }

    private void revokeX509(String certificateIdentifier, CA_PATH path) throws HopsSecurityException, GenericException {
        if (Strings.isNullOrEmpty((String)certificateIdentifier)) {
            throw new HopsSecurityException(RESTCodes.SecurityErrorCode.CERTIFICATE_NOT_FOUND, Level.SEVERE, null, "Certificate Identifier cannot be null or empty");
        }
        try {
            URI revokeURI = new URIBuilder(path.path).addParameter(CERTIFICATE_IDENTIFIER, certificateIdentifier).build();
            final HttpDelete httpRequest = new HttpDelete(revokeURI);
            this.client.setAuthorizationHeader((HttpRequest)httpRequest);
            HttpRetryableAction<Void> retryableAction = new HttpRetryableAction<Void>(){

                @Override
                public Void performAction() throws ClientProtocolException, IOException {
                    return (Void)CAProxy.this.client.execute((HttpRequest)httpRequest, CAProxy.this.CA_REVOKE_RESPONSE_HANDLER);
                }
            };
            retryableAction.tryAction();
        }
        catch (URISyntaxException ex) {
            throw new GenericException(RESTCodes.GenericErrorCode.UNKNOWN_ERROR, Level.SEVERE, null, null, (Throwable)ex);
        }
        catch (ClientProtocolException ex) {
            LOG.log(Level.WARNING, "Could not revoke X.509 " + certificateIdentifier, ex);
            if (ex.getCause() instanceof HopsSecurityException) {
                throw (HopsSecurityException)ex.getCause();
            }
            throw new HopsSecurityException(RESTCodes.SecurityErrorCode.CERTIFICATE_REVOKATION_ERROR, Level.WARNING, null, null, (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Could not revoke X.509 " + certificateIdentifier, ex);
            throw new GenericException(RESTCodes.GenericErrorCode.UNKNOWN_ERROR, Level.SEVERE, "Generic error while revoking X.509", null, (Throwable)ex);
        }
    }

    private HopsSecurityException constructHopsSecurityException(HttpResponse response, RESTCodes.SecurityErrorCode errorCode, Level logLevel) throws IOException {
        CAException exception = (CAException)this.objectMapper.readValue(response.getEntity().getContent(), CAException.class);
        return new HopsSecurityException(errorCode, logLevel, exception.getUsrMsg(), exception.getDevMsg());
    }

    private class CARevokeX509ResponseHandler
    implements ResponseHandler<Void> {
        private CARevokeX509ResponseHandler() {
        }

        public Void handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            int status = response.getStatusLine().getStatusCode();
            if (200 == status) {
                return null;
            }
            if (204 == status) {
                HopsSecurityException securityException = new HopsSecurityException(RESTCodes.SecurityErrorCode.CERTIFICATE_NOT_FOUND, Level.WARNING);
                throw new NotRetryableClientProtocolException(securityException);
            }
            if (400 == status) {
                HopsSecurityException securityException = CAProxy.this.constructHopsSecurityException(response, RESTCodes.SecurityErrorCode.CERTIFICATE_REVOKATION_USER_ERR, Level.FINE);
                throw new NotRetryableClientProtocolException(securityException);
            }
            throw new ClientProtocolException("Temporary error while revoking certificate, HTTP status: " + status);
        }
    }

    private class CASignCSRResponseHandler
    implements ResponseHandler<CSR> {
        private CASignCSRResponseHandler() {
        }

        public CSR handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            int status = response.getStatusLine().getStatusCode();
            if (status / 100 == 4) {
                throw new NotRetryableClientProtocolException(this.constructSignHopsSecurityException(response));
            }
            if (status / 100 != 2) {
                throw new ClientProtocolException((Throwable)this.constructSignHopsSecurityException(response));
            }
            String responseJSON = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
            return (CSR)CAProxy.this.objectMapper.readValue(responseJSON, CSR.class);
        }

        private HopsSecurityException constructSignHopsSecurityException(HttpResponse response) throws IOException {
            return CAProxy.this.constructHopsSecurityException(response, RESTCodes.SecurityErrorCode.CERTIFICATE_SIGN_USER_ERR, Level.FINE);
        }
    }

    private static enum CA_PATH {
        PROJECT_CA_PATH("/hopsworks-ca/v2/certificate/project"),
        DELA_CA_PATH("/hopsworks-ca/v2/certificate/dela");

        private final String path;

        private CA_PATH(String path) {
            this.path = path;
        }
    }
}

