/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.user;

import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.dao.user.security.ua.UserAccountStatus;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import javax.ejb.Stateless;

@Stateless
public class UserStatusValidator {
    public boolean checkStatus(UserAccountStatus status) throws UserException {
        if (status.equals((Object)UserAccountStatus.NEW_MOBILE_ACCOUNT)) {
            throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_INACTIVE, Level.FINE);
        }
        if (status.equals((Object)UserAccountStatus.BLOCKED_ACCOUNT) || status.equals((Object)UserAccountStatus.SPAM_ACCOUNT)) {
            throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_BLOCKED, Level.FINE);
        }
        if (status.equals((Object)UserAccountStatus.DEACTIVATED_ACCOUNT)) {
            throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_DEACTIVATED, Level.FINE);
        }
        if (status.equals((Object)UserAccountStatus.LOST_MOBILE)) {
            throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_LOST_DEVICE, Level.FINE);
        }
        if (status.equals((Object)UserAccountStatus.VERIFIED_ACCOUNT)) {
            throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_NOT_APPROVED, Level.FINE);
        }
        return true;
    }

    public void checkNewUserStatus(UserAccountStatus status) throws UserException {
        switch (status) {
            case NEW_MOBILE_ACCOUNT: {
                return;
            }
            case VERIFIED_ACCOUNT: {
                throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_INACTIVE, Level.FINE);
            }
            case ACTIVATED_ACCOUNT: {
                throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_ALREADY_VERIFIED, Level.FINE);
            }
            case LOST_MOBILE: {
                throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_LOST_DEVICE, Level.FINE);
            }
            case DEACTIVATED_ACCOUNT: {
                throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_DEACTIVATED, Level.FINE);
            }
        }
        throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_BLOCKED, Level.FINE);
    }

    public boolean isNewAccount(Users user) {
        if (user == null) {
            return false;
        }
        return user.getStatus().equals((Object)UserAccountStatus.NEW_MOBILE_ACCOUNT);
    }

    public boolean isBlockedAccount(Users user) {
        if (user == null) {
            return false;
        }
        return user.getStatus().equals((Object)UserAccountStatus.DEACTIVATED_ACCOUNT) || user.getStatus().equals((Object)UserAccountStatus.BLOCKED_ACCOUNT) || user.getStatus().equals((Object)UserAccountStatus.SPAM_ACCOUNT);
    }

    public boolean isLostDeviceAccount(Users user) {
        if (user == null) {
            return false;
        }
        return user.getStatus().equals((Object)UserAccountStatus.LOST_MOBILE);
    }
}

