/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.dataset;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.dataset.DataSetDTO;
import io.hops.hopsworks.common.dao.dataset.Dataset;
import io.hops.hopsworks.common.dao.dataset.DatasetSharedWith;
import io.hops.hopsworks.common.dao.dataset.DatasetType;
import io.hops.hopsworks.common.dao.hdfs.inode.Inode;
import io.hops.hopsworks.common.dao.hdfs.inode.InodeFacade;
import io.hops.hopsworks.common.dao.project.Project;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class DatasetFacade
extends AbstractFacade<Dataset> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    @EJB
    private InodeFacade inodeFacade;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public DatasetFacade() {
        super(Dataset.class);
    }

    public Dataset find(Integer id) {
        return (Dataset)this.em.find(Dataset.class, (Object)id);
    }

    public Dataset findByInode(Inode inode) {
        TypedQuery query = this.em.createNamedQuery("Dataset.findByInode", Dataset.class).setParameter("inode", (Object)inode);
        try {
            return (Dataset)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Optional<Dataset> findByPublicDsIdProject(String publicDsId, Project project) {
        TypedQuery query = this.em.createNamedQuery("Dataset.findByPublicDsIdProject", Dataset.class).setParameter("publicDsId", (Object)publicDsId).setParameter("project", (Object)project);
        try {
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<Dataset> findByPublicDsId(String publicDsId) {
        TypedQuery query = this.em.createNamedQuery("Dataset.findByPublicDsId", Dataset.class).setParameter("publicDsId", (Object)publicDsId);
        try {
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public List<Project> findProjectSharedWith(Project project, Inode inode) {
        Dataset dataset = this.findByInode(inode);
        ArrayList<Project> projects = new ArrayList<Project>();
        if (dataset == null) {
            return projects;
        }
        for (DatasetSharedWith ds : dataset.getDatasetSharedWithCollection()) {
            if (ds.getProject().equals(project)) continue;
            projects.add(ds.getProject());
        }
        return projects;
    }

    public Dataset findByProjectAndInode(Project project, Inode inode) {
        if (project == null || inode == null) {
            throw new IllegalArgumentException("Project and/or inode were not provided.");
        }
        try {
            return (Dataset)this.em.createNamedQuery("Dataset.findByProjectAndInode", Dataset.class).setParameter("project", (Object)project).setParameter("inode", (Object)inode).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<Dataset> findByProject(Project project) {
        TypedQuery query = this.em.createNamedQuery("Dataset.findByProject", Dataset.class).setParameter("project", (Object)project);
        return query.getResultList();
    }

    public List<DataSetDTO> findPublicDatasets() {
        TypedQuery query = this.em.createNamedQuery("Dataset.findAllPublic", Dataset.class);
        List datasets = query.getResultList();
        ArrayList<DataSetDTO> ds = new ArrayList<DataSetDTO>();
        for (Dataset d : datasets) {
            DataSetDTO dto = new DataSetDTO();
            dto.setDescription(d.getDescription());
            dto.setName(d.getInode().getInodePK().getName());
            dto.setInodeId(d.getInode().getId());
            ds.add(dto);
        }
        return ds;
    }

    public List<Dataset> findAllPublicDatasets() {
        TypedQuery query = this.em.createNamedQuery("Dataset.findAllPublic", Dataset.class);
        return query.getResultList();
    }

    public List<Dataset> findPublicDatasetsByState(int publicDs) {
        TypedQuery query = this.em.createNamedQuery("Dataset.findPublicByState", Dataset.class).setParameter("publicDs", (Object)publicDs);
        return query.getResultList();
    }

    public void persistDataset(Dataset dataset) {
        this.em.persist((Object)dataset);
    }

    public void flushEm() {
        this.em.flush();
    }

    public void merge(Dataset dataset) {
        this.em.merge((Object)dataset);
        this.em.flush();
    }

    public void removeDataset(Dataset dataset) {
        Dataset ds = (Dataset)this.em.find(Dataset.class, (Object)dataset.getId());
        if (ds != null) {
            this.em.remove((Object)ds);
        }
    }

    public AbstractFacade.CollectionInfo findAllDatasetByProject(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort, Project project) {
        String queryStr = this.buildQuery("SELECT d FROM Dataset d ", filter, sort, "d.project = :project ");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT d.id) FROM Dataset d ", filter, null, "d.project = :project ");
        TypedQuery query = this.em.createQuery(queryStr, Dataset.class).setParameter("project", (Object)project);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, Dataset.class).setParameter("project", (Object)project);
        this.setFilter(filter, (Query)query, project);
        this.setFilter(filter, (Query)queryCount, project);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo(this, (Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q, Project project) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q, project);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q, Project project) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case NAME: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam());
                break;
            }
            case ACCEPTED: 
            case PUBLIC: 
            case SHARED: 
            case SEARCHABLE: 
            case UNDER_CONSTRUCTION: {
                q.setParameter(filterBy.getField(), (Object)this.getBooleanValue(filterBy.getParam()));
                break;
            }
            case TYPE: {
                q.setParameter(filterBy.getField(), (Object)this.getEnumValue(filterBy.getField(), filterBy.getValue(), DatasetType.class));
                break;
            }
            case HDFS_USER: {
                q.setParameter(filterBy.getField(), (Object)this.inodeFacade.gethdfsUser(filterBy.getParam()));
                break;
            }
            case USER_EMAIL: {
                q.setParameter(filterBy.getField(), (Object)this.inodeFacade.getUsers(filterBy.getParam(), project));
                break;
            }
            case ACCESS_TIME: 
            case ACCESS_TIME_GT: 
            case ACCESS_TIME_LT: 
            case MODIFICATION_TIME: 
            case MODIFICATION_TIME_GT: 
            case MODIFICATION_TIME_LT: {
                Date date = this.getDate(filterBy.getField(), filterBy.getParam());
                q.setParameter(filterBy.getField(), (Object)date.getTime());
                break;
            }
            case SIZE: 
            case SIZE_LT: 
            case SIZE_GT: {
                q.setParameter(filterBy.getField(), (Object)this.getIntValue(filterBy));
                break;
            }
        }
    }

    public static enum Filters {
        NAME("NAME", "d.name LIKE CONCAT(:name, '%') ", "name", " "),
        USER_EMAIL("USER_EMAIL", "d.inode.hdfsUser =:user ", "user", " "),
        HDFS_USER("HDFS_USER", "d.inode.hdfsUser =:hdfsUser ", "hdfsUser", " "),
        UNDER_CONSTRUCTION("UNDER_CONSTRUCTION", "d.inode.underConstruction  =:underConstruction ", "underConstruction", "true"),
        ACCEPTED("ACCEPTED", "true =:accepted ", "accepted", "true"),
        SHARED("SHARED", "NOT :shared ", "shared", "true"),
        SEARCHABLE("SEARCHABLE", "d.searchable =:searchable ", "searchable", "0"),
        TYPE("TYPE", "d.dsType =:dsType ", "dsType", "DATASET"),
        PUBLIC("PUBLIC", "d.public =:public ", "public", "0"),
        MODIFICATION_TIME("MODIFICATION_TIME", "d.inode.modificationTime  =:modificationTime ", "modificationTime", ""),
        MODIFICATION_TIME_LT("MODIFICATION_TIME_LT", "d.inode.modificationTime  <:modificationTime_lt ", "modificationTime_lt", ""),
        MODIFICATION_TIME_GT("MODIFICATION_TIME_GT", "d.inode.modificationTime  >:modificationTime_gt ", "modificationTime_gt", ""),
        ACCESS_TIME("ACCESS_TIME", "d.inode.accessTime  =:accessTime ", "accessTime", ""),
        ACCESS_TIME_LT("ACCESS_TIME_LT", "d.inode.accessTime  <:accessTime_lt ", "accessTime_lt", ""),
        ACCESS_TIME_GT("ACCESS_TIME_GT", "d.inode.accessTime  >:accessTime_gt ", "accessTime_gt", ""),
        SIZE("SIZE", "d.inode.size  =:size_eq ", "size_eq", "0"),
        SIZE_LT("SIZE_LT", "d.inode.size  <:size_lt ", "size_lt", "1"),
        SIZE_GT("SIZE_GT", "d.inode.size  >:size_gt ", "size_gt", "0");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", "d.id ", "ASC"),
        NAME("NAME", "LOWER(d.name) ", "ASC"),
        SEARCHABLE("SEARCHABLE", "d.searchable ", "ASC"),
        MODIFICATION_TIME("MODIFICATION_TIME", "d.inode.modificationTime ", "ASC"),
        ACCESS_TIME("ACCESS_TIME", "d.inode.accessTime ", "ASC"),
        PUBLIC("PUBLIC", "d.public ", "ASC"),
        SIZE("SIZE", "d.inode.size ", "ASC"),
        TYPE("TYPE", "d.dsType ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

