/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.hdfs;

import java.io.Serializable;
import java.math.BigInteger;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="hops.hdfs_directory_with_quota_feature")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="HdfsDirectoryWithQuotaFeature.findAll", query="SELECT h FROM HdfsDirectoryWithQuotaFeature h"), @NamedQuery(name="HdfsDirectoryWithQuotaFeature.findByInodeId", query="SELECT h FROM HdfsDirectoryWithQuotaFeature h WHERE h.inodeId = :inodeId"), @NamedQuery(name="HdfsDirectoryWithQuotaFeature.findByNsquota", query="SELECT h FROM HdfsDirectoryWithQuotaFeature h WHERE h.nsquota = :nsquota"), @NamedQuery(name="HdfsDirectoryWithQuotaFeature.findBySsquota", query="SELECT h FROM HdfsDirectoryWithQuotaFeature h WHERE h.ssquota = :ssquota"), @NamedQuery(name="HdfsDirectoryWithQuotaFeature.findByNscount", query="SELECT h FROM HdfsDirectoryWithQuotaFeature h WHERE h.nscount = :nscount"), @NamedQuery(name="HdfsDirectoryWithQuotaFeature.findByStorageSpace", query="SELECT h FROM HdfsDirectoryWithQuotaFeature h WHERE h.storageSpace = :storageSpace")})
public class HdfsDirectoryWithQuotaFeature
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long MB = 0x100000L;
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="inodeId")
    private Long inodeId;
    @Column(name="nsquota")
    private BigInteger nsquota;
    @Column(name="ssquota")
    private BigInteger ssquota;
    @Column(name="nscount")
    private BigInteger nscount;
    @Column(name="storage_space")
    private BigInteger storageSpace;
    @Column(name="typespace_quota_disk")
    private BigInteger typespaceQuotaDisk = BigInteger.valueOf(-1L);
    @Column(name="typespace_quota_ssd")
    private BigInteger typespaceQuotaSsd = BigInteger.valueOf(-1L);
    @Column(name="typespace_quota_raid5")
    private BigInteger typespaceQuotaRaid5 = BigInteger.valueOf(-1L);
    @Column(name="typespace_quota_archive")
    private BigInteger typespaceQuotaArchive = BigInteger.valueOf(-1L);
    @Column(name="typespace_used_disk")
    private BigInteger typespaceUsedDisk = BigInteger.valueOf(-1L);
    @Column(name="typespace_used_ssd")
    private BigInteger typespaceUsedSsd = BigInteger.valueOf(-1L);
    @Column(name="typespace_used_raid5")
    private BigInteger typespaceUsedRaid5 = BigInteger.valueOf(-1L);
    @Column(name="typespace_used_archive")
    private BigInteger typespaceUsedArchive = BigInteger.valueOf(-1L);

    public HdfsDirectoryWithQuotaFeature() {
    }

    public HdfsDirectoryWithQuotaFeature(Long inodeId) {
        this.inodeId = inodeId;
    }

    public Long getInodeId() {
        return this.inodeId;
    }

    public void setInodeId(Long inodeId) {
        this.inodeId = inodeId;
    }

    public BigInteger getNsquota() {
        return this.nsquota;
    }

    public void setNsquota(BigInteger nsquota) {
        this.nsquota = nsquota;
    }

    public BigInteger getSsquota() {
        return this.ssquota;
    }

    public long getSsquotaInMBs() {
        long quota = this.ssquota.longValue();
        return quota /= 0x100000L;
    }

    public void setSsquota(BigInteger ssquota) {
        this.ssquota = ssquota;
    }

    public BigInteger getNscount() {
        return this.nscount;
    }

    public void setNscount(BigInteger nscount) {
        this.nscount = nscount;
    }

    public BigInteger getStorageSpace() {
        return this.storageSpace;
    }

    public long getStorageSpaceInMBs() {
        long quota = this.storageSpace.longValue();
        return quota /= 0x100000L;
    }

    public void setStorageSpaceInMBs(long storageSpaceInMBs) {
        this.storageSpace = BigInteger.valueOf(storageSpaceInMBs * 0x100000L);
    }

    public void setStorageSpace(BigInteger storageSpace) {
        this.storageSpace = storageSpace;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.inodeId != null ? this.inodeId.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HdfsDirectoryWithQuotaFeature)) {
            return false;
        }
        HdfsDirectoryWithQuotaFeature other = (HdfsDirectoryWithQuotaFeature)object;
        return (this.inodeId != null || other.inodeId == null) && (this.inodeId == null || this.inodeId.equals(other.inodeId));
    }

    public String toString() {
        return "se.kth.hopsworks.hdfs.fileoperations.HdfsDirectoryWithQuotaFeature[ inodeId=" + this.inodeId + " ]";
    }

    public BigInteger getTypespaceQuotaDisk() {
        return this.typespaceQuotaDisk;
    }

    public void setTypespaceQuotaDisk(BigInteger typespaceQuotaDisk) {
        this.typespaceQuotaDisk = typespaceQuotaDisk;
    }

    public BigInteger getTypespaceQuotaSsd() {
        return this.typespaceQuotaSsd;
    }

    public void setTypespaceQuotaSsd(BigInteger typespaceQuotaSsd) {
        this.typespaceQuotaSsd = typespaceQuotaSsd;
    }

    public BigInteger getTypespaceQuotaRaid5() {
        return this.typespaceQuotaRaid5;
    }

    public void setTypespaceQuotaRaid5(BigInteger typespaceQuotaRaid5) {
        this.typespaceQuotaRaid5 = typespaceQuotaRaid5;
    }

    public BigInteger getTypespaceQuotaArchive() {
        return this.typespaceQuotaArchive;
    }

    public void setTypespaceQuotaArchive(BigInteger typespaceQuotaArchive) {
        this.typespaceQuotaArchive = typespaceQuotaArchive;
    }

    public BigInteger getTypespaceUsedDisk() {
        return this.typespaceUsedDisk;
    }

    public void setTypespaceUsedDisk(BigInteger typespaceUsedDisk) {
        this.typespaceUsedDisk = typespaceUsedDisk;
    }

    public BigInteger getTypespaceUsedSsd() {
        return this.typespaceUsedSsd;
    }

    public void setTypespaceUsedSsd(BigInteger typespaceUsedSsd) {
        this.typespaceUsedSsd = typespaceUsedSsd;
    }

    public BigInteger getTypespaceUsedRaid5() {
        return this.typespaceUsedRaid5;
    }

    public void setTypespaceUsedRaid5(BigInteger typespaceUsedRaid5) {
        this.typespaceUsedRaid5 = typespaceUsedRaid5;
    }

    public BigInteger getTypespaceUsedArchive() {
        return this.typespaceUsedArchive;
    }

    public void setTypespaceUsedArchive(BigInteger typespaceUsedArchive) {
        this.typespaceUsedArchive = typespaceUsedArchive;
    }
}

