/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.online;

import io.hops.hopsworks.common.dao.featurestore.Featurestore;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.online.OnlineFeaturegroup;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.RowValueQueryResult;
import io.hops.hopsworks.common.featurestore.featuregroup.online.OnlineFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.online.OnlineFeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import java.sql.SQLException;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
public class OnlineFeaturegroupController {
    @EJB
    private OnlineFeaturegroupFacade onlineFeaturegroupFacade;
    @EJB
    private OnlineFeaturestoreController onlineFeaturestoreController;

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    private OnlineFeaturegroup persistOnlineFeaturegroupMetadata(String dbName, String tableName) {
        OnlineFeaturegroup onlineFeaturegroup = new OnlineFeaturegroup();
        onlineFeaturegroup.setDbName(dbName);
        onlineFeaturegroup.setTableName(tableName);
        this.onlineFeaturegroupFacade.persist(onlineFeaturegroup);
        return onlineFeaturegroup;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void dropMySQLTable(OnlineFeaturegroup onlineFeaturegroup, Featurestore featurestore, Users user) throws SQLException, FeaturestoreException {
        String query = "DROP TABLE " + onlineFeaturegroup.getTableName() + ";";
        this.onlineFeaturestoreController.executeUpdateJDBCQuery(query, onlineFeaturegroup.getDbName(), featurestore.getProject(), user);
        this.removeOnlineFeaturegroupMetadata(onlineFeaturegroup);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public OnlineFeaturegroup removeOnlineFeaturegroupMetadata(OnlineFeaturegroup onlineFeaturegroup) {
        this.onlineFeaturegroupFacade.remove(onlineFeaturegroup);
        return onlineFeaturegroup;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public OnlineFeaturegroup createMySQLTable(Featurestore featurestore, Users user, String featureStr, String tableName) throws FeaturestoreException, SQLException {
        String db = this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featurestore.getProject());
        String query = "CREATE TABLE " + db + ".`" + tableName + "` " + featureStr;
        this.onlineFeaturestoreController.executeUpdateJDBCQuery(query, db, featurestore.getProject(), user);
        return this.persistOnlineFeaturegroupMetadata(db, tableName);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public OnlineFeaturegroupDTO convertOnlineFeaturegroupToDTO(OnlineFeaturegroup onlineFeaturegroup) {
        OnlineFeaturegroupDTO onlineFeaturegroupDTO = new OnlineFeaturegroupDTO(onlineFeaturegroup);
        onlineFeaturegroupDTO.setTableType(this.onlineFeaturestoreController.getOnlineFeaturegroupTableType(onlineFeaturegroupDTO));
        onlineFeaturegroupDTO.setSize(this.onlineFeaturestoreController.getTblSize(onlineFeaturegroupDTO));
        onlineFeaturegroupDTO.setTableRows(this.onlineFeaturestoreController.getOnlineFeaturegroupTableRows(onlineFeaturegroupDTO));
        return onlineFeaturegroupDTO;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public List<FeatureDTO> getOnlineFeaturegroupFeatures(OnlineFeaturegroup onlineFeaturegroup) {
        return this.onlineFeaturestoreController.getOnlineFeaturegroupFeatures(onlineFeaturegroup);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public String getOnlineFeaturegroupSchema(OnlineFeaturegroupDTO onlineFeaturegroupDTO) {
        return this.onlineFeaturestoreController.getOnlineFeaturegroupSchema(onlineFeaturegroupDTO);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public List<RowValueQueryResult> getOnlineFeaturegroupPreview(OnlineFeaturegroupDTO onlineFeaturegroupDTO, Users user, Featurestore featurestore) throws FeaturestoreException, SQLException {
        return this.onlineFeaturestoreController.getOnlineFeaturegroupPreview(onlineFeaturegroupDTO, user, featurestore);
    }
}

