/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.dataset.Dataset;
import io.hops.hopsworks.common.dao.featurestore.Featurestore;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.hopsfs.FeaturestoreHopsfsConnector;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs.FeaturestoreHopsfsConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs.FeaturestoreHopsfsConnectorFacade;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class FeaturestoreHopsfsConnectorController {
    @EJB
    private FeaturestoreHopsfsConnectorFacade featurestoreHopsfsConnectorFacade;
    @EJB
    private InodeController inodeController;
    @EJB
    private DatasetController datasetController;

    public FeaturestoreHopsfsConnectorDTO createFeaturestoreHopsfsConnector(Featurestore featurestore, FeaturestoreHopsfsConnectorDTO featurestoreHopsfsConnectorDTO) throws FeaturestoreException {
        this.verifyUserInput(featurestore, featurestoreHopsfsConnectorDTO);
        Dataset dataset = this.datasetController.getByProjectAndDsName(featurestore.getProject(), null, featurestoreHopsfsConnectorDTO.getDatasetName());
        FeaturestoreHopsfsConnector featurestoreHopsfsConnector = new FeaturestoreHopsfsConnector();
        featurestoreHopsfsConnector.setName(featurestoreHopsfsConnectorDTO.getName());
        featurestoreHopsfsConnector.setDescription(featurestoreHopsfsConnectorDTO.getDescription());
        featurestoreHopsfsConnector.setHopsfsDataset(dataset);
        featurestoreHopsfsConnector.setFeaturestore(featurestore);
        this.featurestoreHopsfsConnectorFacade.persist(featurestoreHopsfsConnector);
        return this.convertHopsfsConnectorToDTO(featurestoreHopsfsConnector);
    }

    public FeaturestoreHopsfsConnectorDTO updateFeaturestoreHopsfsConnector(Featurestore featurestore, FeaturestoreHopsfsConnectorDTO featurestoreHopsfsConnectorDTO, Integer storageConnectorId) throws FeaturestoreException {
        FeaturestoreHopsfsConnector featurestoreHopsfsConnector = this.verifyHopsfStorageConnectorId(storageConnectorId, featurestore);
        if (!Strings.isNullOrEmpty((String)featurestoreHopsfsConnectorDTO.getDatasetName())) {
            this.verifyHopsfsConnectorDatasetName(featurestoreHopsfsConnectorDTO.getDatasetName(), featurestore);
            Dataset dataset = this.datasetController.getByProjectAndDsName(featurestore.getProject(), null, featurestoreHopsfsConnectorDTO.getDatasetName());
            featurestoreHopsfsConnector.setHopsfsDataset(dataset);
        }
        if (!Strings.isNullOrEmpty((String)featurestoreHopsfsConnectorDTO.getName())) {
            this.verifyHopsfsConnectorName(featurestoreHopsfsConnectorDTO.getName(), featurestore, true);
            featurestoreHopsfsConnector.setName(featurestoreHopsfsConnectorDTO.getName());
        }
        if (!Strings.isNullOrEmpty((String)featurestoreHopsfsConnectorDTO.getDescription())) {
            this.verifyHopsfsConnectorDescription(featurestoreHopsfsConnectorDTO.getDescription());
            featurestoreHopsfsConnector.setDescription(featurestoreHopsfsConnectorDTO.getDescription());
        }
        if (featurestore != null) {
            featurestoreHopsfsConnector.setFeaturestore(featurestore);
        }
        FeaturestoreHopsfsConnector updatedFeaturestoreHopsfsConnector = this.featurestoreHopsfsConnectorFacade.updateHopsfsConnector(featurestoreHopsfsConnector);
        return this.convertHopsfsConnectorToDTO(updatedFeaturestoreHopsfsConnector);
    }

    public void createHopsFsBackendForFeaturestoreConnector(Featurestore featurestore, Dataset hopsfsDataset) throws FeaturestoreException {
        String name = hopsfsDataset.getName();
        String description = "HOPSFS backend for storing Training Datasets of the Hopsworks Feature Store";
        FeaturestoreHopsfsConnectorDTO featurestoreHopsfsConnectorDTO = new FeaturestoreHopsfsConnectorDTO();
        featurestoreHopsfsConnectorDTO.setName(name);
        featurestoreHopsfsConnectorDTO.setDescription(description);
        featurestoreHopsfsConnectorDTO.setDatasetName(hopsfsDataset.getName());
        this.createFeaturestoreHopsfsConnector(featurestore, featurestoreHopsfsConnectorDTO);
    }

    public FeaturestoreHopsfsConnectorDTO removeFeaturestoreHopsfsConnector(Integer featurestoreHopsfsId) {
        FeaturestoreHopsfsConnector featurestoreHopsfsConnector = (FeaturestoreHopsfsConnector)this.featurestoreHopsfsConnectorFacade.find(featurestoreHopsfsId);
        FeaturestoreHopsfsConnectorDTO featurestoreHopsfsConnectorDTO = this.convertHopsfsConnectorToDTO(featurestoreHopsfsConnector);
        this.featurestoreHopsfsConnectorFacade.remove(featurestoreHopsfsConnector);
        return featurestoreHopsfsConnectorDTO;
    }

    private FeaturestoreHopsfsConnector verifyHopsfStorageConnectorId(Integer storageConnectorId, Featurestore featurestore) throws FeaturestoreException {
        FeaturestoreHopsfsConnector featurestoreHopsfsConnector = this.featurestoreHopsfsConnectorFacade.findByIdAndFeaturestore(storageConnectorId, featurestore);
        if (featurestoreHopsfsConnector == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.HOPSFS_CONNECTOR_NOT_FOUND, Level.FINE, "HopsFsConnectorId: " + storageConnectorId);
        }
        return featurestoreHopsfsConnector;
    }

    private void verifyHopsfsConnectorName(String name, Featurestore featurestore, Boolean edit) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, ", the storage connector name cannot be empty");
        }
        if (name.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, ", the name should be less than 1000 characters.");
        }
        if (!edit.booleanValue() && featurestore.getHopsfsConnections().stream().anyMatch(hopsfsCon -> hopsfsCon.getName().equalsIgnoreCase(name))) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, ", the storage connector name should be unique, there already exists a HOPSFS connector with the same name ");
        }
    }

    private void verifyFeaturestoreInput(Featurestore featurestore) {
        if (featurestore == null) {
            throw new IllegalArgumentException("Featurestore was not found");
        }
    }

    private void verifyHopsfsConnectorDescription(String description) throws FeaturestoreException {
        if (description.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_DESCRIPTION, Level.FINE, ", the description should be less than: 1000");
        }
    }

    private void verifyHopsfsConnectorDatasetName(String datasetName, Featurestore featurestore) throws FeaturestoreException {
        Dataset dataset = this.datasetController.getByProjectAndDsName(featurestore.getProject(), null, datasetName);
        if (dataset == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_HOPSFS_CONNECTOR_DATASET, Level.FINE, ", the dataset could not be found");
        }
    }

    private void verifyUserInput(Featurestore featurestore, FeaturestoreHopsfsConnectorDTO featurestoreHopsfsConnectorDTO) throws FeaturestoreException {
        if (featurestoreHopsfsConnectorDTO == null) {
            throw new IllegalArgumentException("Input data is null");
        }
        this.verifyFeaturestoreInput(featurestore);
        this.verifyHopsfsConnectorName(featurestoreHopsfsConnectorDTO.getName(), featurestore, false);
        this.verifyHopsfsConnectorDescription(featurestoreHopsfsConnectorDTO.getDescription());
        this.verifyHopsfsConnectorDatasetName(featurestoreHopsfsConnectorDTO.getDatasetName(), featurestore);
    }

    public List<FeaturestoreStorageConnectorDTO> getHopsfsConnectors(Featurestore featurestore) {
        List<FeaturestoreHopsfsConnector> hopsfsConnectors = this.featurestoreHopsfsConnectorFacade.findByFeaturestore(featurestore);
        return hopsfsConnectors.stream().map(hopsfsConnector -> this.convertHopsfsConnectorToDTO((FeaturestoreHopsfsConnector)hopsfsConnector)).collect(Collectors.toList());
    }

    public FeaturestoreHopsfsConnectorDTO getHopsFsConnectorWithIdAndFeaturestore(Featurestore featurestore, Integer id) throws FeaturestoreException {
        FeaturestoreHopsfsConnector featurestoreHopsfsConnector = this.verifyHopsfStorageConnectorId(id, featurestore);
        return this.convertHopsfsConnectorToDTO(featurestoreHopsfsConnector);
    }

    private FeaturestoreHopsfsConnectorDTO convertHopsfsConnectorToDTO(FeaturestoreHopsfsConnector featurestoreHopsfsConnector) {
        FeaturestoreHopsfsConnectorDTO featurestoreHopsfsConnectorDTO = new FeaturestoreHopsfsConnectorDTO(featurestoreHopsfsConnector);
        featurestoreHopsfsConnectorDTO.setHopsfsPath(this.inodeController.getPath(featurestoreHopsfsConnector.getHopsfsDataset().getInode()));
        return featurestoreHopsfsConnectorDTO;
    }
}

