/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.hops.hopsworks.common.dao.certificates.CertsFacade;
import io.hops.hopsworks.common.dao.command.SystemCommand;
import io.hops.hopsworks.common.dao.command.SystemCommandFacade;
import io.hops.hopsworks.common.dao.dela.certs.ClusterCertificateFacade;
import io.hops.hopsworks.common.dao.host.Hosts;
import io.hops.hopsworks.common.dao.host.HostsFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.message.MessageController;
import io.hops.hopsworks.common.security.MasterPasswordChangeResult;
import io.hops.hopsworks.common.security.MasterPasswordHandler;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.EncryptionMasterPasswordException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.AccessTimeout;
import javax.ejb.Asynchronous;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
public class CertificatesMgmService {
    private final Logger LOG = Logger.getLogger(CertificatesMgmService.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private UserFacade userFacade;
    @EJB
    private CertsFacade certsFacade;
    @EJB
    private ClusterCertificateFacade clusterCertificateFacade;
    @EJB
    private MessageController messageController;
    @EJB
    private SystemCommandFacade systemCommandFacade;
    @EJB
    private HostsFacade hostsFacade;
    @Inject
    @Any
    private Instance<MasterPasswordHandler> handlers;
    private File masterPasswordFile;
    private final Map<Class, MasterPasswordChangeResult> handlersResult = new HashMap<Class, MasterPasswordChangeResult>();
    private Cache<Integer, UPDATE_STATUS> updateStatus;
    private Random rand;

    @PostConstruct
    public void init() {
        this.masterPasswordFile = new File(this.settings.getHopsworksMasterEncPasswordFile());
        if (!this.masterPasswordFile.exists()) {
            throw new IllegalStateException("Master encryption file does not exist");
        }
        try {
            PosixFileAttributeView fileView = Files.getFileAttributeView(this.masterPasswordFile.toPath(), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            Set<PosixFilePermission> filePermissions = fileView.readAttributes().permissions();
            boolean ownerRead = filePermissions.contains((Object)PosixFilePermission.OWNER_READ);
            boolean ownerWrite = filePermissions.contains((Object)PosixFilePermission.OWNER_WRITE);
            boolean ownerExecute = filePermissions.contains((Object)PosixFilePermission.OWNER_EXECUTE);
            boolean groupRead = filePermissions.contains((Object)PosixFilePermission.GROUP_READ);
            boolean groupWrite = filePermissions.contains((Object)PosixFilePermission.GROUP_WRITE);
            boolean groupExecute = filePermissions.contains((Object)PosixFilePermission.GROUP_EXECUTE);
            boolean othersRead = filePermissions.contains((Object)PosixFilePermission.OTHERS_READ);
            boolean othersWrite = filePermissions.contains((Object)PosixFilePermission.OTHERS_WRITE);
            boolean othersExecute = filePermissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE);
            if (!ownerRead || !ownerWrite || !ownerExecute || groupRead || groupWrite || groupExecute || othersRead || othersWrite || othersExecute) {
                throw new IllegalStateException("Wrong permissions for file " + this.masterPasswordFile.getAbsolutePath() + ", it should be 700");
            }
            String owner = fileView.readAttributes().owner().getName();
            String group = fileView.readAttributes().group().getName();
            String permStr = PosixFilePermissions.toString(filePermissions);
            this.LOG.log(Level.INFO, "Passed permissions check for file " + this.masterPasswordFile.getAbsolutePath() + ". Owner: " + owner + " Group: " + group + " Permissions: " + permStr);
            this.updateStatus = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(12L, TimeUnit.HOURS).build();
            this.rand = new Random();
        }
        catch (UnsupportedOperationException ex) {
            this.LOG.log(Level.WARNING, "Associated filesystem is not POSIX compliant. Continue without checking the permissions of " + this.masterPasswordFile.getAbsolutePath() + " This might be a security problem.");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error while getting POSIX permissions of " + this.masterPasswordFile.getAbsolutePath());
        }
    }

    @Lock(value=LockType.READ)
    @AccessTimeout(value=3L, unit=TimeUnit.SECONDS)
    public String getMasterEncryptionPassword() throws IOException {
        return FileUtils.readFileToString((File)this.masterPasswordFile).trim();
    }

    @Lock(value=LockType.READ)
    @AccessTimeout(value=3L, unit=TimeUnit.SECONDS)
    public void checkPassword(String providedPassword, String userRequestedEmail) throws IOException, EncryptionMasterPasswordException {
        String sha = DigestUtils.sha256Hex((String)providedPassword);
        if (!this.getMasterEncryptionPassword().equals(sha)) {
            Users user = this.userFacade.findByEmail(userRequestedEmail);
            String logMsg = "*** Attempt to change master encryption password with wrong credentials";
            if (user != null) {
                this.LOG.log(Level.INFO, logMsg + " by user <" + user.getUsername() + ">");
            } else {
                this.LOG.log(Level.INFO, logMsg);
            }
            throw new EncryptionMasterPasswordException("Provided password is incorrect");
        }
    }

    public Integer initUpdateOperation() {
        Integer operationId = this.rand.nextInt();
        this.updateStatus.put((Object)operationId, (Object)UPDATE_STATUS.WORKING);
        return operationId;
    }

    public UPDATE_STATUS getOperationStatus(Integer operationId) {
        UPDATE_STATUS status = (UPDATE_STATUS)((Object)this.updateStatus.getIfPresent((Object)operationId));
        return status != null ? status : UPDATE_STATUS.NOT_FOUND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Asynchronous
    @Lock(value=LockType.WRITE)
    @AccessTimeout(value=500L)
    public void resetMasterEncryptionPassword(Integer operationId, String newMasterPasswd, String userRequested) {
        try {
            String newDigest = DigestUtils.sha256Hex((String)newMasterPasswd);
            this.callUpdateHandlers(newDigest);
            this.updateMasterEncryptionPassword(newDigest);
            StringBuilder successLog = this.gatherLogs();
            this.sendSuccessfulMessage(successLog, userRequested);
            this.updateStatus.put((Object)operationId, (Object)UPDATE_STATUS.OK);
            this.LOG.log(Level.INFO, "Master encryption password changed!");
        }
        catch (EncryptionMasterPasswordException ex) {
            String errorMsg = "*** Master encryption password update failed!!! Rolling back...";
            this.LOG.log(Level.SEVERE, errorMsg, ex);
            this.updateStatus.put((Object)operationId, (Object)UPDATE_STATUS.FAILED);
            this.callRollbackHandlers();
            this.sendUnsuccessfulMessage(errorMsg + "\n" + ex.getMessage(), userRequested);
        }
        catch (IOException ex) {
            String errorMsg = "*** Failed to write new encryption password to file: " + this.masterPasswordFile.getAbsolutePath() + ". Rolling back...";
            this.LOG.log(Level.SEVERE, errorMsg, ex);
            this.updateStatus.put((Object)operationId, (Object)UPDATE_STATUS.FAILED);
            this.callRollbackHandlers();
            this.sendUnsuccessfulMessage(errorMsg + "\n" + ex.getMessage(), userRequested);
        }
        finally {
            this.handlersResult.clear();
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void issueServiceKeyRotationCommand() {
        List allHosts = this.hostsFacade.findAll();
        for (Hosts host : allHosts) {
            SystemCommand rotateCommand = new SystemCommand(host, SystemCommandFacade.OP.SERVICE_KEY_ROTATION);
            this.systemCommandFacade.persist(rotateCommand);
        }
    }

    private void callUpdateHandlers(String newDigest) throws EncryptionMasterPasswordException, IOException {
        for (MasterPasswordHandler handler : this.handlers) {
            MasterPasswordChangeResult result = handler.perform(this.getMasterEncryptionPassword(), newDigest);
            this.handlersResult.put(handler.getClass(), result);
            if (result.getCause() == null) continue;
            throw result.getCause();
        }
    }

    private void callRollbackHandlers() {
        for (MasterPasswordHandler handler : this.handlers) {
            MasterPasswordChangeResult result = this.handlersResult.get(handler.getClass());
            if (result == null) continue;
            handler.rollback(result);
        }
    }

    private StringBuilder gatherLogs() {
        StringBuilder successLog = new StringBuilder();
        for (MasterPasswordChangeResult result : this.handlersResult.values()) {
            if (result.getSuccessLog() == null) continue;
            successLog.append((CharSequence)result.getSuccessLog());
            successLog.append("\n\n");
        }
        return successLog;
    }

    private void updateMasterEncryptionPassword(String newPassword) throws IOException {
        FileUtils.writeStringToFile((File)this.masterPasswordFile, (String)newPassword);
    }

    private void sendSuccessfulMessage(StringBuilder successLog, String userRequested) {
        this.sendInbox(successLog.toString(), "Changed successfully", userRequested);
    }

    private void sendUnsuccessfulMessage(String message, String userRequested) {
        this.sendInbox(message, "Change failed!", userRequested);
    }

    private void sendInbox(String message, String preview, String userRequested) {
        Users to = this.userFacade.findByEmail(userRequested);
        Users from = this.userFacade.findByEmail(this.settings.getAdminEmail());
        this.messageController.send(to, from, "Master encryption password changed", preview, message, "");
    }

    public static enum UPDATE_STATUS {
        OK,
        WORKING,
        FAILED,
        NOT_FOUND;

    }
}

