/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import io.hops.hopsworks.common.dao.certificates.UserCerts;
import io.hops.hopsworks.common.dao.hdfs.inode.Inode;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.FsPermissions;
import io.hops.hopsworks.common.jobs.configuration.JobType;
import io.hops.hopsworks.common.jobs.yarn.LocalResourceDTO;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.util.templates.AppendConfigReplacementPolicy;
import io.hops.hopsworks.common.util.templates.ConfigProperty;
import io.hops.hopsworks.common.util.templates.ConfigReplacementPolicy;
import io.hops.hopsworks.common.util.templates.IgnoreConfigReplacementPolicy;
import io.hops.hopsworks.common.util.templates.OverwriteConfigReplacementPolicy;
import io.hops.hopsworks.exceptions.CryptoPasswordNotFoundException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.Key;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.net.util.Base64;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.json.JSONObject;

public class HopsUtils {
    private static final Logger LOG = Logger.getLogger(HopsUtils.class.getName());
    private static final long ROOT_DIR_PARTITION_KEY = 0L;
    public static final short ROOT_DIR_DEPTH = 0;
    private static int RANDOM_PARTITIONING_MAX_LEVEL = 1;
    public static long ROOT_INODE_ID = 1L;
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("\\r?\\n");
    private static final Pattern JOB_PROPS_PATTERN = Pattern.compile("(.+?)=(.+)");
    public static final ConfigReplacementPolicy OVERWRITE = new OverwriteConfigReplacementPolicy();
    public static final ConfigReplacementPolicy IGNORE = new IgnoreConfigReplacementPolicy();
    public static final ConfigReplacementPolicy APPEND_SPACE = new AppendConfigReplacementPolicy(AppendConfigReplacementPolicy.Delimiter.SPACE);
    public static final ConfigReplacementPolicy APPEND_PATH = new AppendConfigReplacementPolicy(AppendConfigReplacementPolicy.Delimiter.PATH_SEPARATOR);
    public static final ConfigReplacementPolicy APPEND_COMMA = new AppendConfigReplacementPolicy(AppendConfigReplacementPolicy.Delimiter.COMMA);

    public static <E extends Enum<E>> boolean isInEnum(String value, Class<E> enumClass) {
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            if (!e.name().equals(value)) continue;
            return true;
        }
        return false;
    }

    public static long dataSetPartitionId(Inode parent, String name) {
        return HopsUtils.calculatePartitionId(parent.getId(), name, 3);
    }

    public static long calculatePartitionId(long parentId, String name, int depth) {
        if (HopsUtils.isTreeLevelRandomPartitioned(depth)) {
            return HopsUtils.partitionIdHashFunction(parentId, name, depth);
        }
        return parentId;
    }

    private static long partitionIdHashFunction(long parentId, String name, int depth) {
        if (depth == 0) {
            return 0L;
        }
        return (name + parentId).hashCode();
    }

    private static boolean isTreeLevelRandomPartitioned(int depth) {
        return depth <= RANDOM_PARTITIONING_MAX_LEVEL;
    }

    public static String getProjectKeystoreName(String project, String user) {
        return project + "__" + user + "__kstore.jks";
    }

    public static String getProjectTruststoreName(String project, String user) {
        return project + "__" + user + "__tstore.jks";
    }

    public static String getProjectMaterialPasswordName(String project, String user) {
        return project + "__" + user + "__cert.key";
    }

    public static void copyProjectUserCerts(Project project, String username, String localTmpDir, String remoteTmpDir, CertificateMaterializer certMat, boolean isRpcTlsEnabled) {
        HopsUtils.copyProjectUserCerts(project, username, localTmpDir, remoteTmpDir, null, null, null, null, null, null, certMat, isRpcTlsEnabled);
    }

    public static void cleanupCertificatesForUserCustomDir(String username, String projectName, String remoteFSDir, CertificateMaterializer certificateMaterializer, String directory, Settings settings) {
        certificateMaterializer.removeCertificatesLocalCustomDir(username, projectName, directory);
        String projectSpecificUsername = projectName + "__" + username;
        if (!settings.getHopsRpcTls()) {
            String remoteDirectory = remoteFSDir + "/" + projectSpecificUsername;
            certificateMaterializer.removeCertificatesRemote(username, projectName, remoteDirectory);
        }
    }

    public static void materializeCertificatesForUserCustomDir(String projectName, String userName, String remoteFSDir, DistributedFileSystemOps dfso, CertificateMaterializer certificateMaterializer, Settings settings, String directory) throws IOException {
        String projectSpecificUsername = projectName + "__" + userName;
        certificateMaterializer.materializeCertificatesLocalCustomDir(userName, projectName, directory);
        if (!settings.getHopsRpcTls()) {
            String remoteDirectory = HopsUtils.createRemoteDirectory(remoteFSDir, projectSpecificUsername, projectSpecificUsername, dfso);
            certificateMaterializer.materializeCertificatesRemote(userName, projectName, projectSpecificUsername, projectSpecificUsername, FsPermissions.rwx______, remoteDirectory);
        }
    }

    private static String createRemoteDirectory(String remoteFSDir, String certsSpecificDir, String owner, DistributedFileSystemOps dfso) throws IOException {
        Path projectRemoteFSDir;
        boolean createdDir = false;
        if (!dfso.exists(remoteFSDir)) {
            Path remoteFSTarget = new Path(remoteFSDir);
            dfso.mkdir(remoteFSTarget, FsPermission.getDirDefault());
            dfso.setPermission(remoteFSTarget, FsPermissions.rwxrwxrwx);
            createdDir = true;
        }
        if (!dfso.exists((projectRemoteFSDir = new Path(remoteFSDir + "/" + certsSpecificDir)).toString())) {
            dfso.mkdir(projectRemoteFSDir, FsPermission.getDirDefault());
            dfso.setPermission(projectRemoteFSDir, FsPermissions.rwxrwx___);
            dfso.setOwner(projectRemoteFSDir, owner, owner);
            createdDir = true;
        }
        return projectRemoteFSDir.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyProjectUserCerts(Project project, String username, String localTmpDir, String remoteTmpDir, JobType jobType, DistributedFileSystemOps dfso, List<LocalResourceDTO> projectLocalResources, Map<String, String> jobSystemProperties, String flinkCertsDir, String applicationId, CertificateMaterializer certMat, boolean isRpcTlsEnabled) {
        block16: {
            UserCerts userCert = new UserCerts(project.getName(), username);
            try {
                certMat.materializeCertificatesLocal(username, project.getName());
                CertificateMaterializer.CryptoMaterial material = certMat.getUserMaterial(username, project.getName());
                userCert.setUserKey(material.getKeyStore().array());
                userCert.setUserCert(material.getTrustStore().array());
                userCert.setUserKeyPwd(new String(material.getPassword()));
            }
            catch (CryptoPasswordNotFoundException | IOException ex) {
                throw new RuntimeException("Could not materialize user certificates", ex);
            }
            if (userCert.getUserCert() != null && userCert.getUserCert().length > 0 && userCert.getUserKey() != null && userCert.getUserKey().length > 0) {
                HashMap<String, byte[]> certFiles = new HashMap<String, byte[]>();
                certFiles.put("t_certificate", userCert.getUserCert());
                certFiles.put("k_certificate", userCert.getUserKey());
                try {
                    String kCertName = HopsUtils.getProjectKeystoreName(project.getName(), username);
                    String tCertName = HopsUtils.getProjectTruststoreName(project.getName(), username);
                    String passName = HopsUtils.getProjectMaterialPasswordName(project.getName(), username);
                    try {
                        if (jobType == null) break block16;
                        switch (jobType) {
                            case PYSPARK: 
                            case SPARK: {
                                HashMap<String, File> certs = new HashMap<String, File>();
                                certs.put("k_certificate", new File(localTmpDir + File.separator + kCertName));
                                certs.put("t_certificate", new File(localTmpDir + File.separator + tCertName));
                                certs.put("material_passwd", new File(localTmpDir + File.separator + passName));
                                for (Map.Entry entry : certs.entrySet()) {
                                    if (!dfso.exists(remoteTmpDir)) {
                                        Path remoteTmpDirPath = new Path(remoteTmpDir);
                                        dfso.mkdir(remoteTmpDirPath, FsPermission.getDirDefault());
                                        dfso.setPermission(remoteTmpDirPath, FsPermissions.rwxrwxrwx);
                                    }
                                    String certUser = project.getName() + "__" + username;
                                    String remoteTmpProjDir = remoteTmpDir + File.separator + certUser;
                                    if (!dfso.exists(remoteTmpProjDir)) {
                                        Path remoteTmpProjDirPath = new Path(remoteTmpProjDir);
                                        dfso.mkdir(remoteTmpProjDirPath, FsPermission.getDirDefault());
                                        dfso.setPermission(remoteTmpProjDirPath, FsPermissions.rwxrwx___);
                                        dfso.setOwner(remoteTmpProjDirPath, certUser, certUser);
                                    }
                                    String remoteProjAppDir = remoteTmpProjDir + File.separator + applicationId;
                                    Path remoteProjAppPath = new Path(remoteProjAppDir);
                                    if (!dfso.exists(remoteProjAppDir)) {
                                        dfso.mkdir(remoteProjAppPath, FsPermission.getDirDefault());
                                        dfso.setPermission(remoteProjAppPath, FsPermissions.rwxrwx___);
                                        dfso.setOwner(remoteProjAppPath, certUser, certUser);
                                    }
                                    dfso.copyToHDFSFromLocal(false, ((File)entry.getValue()).getAbsolutePath(), remoteProjAppDir + File.separator + ((File)entry.getValue()).getName());
                                    dfso.setPermission(new Path(remoteProjAppDir + File.separator + ((File)entry.getValue()).getName()), FsPermissions.rwx______);
                                    dfso.setOwner(new Path(remoteProjAppDir + File.separator + ((File)entry.getValue()).getName()), certUser, certUser);
                                    projectLocalResources.add(new LocalResourceDTO((String)entry.getKey(), "hdfs://" + remoteProjAppDir + File.separator + ((File)entry.getValue()).getName(), LocalResourceVisibility.APPLICATION.toString(), LocalResourceType.FILE.toString(), null));
                                }
                                break;
                            }
                        }
                    }
                    catch (IOException ex) {
                        LOG.log(Level.SEVERE, "Error writing project user certificates to local fs", ex);
                    }
                }
                finally {
                    if (jobType != null) {
                        certMat.removeCertificatesLocal(username, project.getName());
                    }
                }
            }
        }
    }

    public static boolean jobNameValidator(String jobName, String dissalowedChars) {
        for (char c : dissalowedChars.toCharArray()) {
            if (!jobName.contains("" + c)) continue;
            return false;
        }
        return true;
    }

    private static Key generateKey(String userKey, String masterKey) {
        if (masterKey.equals("5fcf82bc15aef42cd3ec93e6d4b51c04df110cf77ee715f62f3f172ff8ed9de9")) {
            return new SecretKeySpec(userKey.substring(0, 16).getBytes(), "AES");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            sb.append(userKey.charAt(i));
            if (masterKey.length() > i + 1) {
                sb.append(masterKey.charAt(i + 1));
                continue;
            }
            sb.append(userKey.charAt(Math.max(0, userKey.length() - i)));
        }
        return new SecretKeySpec(sb.toString().getBytes(), "AES");
    }

    public static String encrypt(String key, String plaintext, String masterEncryptionPassword) throws Exception {
        Key aesKey = HopsUtils.generateKey(key, masterEncryptionPassword);
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, aesKey);
        byte[] encrypted = cipher.doFinal(plaintext.getBytes());
        return Base64.encodeBase64String((byte[])encrypted);
    }

    public static String decrypt(String key, String ciphertext, String masterEncryptionPassword) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        Key aesKey = HopsUtils.generateKey(key, masterEncryptionPassword);
        cipher.init(2, aesKey);
        String decrypted = new String(cipher.doFinal(Base64.decodeBase64((String)ciphertext)));
        return decrypted;
    }

    public static String randomString(int length) {
        char[] characterSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
        SecureRandom random = new SecureRandom();
        char[] result = new char[length];
        for (int i = 0; i < result.length; ++i) {
            int randomCharIndex = random.nextInt(characterSet.length);
            result[i] = characterSet[randomCharIndex];
        }
        return new String(result);
    }

    public static String spaceQuotaToString(long quota) {
        DecimalFormat df = new DecimalFormat("##.##");
        if (quota > 0x10000000000L) {
            float tbSize = quota / 0x10000000000L;
            return df.format(tbSize) + "TB";
        }
        if (quota > 0x40000000L) {
            float gbSize = quota / 0x40000000L;
            return df.format(gbSize) + "GB";
        }
        if (quota >= 0L) {
            float mbSize = quota / 0x100000L;
            return df.format(mbSize) + "MB";
        }
        return "-1MB";
    }

    public static long spaceQuotaToLong(String quotaString) {
        long quota = -1L;
        if (quotaString.endsWith("TB")) {
            quota = Long.parseLong(quotaString.substring(0, quotaString.length() - 2));
            quota *= 0x10000000000L;
        } else if (quotaString.endsWith("GB")) {
            quota = Long.parseLong(quotaString.substring(0, quotaString.length() - 2));
            quota *= 0x40000000L;
        } else if (quotaString.endsWith("MB")) {
            quota = Long.parseLong(quotaString.substring(0, quotaString.length() - 2));
            quota *= 0x100000L;
        } else {
            quota = Long.parseLong(quotaString);
        }
        return quota;
    }

    public static String procQuotaToString(float quota) {
        float absQuota = Math.abs(quota);
        long days = Math.round(Math.floor(absQuota / 86400.0f));
        long hours = Math.round(Math.floor((absQuota %= 86400.0f) / 3600.0f));
        long minutes = Math.round(Math.floor((absQuota %= 3600.0f) / 60.0f));
        int seconds = Math.round(absQuota % 60.0f);
        if (quota >= 0.0f) {
            return String.format("%02d:%02d:%02d:%02d", days, hours, minutes, seconds);
        }
        return String.format("-%02d:%02d:%02d:%02d", days, hours, minutes, seconds);
    }

    public static float procQuotaToFloat(String quota) {
        String[] quotaSplits = quota.split(":", 4);
        float quotaSeconds = 0.0f;
        quotaSeconds += Math.abs(Float.valueOf(quotaSplits[0]).floatValue()) * 86400.0f;
        quotaSeconds += Float.valueOf(quotaSplits[1]).floatValue() * 3600.0f;
        quotaSeconds += Float.valueOf(quotaSplits[2]).floatValue() * 60.0f;
        quotaSeconds += Float.valueOf(quotaSplits[3]).floatValue();
        if (Float.valueOf(quotaSplits[0]).floatValue() < 0.0f) {
            quotaSeconds *= -1.0f;
        }
        return quotaSeconds;
    }

    public static Map<String, String> parseUserProperties(String sparkProps) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (sparkProps != null) {
            Arrays.asList(NEW_LINE_PATTERN.split(sparkProps)).stream().map(l -> l.trim()).forEach(l -> {
                Matcher propMatcher = JOB_PROPS_PATTERN.matcher((CharSequence)l);
                if (propMatcher.matches()) {
                    properties.put(propMatcher.group(1), propMatcher.group(2));
                }
            });
        }
        if (LOG.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("User defined job properties are: ");
            if (properties.isEmpty()) {
                sb.append("NONE");
                LOG.log(Level.FINE, sb.toString());
            } else {
                for (Map.Entry prop : properties.entrySet()) {
                    sb.append((String)prop.getKey()).append("=").append((String)prop.getValue()).append("\n");
                }
                LOG.log(Level.FINE, sb.toString());
            }
        }
        return properties;
    }

    public static Map<String, String> validateUserProperties(String sparkProps, String sparkDir) throws IOException {
        Map<String, String> userProperties = HopsUtils.parseUserProperties(sparkProps);
        Set<String> blackListedProps = HopsUtils.readBlacklistedSparkProperties(sparkDir);
        for (String userProperty : userProperties.keySet()) {
            if (!blackListedProps.contains(userProperty)) continue;
            throw new IllegalArgumentException("User defined property <" + userProperty + "> is blacklisted!");
        }
        return userProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> readBlacklistedSparkProperties(String sparkDir) throws IOException {
        File sparkBlacklistFile = Paths.get(sparkDir, "conf/spark-blacklisted-properties.txt").toFile();
        LineIterator lineIterator = FileUtils.lineIterator((File)sparkBlacklistFile);
        HashSet<String> blacklistedProps = new HashSet<String>();
        try {
            while (lineIterator.hasNext()) {
                String line = lineIterator.nextLine();
                if (line.startsWith("#")) continue;
                blacklistedProps.add(line);
            }
            HashSet<String> hashSet = blacklistedProps;
            return hashSet;
        }
        finally {
            LineIterator.closeQuietly((LineIterator)lineIterator);
        }
    }

    public static Map<String, String> mergeHopsworksAndUserParams(Map<String, ConfigProperty> hopsworksParams, Map<String, String> userParameters) {
        HashMap<String, String> finalParams = new HashMap<String, String>();
        HashSet notReplacedUserParams = new HashSet();
        for (Map.Entry<String, String> userParam : userParameters.entrySet()) {
            if (hopsworksParams.containsKey(userParam.getKey())) {
                ConfigProperty prop = hopsworksParams.get(userParam.getKey());
                prop.replaceValue(userParam.getValue());
                finalParams.put(prop.getReplacementPattern(), prop.getValue());
                continue;
            }
            finalParams.put(userParam.getKey(), userParam.getValue());
        }
        String userParamsStr = "";
        if (!notReplacedUserParams.isEmpty()) {
            StringBuilder userParamsSb = new StringBuilder();
            userParamsSb.append(",\n");
            notReplacedUserParams.stream().forEach(p -> userParamsSb.append("\"").append((String)p).append("\": ").append("\"").append((String)userParameters.get(p)).append("\",\n"));
            userParamsStr = userParamsSb.toString();
            userParamsStr = userParamsStr.trim().substring(0, userParamsStr.length() - 2) + "\n";
        }
        for (ConfigProperty configProperty : hopsworksParams.values()) {
            finalParams.putIfAbsent(configProperty.getReplacementPattern(), configProperty.getValue());
        }
        return finalParams;
    }

    public static boolean jsonKeyExists(JSONObject object, String searchedKey) {
        boolean exists = object.has(searchedKey);
        if (!exists) {
            Iterator keys = object.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!(object.get(key) instanceof JSONObject)) continue;
                exists = HopsUtils.jsonKeyExists((JSONObject)object.get(key), searchedKey);
            }
        }
        return exists;
    }
}

