/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.metadata;

import io.hops.hopsworks.common.dao.metadata.EntityIntf;
import io.hops.hopsworks.common.dao.metadata.Field;
import io.hops.hopsworks.common.dao.metadata.Template;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="hopsworks.meta_tables")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="MTable.findAll", query="SELECT t FROM MTable t"), @NamedQuery(name="MTable.findById", query="SELECT t FROM MTable t WHERE t.id = :id"), @NamedQuery(name="MTable.findByName", query="SELECT t FROM MTable t WHERE t.name = :name"), @NamedQuery(name="MTable.findByTemplateId", query="SELECT DISTINCT t FROM MTable t WHERE t.templateid = :templateid")})
public class MTable
implements Serializable,
EntityIntf,
Comparable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    @Basic(optional=false)
    @Column(name="tableid")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=50)
    @Column(name="name")
    private String name;
    @Basic(optional=false)
    @NotNull
    @Column(name="templateid")
    private int templateid;
    @ManyToOne(optional=false)
    @PrimaryKeyJoinColumn(name="templateid", referencedColumnName="templateid")
    private Template template;
    @OneToMany(mappedBy="table", targetEntity=Field.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<Field> fields;

    public MTable() {
    }

    public MTable(Integer id) {
        this.id = id;
        this.fields = new LinkedList<Field>();
    }

    public MTable(Integer id, String name) {
        this.id = id;
        this.name = name;
        this.fields = new LinkedList<Field>();
    }

    @Override
    public void copy(EntityIntf table) {
        MTable t = (MTable)table;
        this.id = t.getId();
        this.templateid = t.getTemplateid();
        this.name = t.getName();
        this.fields = t.getFields();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public void setTemplateid(int templateid) {
        this.templateid = templateid;
    }

    public int getTemplateid() {
        return this.templateid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Field> getFields() {
        Collections.sort(this.fields);
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public void addField(Field field) {
        this.fields.add(field);
        if (field != null) {
            field.setMTable(this);
        }
    }

    public void removeField(Field field) {
        this.fields.remove(field);
        if (field != null) {
            field.setMTable(null);
        }
    }

    public void resetFields() {
        this.fields.clear();
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MTable)) {
            return false;
        }
        MTable other = (MTable)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "entity.Tables[ id=" + this.id + ", name=" + this.name + ", templateId=" + this.templateid + " ]";
    }

    public int compareTo(Object o) {
        MTable table = (MTable)o;
        if (this.getId() > table.getId()) {
            return 1;
        }
        if (this.getId() < table.getId()) {
            return -1;
        }
        return 0;
    }
}

