/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.project.service;

import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.service.ProjectServiceEnum;
import io.hops.hopsworks.common.dao.project.service.ProjectServicePK;
import java.io.Serializable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="hopsworks.project_services")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="ProjectServices.findAll", query="SELECT s FROM ProjectServices s"), @NamedQuery(name="ProjectServices.findByProject", query="SELECT s FROM ProjectServices s WHERE s.project = :project"), @NamedQuery(name="ProjectServices.findServicesByProject", query="SELECT s.projectServicePK.service FROM ProjectServices s WHERE s.project = :project ORDER BY s.projectServicePK.service"), @NamedQuery(name="ProjectServices.findByService", query="SELECT s FROM ProjectServices s WHERE s.projectServicePK.service = :service"), @NamedQuery(name="ProjectServices.isServiceEnabledForProject", query="SELECT s FROM ProjectServices s WHERE s.project = :project and s.projectServicePK.service = :service")})
public class ProjectServices
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected ProjectServicePK projectServicePK;
    @JoinColumn(name="project_id", referencedColumnName="id", insertable=false, updatable=false)
    @ManyToOne(optional=false)
    private Project project;

    public ProjectServices() {
    }

    public ProjectServices(ProjectServicePK projectServicesPK) {
        this.projectServicePK = projectServicesPK;
    }

    public ProjectServices(Project project, ProjectServiceEnum service) {
        this.projectServicePK = new ProjectServicePK(project.getId(), service);
    }

    public ProjectServicePK getProjectServicesPK() {
        return this.projectServicePK;
    }

    public void setProjectServicesPK(ProjectServicePK projectServicesPK) {
        this.projectServicePK = projectServicesPK;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.projectServicePK != null ? this.projectServicePK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProjectServices)) {
            return false;
        }
        ProjectServices other = (ProjectServices)object;
        return (this.projectServicePK != null || other.projectServicePK == null) && (this.projectServicePK == null || this.projectServicePK.equals(other.projectServicePK));
    }

    public String toString() {
        return "[" + this.project + "," + (Object)((Object)this.projectServicePK.getService()) + " ]";
    }
}

