/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.elastic;

import io.hops.hopsworks.common.elastic.ElasticController;
import io.hops.hopsworks.common.util.Settings;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Timer;

@Singleton
public class ElasticCleaner {
    private static final Logger LOGGER = Logger.getLogger(ElasticCleaner.class.getName());
    @EJB
    ElasticController elasticContoller;
    @EJB
    Settings settings;

    @Schedule(persistent=false, minute="0", hour="1")
    public void deleteLogIndices(Timer timer) {
        LOGGER.log(Level.INFO, "Running ElasticCleaner.");
        try {
            Map<String, Long> indices = this.elasticContoller.getIndices("(.*_logs-\\d{4}.\\d{2}.\\d{2})|(.*_serving-\\d{4}.\\d{2}.\\d{2})|(.*_kagent-\\d{4}.\\d{2}.\\d{2})|(.*_beamjobserver-\\d{4}.\\d{2}.\\d{2})|(.*_beamsdkworker-\\d{4}.\\d{2}.\\d{2})");
            for (String index : indices.keySet()) {
                long indexCreationTime;
                long currentTime = System.currentTimeMillis();
                if (currentTime - (indexCreationTime = indices.get(index).longValue()) <= this.settings.getElasticLogsIndexExpiration()) continue;
                this.elasticContoller.deleteIndex(index);
                LOGGER.log(Level.INFO, "Deletedindex:{0}", index);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Index deletion failed", ex);
        }
    }
}

