/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.trainingdatasets.external;

import io.hops.hopsworks.common.dao.featurestore.storageconnector.s3.FeaturestoreS3Connector;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.external.ExternalTrainingDataset;
import io.hops.hopsworks.common.featurestore.storageconnectors.s3.FeaturestoreS3ConnectorFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.external.ExternalTrainingDatasetDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.external.ExternalTrainingDatasetFacade;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
public class ExternalTrainingDatasetController {
    @EJB
    private ExternalTrainingDatasetFacade externalTrainingDatasetFacade;
    @EJB
    private FeaturestoreS3ConnectorFacade featurestoreS3ConnectorFacade;

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public ExternalTrainingDataset createExternalTrainingDataset(ExternalTrainingDatasetDTO externalTrainingDatasetDTO) throws FeaturestoreException {
        FeaturestoreS3Connector featurestoreS3Connector = this.verifyExternalTrainingDatasetS3ConnectorId(externalTrainingDatasetDTO.getS3ConnectorId());
        ExternalTrainingDataset externalTrainingDataset = new ExternalTrainingDataset();
        externalTrainingDataset.setFeaturestoreS3Connector(featurestoreS3Connector);
        this.externalTrainingDatasetFacade.persist(externalTrainingDataset);
        return externalTrainingDataset;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void removeExternalTrainingDataset(ExternalTrainingDataset externalTrainingDataset) {
        this.externalTrainingDatasetFacade.remove(externalTrainingDataset);
    }

    private FeaturestoreS3Connector verifyExternalTrainingDatasetS3ConnectorId(Integer s3ConnectorId) throws FeaturestoreException {
        if (s3ConnectorId == null) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.S3_CONNECTOR_ID_NOT_PROVIDED.getMessage());
        }
        FeaturestoreS3Connector featurestoreS3Connector = (FeaturestoreS3Connector)this.featurestoreS3ConnectorFacade.find(s3ConnectorId);
        if (featurestoreS3Connector == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.S3_CONNECTOR_NOT_FOUND, Level.FINE, "S3 connector with id: " + s3ConnectorId + " was not found");
        }
        return featurestoreS3Connector;
    }

    public ExternalTrainingDatasetDTO convertExternalTrainingDatasetToDTO(TrainingDataset trainingDataset) {
        ExternalTrainingDatasetDTO externalTrainingDatasetDTO = new ExternalTrainingDatasetDTO(trainingDataset);
        externalTrainingDatasetDTO.setLocation("s3a://" + trainingDataset.getExternalTrainingDataset().getFeaturestoreS3Connector().getBucket() + "/" + "TRAINING_DATASETS" + "/" + trainingDataset.getName() + "_" + trainingDataset.getVersion());
        return externalTrainingDatasetDTO;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void updateExternalTrainingDatasetMetadata(ExternalTrainingDataset externalTrainingDataset, ExternalTrainingDatasetDTO externalTrainingDatasetDTO) throws FeaturestoreException {
        FeaturestoreS3Connector featurestoreS3Connector = this.verifyExternalTrainingDatasetS3ConnectorId(externalTrainingDatasetDTO.getS3ConnectorId());
        externalTrainingDataset.setFeaturestoreS3Connector(featurestoreS3Connector);
        this.externalTrainingDatasetFacade.updateExternalTrainingDatasetMetadata(externalTrainingDataset);
    }
}

