/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jupyter;

public interface RepositoryStatus {
    public STATUS getStatus();

    public Integer getModifiedFiles();

    public String getRepository();

    public String getBranch();

    public static class ModifiableRepositoryStatus
    implements RepositoryStatus {
        private STATUS status;
        private Integer modifiedFiles;
        private String repository;
        private String branch;

        @Override
        public STATUS getStatus() {
            return this.status;
        }

        public void setStatus(STATUS status) {
            this.status = status;
        }

        @Override
        public Integer getModifiedFiles() {
            return this.modifiedFiles;
        }

        public void setModifiedFiles(Integer modifiedFiles) {
            this.modifiedFiles = modifiedFiles;
        }

        @Override
        public String getRepository() {
            return this.repository;
        }

        public void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public String getBranch() {
            return this.branch;
        }

        public void setBranch(String branch) {
            this.branch = branch;
        }
    }

    public static final class UnmodifiableRepositoryStatus
    implements RepositoryStatus {
        private final STATUS status = STATUS.UNINITIALIZED;
        private final Integer modifiedFiles = -1;
        private final String repository = "UNKNOWN";
        private final String branch = "UNKNOWN";

        @Override
        public STATUS getStatus() {
            return this.status;
        }

        @Override
        public Integer getModifiedFiles() {
            return this.modifiedFiles;
        }

        @Override
        public String getRepository() {
            return "UNKNOWN";
        }

        @Override
        public String getBranch() {
            return "UNKNOWN";
        }
    }

    public static enum STATUS {
        DIRTY,
        CLEAN,
        UNINITIALIZED;

    }
}

