/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.admin.llap;

import io.hops.hopsworks.common.admin.llap.LlapClusterStatus;
import io.hops.hopsworks.common.dao.util.VariablesFacade;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.yarn.YarnClientService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;

@Stateless
public class LlapClusterFacade {
    private static final Logger logger = Logger.getLogger(LlapClusterFacade.class.getName());
    private static final String NINSTANCES = "llap_ninstances";
    private static final String EXECMEMORY = "llap_exec_memory";
    private static final String CACHEMEMORY = "llap_cache_memory";
    private static final String NEXECUTORS = "llap_executors_threads";
    private static final String NIOTHREADS = "llap_io_threads";
    @EJB
    private YarnClientService yarnClientService;
    @EJB
    private Settings settings;
    @EJB
    private VariablesFacade variablesFacade;

    public LlapClusterStatus getClusterStatus() {
        String nIOThreads;
        String nExecutors;
        String cacheMemory;
        String execMemory;
        LlapClusterStatus clusterStatus = new LlapClusterStatus();
        if (this.isClusterStarting()) {
            clusterStatus.setClusterStatus(LlapClusterStatus.Status.LAUNCHING);
        } else if (this.isClusterUp()) {
            clusterStatus.setClusterStatus(LlapClusterStatus.Status.UP);
            clusterStatus.setHosts(this.getLlapHosts());
        } else {
            clusterStatus.setClusterStatus(LlapClusterStatus.Status.DOWN);
        }
        String nInstances = this.variablesFacade.getVariableValue(NINSTANCES);
        if (nInstances != null) {
            clusterStatus.setInstanceNumber(Integer.parseInt(nInstances));
        }
        if ((execMemory = this.variablesFacade.getVariableValue(EXECMEMORY)) != null) {
            clusterStatus.setExecutorsMemory(Long.parseLong(execMemory));
        }
        if ((cacheMemory = this.variablesFacade.getVariableValue(CACHEMEMORY)) != null) {
            clusterStatus.setCacheMemory(Long.parseLong(cacheMemory));
        }
        if ((nExecutors = this.variablesFacade.getVariableValue(NEXECUTORS)) != null) {
            clusterStatus.setExecutorsPerInstance(Integer.parseInt(nExecutors));
        }
        if ((nIOThreads = this.variablesFacade.getVariableValue(NIOTHREADS)) != null) {
            clusterStatus.setIOThreadsPerInstance(Integer.parseInt(nIOThreads));
        }
        return clusterStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClusterUp() {
        String llapAppID = this.variablesFacade.getVariableValue("hive_llap_app_id");
        if (llapAppID == null || llapAppID.isEmpty()) {
            return false;
        }
        ApplicationId appId = ApplicationId.fromString((String)llapAppID);
        YarnClient yarnClient = this.yarnClientService.getYarnClientSuper(this.settings.getConfiguration()).getYarnClient();
        ApplicationReport applicationReport = null;
        try {
            applicationReport = yarnClient.getApplicationReport(appId);
        }
        catch (IOException | YarnException e) {
            logger.log(Level.SEVERE, "Could not retrieve application state for llap cluster with appId: " + appId.toString(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                yarnClient.close();
            }
            catch (IOException iOException) {}
        }
        YarnApplicationState appState = applicationReport.getYarnApplicationState();
        return appState == YarnApplicationState.RUNNING || appState == YarnApplicationState.SUBMITTED || appState == YarnApplicationState.ACCEPTED || appState == YarnApplicationState.NEW || appState == YarnApplicationState.NEW_SAVING;
    }

    public boolean isClusterStarting() {
        String pidString = this.variablesFacade.getVariableValue("hive_llap_start_proc");
        long pid = -1L;
        if (pidString != null) {
            pid = Long.valueOf(pidString);
        }
        if (pid == -1L) {
            return false;
        }
        if (pid == -2L) {
            return true;
        }
        File procDir = new File("/proc/" + String.valueOf(pid));
        return procDir.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLlapHosts() {
        ArrayList<String> hosts = new ArrayList<String>();
        if (!this.isClusterUp() || this.isClusterStarting()) {
            return hosts;
        }
        String llapAppID = this.variablesFacade.getVariableValue("hive_llap_app_id");
        ApplicationId appId = ApplicationId.fromString((String)llapAppID);
        YarnClient yarnClient = this.yarnClientService.getYarnClientSuper(this.settings.getConfiguration()).getYarnClient();
        try {
            List attempts = yarnClient.getApplicationAttempts(appId);
            ApplicationAttemptReport current = null;
            for (ApplicationAttemptReport attempt : attempts) {
                if (attempt.getYarnApplicationAttemptState() != YarnApplicationAttemptState.RUNNING) continue;
                current = attempt;
                break;
            }
            if (current == null) {
                ArrayList<String> arrayList = hosts;
                return arrayList;
            }
            List containerReports = yarnClient.getContainers(current.getApplicationAttemptId());
            for (ContainerReport containerReport : containerReports) {
                if (containerReport.getContainerState() != ContainerState.RUNNING || containerReport.getContainerId().equals((Object)current.getAMContainerId())) continue;
                hosts.add(containerReport.getAssignedNode().getHost());
            }
        }
        catch (IOException | YarnException ex) {
            logger.log(Level.SEVERE, "Couldn't retrieve the containers for LLAP cluster", ex);
        }
        finally {
            try {
                yarnClient.close();
            }
            catch (IOException iOException) {}
        }
        return hosts;
    }

    public void saveConfiguration(int nInstances, long execMemory, long cacheMemory, int nExecutors, int nIOThreaads) {
        this.variablesFacade.storeVariable(NINSTANCES, String.valueOf(nInstances));
        this.variablesFacade.storeVariable(EXECMEMORY, String.valueOf(execMemory));
        this.variablesFacade.storeVariable(CACHEMEMORY, String.valueOf(cacheMemory));
        this.variablesFacade.storeVariable(NEXECUTORS, String.valueOf(nExecutors));
        this.variablesFacade.storeVariable(NIOTHREADS, String.valueOf(nIOThreaads));
    }
}

