/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.execution;

import io.hops.hopsworks.common.dao.jobhistory.Execution;
import io.hops.hopsworks.common.dao.jobs.description.Jobs;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.jobs.AsynchronousJobExecutor;
import io.hops.hopsworks.common.jobs.jobhistory.JobState;
import io.hops.hopsworks.common.jobs.yarn.ServiceProperties;
import io.hops.hopsworks.common.jobs.yarn.YarnJobsMonitor;
import io.hops.hopsworks.common.yarn.YarnClientWrapper;
import io.hops.hopsworks.exceptions.JobException;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.client.api.YarnClient;

public abstract class HopsJob {
    protected YarnJobsMonitor jobsMonitor;
    private static final Logger logger = Logger.getLogger(HopsJob.class.getName());
    protected Execution execution;
    private boolean initialized = false;
    protected final AsynchronousJobExecutor services;
    protected ServiceProperties serviceProps;
    protected final Jobs jobs;
    protected final Users user;
    protected final String hadoopDir;
    protected final UserGroupInformation hdfsUser;

    protected HopsJob(Jobs jobs, AsynchronousJobExecutor services, Users user, String hadoopDir, YarnJobsMonitor jobsMonitor) {
        if (jobs == null) {
            throw new NullPointerException("Cannot run a null Job.");
        }
        if (services == null) {
            throw new NullPointerException("Cannot run without a service provider.");
        }
        if (user == null) {
            throw new NullPointerException("A job cannot be run by a null user!");
        }
        this.jobs = jobs;
        this.services = services;
        this.user = user;
        this.hadoopDir = hadoopDir;
        this.jobsMonitor = jobsMonitor;
        try {
            this.hdfsUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException("Exception while trying to retrieve hadoop User Group Information: " + ex.getMessage());
        }
        logger.log(Level.INFO, "Instantiating Hops job as user: {0}", this.hdfsUser);
    }

    protected final void updateState(JobState newState) {
        this.execution = this.services.getExecutionFacade().updateState(this.execution, newState);
    }

    public final void execute(final String args) {
        if (!this.initialized) {
            throw new IllegalStateException("Cannot execute before acquiring an Execution id.");
        }
        try {
            this.hdfsUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() {
                    YarnClientWrapper yarnClientWrapper;
                    DistributedFileSystemOps udfso;
                    DistributedFileSystemOps dfso;
                    block14: {
                        dfso = null;
                        udfso = null;
                        yarnClientWrapper = null;
                        try {
                            HopsJob.this.execution = HopsJob.this.services.getExecutionFacade().updateExecutionStart(HopsJob.this.execution, System.currentTimeMillis());
                            dfso = HopsJob.this.services.getFsService().getDfsOps();
                            udfso = HopsJob.this.services.getFileOperations(HopsJob.this.hdfsUser.getUserName());
                            yarnClientWrapper = HopsJob.this.services.getYarnClientService().getYarnClient(HopsJob.this.hdfsUser.getUserName());
                            boolean proceed = false;
                            try {
                                proceed = HopsJob.this.setupJob(dfso, yarnClientWrapper.getYarnClient());
                            }
                            catch (Exception ex) {
                                logger.log(Level.SEVERE, "Job Initialization Failed", ex);
                            }
                            if (proceed) break block14;
                            HopsJob.this.execution = HopsJob.this.services.getExecutionFacade().updateExecutionStop(HopsJob.this.execution, System.currentTimeMillis());
                            HopsJob.this.services.getExecutionFacade().updateState(HopsJob.this.execution, JobState.INITIALIZATION_FAILED);
                            HopsJob.this.cleanup();
                            Void void_ = null;
                            if (dfso != null) {
                                dfso.close();
                            }
                            if (null != udfso) {
                                HopsJob.this.services.getFsService().closeDfsClient(udfso);
                            }
                            if (yarnClientWrapper != null) {
                                HopsJob.this.services.getYarnClientService().closeYarnClient(yarnClientWrapper);
                            }
                            return void_;
                        }
                        catch (Throwable throwable) {
                            if (dfso != null) {
                                dfso.close();
                            }
                            if (null != udfso) {
                                HopsJob.this.services.getFsService().closeDfsClient(udfso);
                            }
                            if (yarnClientWrapper != null) {
                                HopsJob.this.services.getYarnClientService().closeYarnClient(yarnClientWrapper);
                            }
                            throw throwable;
                        }
                    }
                    HopsJob.this.runJob(udfso, dfso, args);
                    Void void_ = null;
                    if (dfso != null) {
                        dfso.close();
                    }
                    if (null != udfso) {
                        HopsJob.this.services.getFsService().closeDfsClient(udfso);
                    }
                    if (yarnClientWrapper != null) {
                        HopsJob.this.services.getYarnClientService().closeYarnClient(yarnClientWrapper);
                    }
                    return void_;
                }
            });
        }
        catch (IOException | InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    protected abstract boolean setupJob(DistributedFileSystemOps var1, YarnClient var2) throws JobException;

    protected abstract void runJob(DistributedFileSystemOps var1, DistributedFileSystemOps var2, String var3);

    protected abstract void cleanup();

    public final Execution requestExecutionId() {
        return this.requestExecutionId(null);
    }

    public final Execution requestExecutionId(String args) {
        this.execution = this.services.getExecutionFacade().create(this.jobs, this.user, null, null, null, null, 0.0f, this.hdfsUser.getUserName(), args);
        this.initialized = this.execution.getId() != null;
        return this.execution;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    protected abstract void writeToLogs(String var1, Exception var2) throws IOException;

    protected abstract void writeToLogs(String var1) throws IOException;
}

