/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.dataset;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.dataset.Dataset;
import io.hops.hopsworks.common.dao.dataset.DatasetRequest;
import io.hops.hopsworks.common.dao.message.Message;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.team.ProjectTeam;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class DatasetRequestFacade
extends AbstractFacade<DatasetRequest> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public DatasetRequestFacade() {
        super(DatasetRequest.class);
    }

    @Override
    public List<DatasetRequest> findAll() {
        TypedQuery query = this.em.createNamedQuery("DatasetRequest.findAll", DatasetRequest.class);
        return query.getResultList();
    }

    public DatasetRequest find(Integer id) {
        return (DatasetRequest)this.em.find(DatasetRequest.class, (Object)id);
    }

    public List<DatasetRequest> findByDataset(Dataset ds) {
        TypedQuery query = this.em.createNamedQuery("DatasetRequest.findByDataset", DatasetRequest.class).setParameter("dataset", (Object)ds);
        return query.getResultList();
    }

    public DatasetRequest findByProjectTeamAndDataset(ProjectTeam projectTeam, Dataset ds) {
        try {
            return (DatasetRequest)this.em.createNamedQuery("DatasetRequest.findByProjectTeamAndDataset", DatasetRequest.class).setParameter("projectTeam", (Object)projectTeam).setParameter("dataset", (Object)ds).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public DatasetRequest findByProjectAndDataset(Project project, Dataset ds) {
        try {
            return (DatasetRequest)this.em.createNamedQuery("DatasetRequest.findByProjectAndDataset", DatasetRequest.class).setParameter("project", (Object)project).setParameter("dataset", (Object)ds).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<DatasetRequest> findByProjectTeam(ProjectTeam projectTeam) {
        TypedQuery query = this.em.createNamedQuery("DatasetRequest.findByProjectTeam", DatasetRequest.class).setParameter("projectTeam", (Object)projectTeam);
        return query.getResultList();
    }

    public DatasetRequest findByMessageId(Message message) {
        TypedQuery query = this.em.createNamedQuery("DatasetRequest.findByMessageId", DatasetRequest.class).setParameter("message_id", (Object)message.getId());
        List results = query.getResultList();
        if (results != null && results.size() == 1) {
            return (DatasetRequest)results.get(0);
        }
        return null;
    }

    public void persistDataset(DatasetRequest datasetRequest) {
        this.em.persist((Object)datasetRequest);
    }

    public void flushEm() {
        this.em.flush();
    }

    public void merge(DatasetRequest dataset) {
        this.em.merge((Object)dataset);
    }
}

