/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.hdfsUser;

import io.hops.hopsworks.common.dao.AbstractReadOnlyFacade;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsGroups;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;

@Stateless
public class HdfsGroupsFacade
extends AbstractReadOnlyFacade<HdfsGroups> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public HdfsGroupsFacade() {
        super(HdfsGroups.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public HdfsGroups findHdfsGroup(byte[] id) {
        return (HdfsGroups)this.em.find(HdfsGroups.class, (Object)id);
    }

    public HdfsGroups findByName(String name) {
        try {
            return (HdfsGroups)this.em.createNamedQuery("HdfsGroups.findByName", HdfsGroups.class).setParameter("name", (Object)name).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<HdfsGroups> findProjectGroups(String projectName) {
        ArrayList<HdfsGroups> groups = null;
        try {
            groups = this.em.createNamedQuery("HdfsGroups.findProjectGroups", HdfsGroups.class).setParameter("name", (Object)projectName).getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
        try {
            HdfsGroups group = (HdfsGroups)this.em.createNamedQuery("HdfsGroups.findByName", HdfsGroups.class).setParameter("name", (Object)projectName).getSingleResult();
            if (group != null) {
                if (groups == null) {
                    groups = new ArrayList<HdfsGroups>();
                }
                groups.add(group);
            }
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return groups;
    }
}

