/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.featurestore.Featurestore;
import io.hops.hopsworks.common.dao.project.Project;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.validation.ConstraintViolationException;

@Stateless
public class FeaturestoreFacade
extends AbstractFacade<Featurestore> {
    private static final Logger LOGGER = Logger.getLogger(FeaturestoreFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeaturestoreFacade() {
        super(Featurestore.class);
    }

    @Override
    public List<Featurestore> findAll() {
        TypedQuery q = this.em.createNamedQuery("Featurestore.findAll", Featurestore.class);
        return q.getResultList();
    }

    public List<Featurestore> findByProject(Project project) {
        TypedQuery q = this.em.createNamedQuery("Featurestore.findByProject", Featurestore.class).setParameter("project", (Object)project);
        return q.getResultList();
    }

    public Featurestore findById(Integer id) {
        try {
            return (Featurestore)this.em.createNamedQuery("Featurestore.findById", Featurestore.class).setParameter("id", (Object)id).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void persist(Featurestore featurestore) {
        try {
            this.em.persist((Object)featurestore);
            this.em.flush();
        }
        catch (ConstraintViolationException cve) {
            LOGGER.log(Level.WARNING, "Could not persist the new Featurestore", cve);
            throw cve;
        }
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public Long getHiveDatabaseId(String featurestoreName) {
        try {
            return (Long)this.em.createNativeQuery("SELECT `DB_ID` FROM metastore.`DBS` WHERE NAME = ?1;").setParameter(1, (Object)featurestoreName.toLowerCase()).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public String getHiveDatabaseDescription(Long hiveDbId) {
        try {
            return (String)this.em.createNativeQuery("SELECT `DESC` FROM metastore.`DBS` WHERE `DB_ID` = ?1;").setParameter(1, (Object)hiveDbId).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Long getFeaturestoreInodeId(Long hiveDbId) {
        try {
            return (Long)this.em.createNativeQuery("SELECT i.`id` FROM metastore.`DBS` d JOIN metastore.`SDS` s JOIN hops.`hdfs_inodes` i ON d.`SD_ID`=s.`SD_ID` AND s.`PARTITION_ID`=i.`partition_id` AND s.`PARENT_ID`=i.`parent_id` AND s.`NAME`=i.`name` WHERE `DB_ID` = ?1;").setParameter(1, (Object)hiveDbId).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public String getHiveDbName(Long hiveDbId) {
        try {
            return (String)this.em.createNativeQuery("SELECT `NAME` FROM metastore.`DBS` WHERE `DB_ID`= ?1;").setParameter(1, (Object)hiveDbId).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public String getHiveDbHdfsPath(Long hiveDbId) {
        try {
            return (String)this.em.createNativeQuery("SELECT s.`LOCATION` FROM metastore.`DBS` d JOIN metastore.`SDS` s ON d.`SD_ID` = s.`SD_ID` WHERE d.`DB_ID` = ?1;").setParameter(1, (Object)hiveDbId).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

