/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.kafka;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.kafka.AclDTO;
import io.hops.hopsworks.common.dao.kafka.KafkaConst;
import io.hops.hopsworks.common.dao.kafka.ProjectTopics;
import io.hops.hopsworks.common.dao.kafka.TopicAcls;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.user.Users;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class TopicAclsFacade
extends AbstractFacade<TopicAcls> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    private static final Logger LOGGER = Logger.getLogger(TopicAclsFacade.class.getName());

    public TopicAclsFacade() {
        super(TopicAcls.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public void removeAclFromTopic(String topicName, Project project) {
        this.findByTopicName(topicName).stream().filter(acl -> KafkaConst.getProjectNameFromPrincipal(acl.getPrincipal()).equals(project.getName())).forEach(this::remove);
    }

    public List<TopicAcls> findByTopicName(String topicName) {
        return this.em.createNamedQuery("TopicAcls.findByTopicName", TopicAcls.class).setParameter("topicName", (Object)topicName).getResultList();
    }

    public Optional<TopicAcls> getTopicAcls(String topicName, String principal, String permission_type, String operation_type, String host, String role) {
        try {
            return Optional.ofNullable(this.em.createNamedQuery("TopicAcls.findAcl", TopicAcls.class).setParameter("topicName", (Object)topicName).setParameter("principal", (Object)principal).setParameter("role", (Object)role).setParameter("host", (Object)host).setParameter("operationType", (Object)operation_type).setParameter("permissionType", (Object)permission_type).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<TopicAcls> getTopicAcls(String topicName, AclDTO dto, String principalName) {
        return this.getTopicAcls(topicName, principalName, dto.getPermissionType(), dto.getOperationType(), dto.getHost(), dto.getRole());
    }

    public void removeAclsForUser(Users user, Project project) {
        this.em.createNamedQuery("TopicAcls.deleteByUser", TopicAcls.class).setParameter("user", (Object)user).setParameter("project", (Object)project).executeUpdate();
    }

    public void removeAclsForUserAndPrincipalProject(Users user, String projectName) {
        this.em.createNamedQuery("TopicAcls.deleteByUserAndPrincipalProject", TopicAcls.class).setParameter("user", (Object)user).setParameter("project", (Object)projectName).executeUpdate();
    }

    public void removeAclForProject(Project project) {
        this.em.createNamedQuery("TopicAcls.findAll", TopicAcls.class).getResultList().stream().filter(acl -> KafkaConst.getProjectNameFromPrincipal(acl.getPrincipal()).equals(project.getName())).forEach(acl -> this.em.remove(acl));
    }

    public TopicAcls addAclsToTopic(ProjectTopics pt, Users user, String permissionType, String operationType, String host, String role, String principalName) {
        TopicAcls ta = new TopicAcls(pt, user, permissionType, operationType, host, role, principalName);
        this.save(ta);
        this.em.flush();
        return ta;
    }

    public AbstractFacade.CollectionInfo findByTopicName(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filters, Set<? extends AbstractFacade.SortBy> sorts, String topicName) {
        String queryStr = this.buildQuery("SELECT t FROM TopicAcls t ", filters, sorts, " t.projectTopics.topicName = :topicName ");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT t.id) FROM TopicAcls t ", filters, sorts, "t.projectTopics.topicName = :topicName ");
        TypedQuery query = this.em.createQuery(queryStr, TopicAcls.class).setParameter("topicName", (Object)topicName);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, TopicAcls.class).setParameter("topicName", (Object)topicName);
        this.setFilter(filters, (Query)query);
        this.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo(this, (Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (TopicAclsFilters.valueOf(filterBy.getValue())) {
            case ID: {
                q.setParameter(filterBy.getField(), (Object)Integer.valueOf(filterBy.getParam()));
                break;
            }
            case HOST: 
            case USER_EMAIL: 
            case PROJECT_NAME: 
            case OPERATION_TYPE: 
            case PERMISSION_TYPE: 
            case ROLE: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam());
                break;
            }
        }
    }

    public static enum TopicAclsFilters {
        ID("ID", "t.id = :id", "id", ""),
        HOST("HOST", "t.host = :host", "host", ""),
        OPERATION_TYPE("OPERATION_TYPE", "t.operationType = :operationType", "operationType", ""),
        PERMISSION_TYPE("PERMISSION_TYPE", "t.permissionType = :permissionType", "permissionType", ""),
        PROJECT_NAME("PROJECT_NAME", "t.principal LIKE CONCAT(:projectName,'%') ", "projectName", ""),
        ROLE("ROLE", "t.role = :role", "role", ""),
        USER_EMAIL("USER_EMAIL", "t.user.email = :userEmail", "userEmail", "");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private TopicAclsFilters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum TopicAclsSorts {
        ID("ID", "t.id ", "ASC"),
        HOST("HOST", "LOWER(t.host) ", "ASC"),
        OPERATION_TYPE("OPERATION_TYPE", "LOWER(t.operationType) ", "ASC"),
        PERMISSION_TYPE("PERMISSION_TYPE", "LOWER(t.permissionType) ", "ASC"),
        PROJECT_NAME("PROJECT_NAME", "LOWER(t.principal) ", "ASC"),
        ROLE("ROLE", "LOWER(t.role) ", "ASC"),
        USER_EMAIL("USER_EMAIL", "LOWER(t.user.email) ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private TopicAclsSorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

