/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.core.elastic;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.hops.hopsworks.common.provenance.core.elastic.ProvElasticController;
import io.hops.hopsworks.exceptions.ElasticException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
public class ElasticCache {
    private static final Logger LOG = Logger.getLogger(ElasticCache.class.getName());
    @EJB
    private ProvElasticController client;
    private Cache<String, Map<String, String>> indexMappings;

    @PostConstruct
    private void initClient() {
        this.indexMappings = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(50L).build();
    }

    public void cacheMapping(String index, Map<String, String> mapping) {
        this.indexMappings.put((Object)index, mapping);
    }

    public Map<String, String> getMapping(String index) {
        return (Map)this.indexMappings.getIfPresent((Object)index);
    }

    public void clearMapping(String index) {
        this.indexMappings.invalidate((Object)index);
    }

    public Map<String, String> mngIndexGetMapping(String index, boolean forceFetch) throws ElasticException {
        Map<String, Map<String, String>> result;
        Map<String, String> mapping;
        if (forceFetch) {
            this.clearMapping(index);
        }
        if ((mapping = this.getMapping(index)) == null && (mapping = (result = this.client.mngIndexGetMappings(index)).get(index)) != null) {
            this.cacheMapping(index, mapping);
        }
        return mapping;
    }
}

