/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.util.Settings;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ProjectUtils {
    @EJB
    private Settings settings;

    public boolean isReservedProjectName(String projectName) {
        for (String name : this.settings.getReservedProjectNames()) {
            if (!name.equalsIgnoreCase(projectName)) continue;
            return true;
        }
        return false;
    }

    public String getCurrentCondaEnvironment(Project project) {
        String condaEnv = project.getName();
        if (project.getConda().booleanValue() && !project.getCondaEnv().booleanValue()) {
            if (project.getPythonVersion().compareToIgnoreCase("2.7") == 0) {
                condaEnv = "python27";
            } else if (project.getPythonVersion().compareToIgnoreCase("3.6") == 0) {
                condaEnv = "python36";
            } else {
                throw new IllegalArgumentException("Error. Python has not been enabled for this project.");
            }
        }
        return condaEnv;
    }

    public String getCurrentCondaBaseEnvironment(Project project) {
        if (project.getPythonVersion().compareToIgnoreCase("2.7") == 0) {
            return "python27";
        }
        if (project.getPythonVersion().compareToIgnoreCase("3.6") == 0) {
            return "python36";
        }
        throw new IllegalArgumentException("Error. Python has not been enabled for this project.");
    }
}

