/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.metadata;

import io.hops.hopsworks.common.dao.metadata.EntityIntf;
import io.hops.hopsworks.common.dao.metadata.Field;
import io.hops.hopsworks.common.dao.metadata.Metadata;
import io.hops.hopsworks.common.dao.metadata.RawDataPK;
import io.hops.hopsworks.common.dao.metadata.TupleToFile;
import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="hopsworks.meta_raw_data")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="RawData.findAll", query="SELECT r FROM RawData r"), @NamedQuery(name="RawData.findByPrimaryKey", query="SELECT r FROM RawData r WHERE r.rawdataPK = :rawdataPK"), @NamedQuery(name="RawData.findByFieldid", query="SELECT r FROM RawData r WHERE r.rawdataPK.fieldid = :fieldid"), @NamedQuery(name="RawData.findByTupleid", query="SELECT r FROM RawData r WHERE r.rawdataPK.tupleid = :tupleid"), @NamedQuery(name="RawData.lastInsertedTupleId", query="SELECT r FROM RawData r GROUP BY r.rawdataPK.tupleid ORDER BY r.rawdataPK.tupleid desc")})
public class RawData
implements EntityIntf,
Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private RawDataPK rawdataPK;
    @ManyToOne(optional=false)
    @PrimaryKeyJoinColumn(name="fieldid", referencedColumnName="fieldid")
    private Field fields;
    @ManyToOne(optional=false)
    @PrimaryKeyJoinColumn(name="tupleid", referencedColumnName="tupleid")
    private TupleToFile tupleToFile;
    @OneToMany(mappedBy="rawdata", targetEntity=Metadata.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<Metadata> metadata;

    public RawData() {
        this.rawdataPK = new RawDataPK(-1, -1);
    }

    public RawData(RawDataPK rawdataPK) {
        this.rawdataPK = rawdataPK;
    }

    public RawData(int fieldid, int tupleid) {
        this.rawdataPK = new RawDataPK(fieldid, tupleid);
    }

    @Override
    public void copy(EntityIntf raw) {
        RawData r = (RawData)raw;
        this.rawdataPK.copy(r.getRawdataPK());
    }

    public void setRawdataPK(RawDataPK rawdataPK) {
        this.rawdataPK = rawdataPK;
    }

    public RawDataPK getRawdataPK() {
        return this.rawdataPK;
    }

    public void setField(Field fields) {
        this.fields = fields;
    }

    public Field getField() {
        return this.fields;
    }

    public void setTupleToFile(TupleToFile ttf) {
        this.tupleToFile = ttf;
    }

    public TupleToFile getTupleToFile() {
        return this.tupleToFile;
    }

    public void setMetadata(List<Metadata> metadata) {
        this.metadata = metadata;
    }

    public List<Metadata> getMetadata() {
        return this.metadata;
    }

    public void resetMetadata() {
        this.metadata.clear();
    }

    @Override
    public Integer getId() {
        throw new UnsupportedOperationException("Not necessary for this entity.");
    }

    @Override
    public void setId(Integer id) {
        throw new UnsupportedOperationException("Not necessary for this entity.");
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.rawdataPK != null ? this.rawdataPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RawData)) {
            return false;
        }
        RawData other = (RawData)object;
        return !(this.rawdataPK == null && other.getRawdataPK() != null || this.rawdataPK != null && !this.rawdataPK.equals(other.getRawdataPK()));
    }

    public String toString() {
        return "se.kth.meta.entity.RawData[ rawdataPK= " + this.rawdataPK + " ]";
    }
}

