/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.admin.llap;

import io.hops.hopsworks.common.admin.llap.LlapClusterFacade;
import io.hops.hopsworks.common.dao.jobhistory.YarnApplicationstateFacade;
import io.hops.hopsworks.common.dao.util.VariablesFacade;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.yarn.YarnClientService;
import io.hops.hopsworks.common.yarn.YarnClientWrapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.Asynchronous;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
public class LlapClusterLifecycle {
    @EJB
    private Settings settings;
    @EJB
    private VariablesFacade variablesFacade;
    @EJB
    private LlapClusterFacade llapClusterFacade;
    @EJB
    private YarnClientService yarnClientService;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private YarnApplicationstateFacade yarnApplicationstateFacade;
    private static final Logger LOGGER = Logger.getLogger(LlapClusterLifecycle.class.getName());
    private Set<String> applicationTypeSet = null;
    private EnumSet<YarnApplicationState> applicationStateEnumSet = null;
    private Set<String> hiveUser = new HashSet<String>();

    @PostConstruct
    private void init() {
        this.applicationTypeSet = new HashSet<String>(Arrays.asList("org-apache-slider"));
        this.applicationStateEnumSet = this.yarnApplicationstateFacade.getRunningStates();
        this.hiveUser.add(this.settings.getHiveSuperUser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Lock(value=LockType.WRITE)
    @Asynchronous
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void startCluster(int nInstances, long execMemory, long cacheMemory, int nExecutors, int nIOThreads) {
        if (this.llapClusterFacade.isClusterUp()) {
            return;
        }
        this.variablesFacade.storeVariable("hive_llap_start_proc", "-2");
        this.llapClusterFacade.saveConfiguration(nInstances, execMemory, cacheMemory, nExecutors, nIOThreads);
        String startScript = this.settings.getSudoersDir() + "/start-llap.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand("-u").addCommand(this.settings.getHiveSuperUser()).addCommand(startScript).addCommand(String.valueOf(nInstances)).addCommand(String.valueOf(execMemory)).addCommand(String.valueOf(cacheMemory)).addCommand(String.valueOf(nExecutors)).addCommand(String.valueOf(nIOThreads)).redirectErrorStream(true).setWaitTimeout(5L, TimeUnit.MINUTES).build();
        YarnClientWrapper yarnClientWrapper = null;
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                LOGGER.log(Level.INFO, "LLAP output: " + processResult.getStdout());
            }
            yarnClientWrapper = this.yarnClientService.getYarnClientSuper(this.settings.getConfiguration());
            YarnClient yarnClient = yarnClientWrapper.getYarnClient();
            HashSet queueSet = new HashSet();
            List queueInfoList = yarnClient.getAllQueues();
            queueInfoList.forEach(queue -> queueSet.add(queue.getQueueName()));
            List appReports = yarnClient.getApplications(queueSet, this.hiveUser, this.applicationTypeSet, this.applicationStateEnumSet);
            if (!appReports.isEmpty()) {
                this.variablesFacade.storeVariable("hive_llap_app_id", ((ApplicationReport)appReports.get(0)).getApplicationId().toString());
            }
            this.variablesFacade.storeVariable("hive_llap_start_proc", "-1");
            this.yarnClientService.closeYarnClient(yarnClientWrapper);
        }
        catch (IOException | YarnException e) {
            try {
                LOGGER.log(Level.SEVERE, "Error starting LLAP", e);
                this.variablesFacade.storeVariable("hive_llap_start_proc", "-1");
                this.yarnClientService.closeYarnClient(yarnClientWrapper);
            }
            catch (Throwable throwable) {
                this.variablesFacade.storeVariable("hive_llap_start_proc", "-1");
                this.yarnClientService.closeYarnClient(yarnClientWrapper);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Lock(value=LockType.WRITE)
    public boolean stopCluster() {
        String llapAppID = this.variablesFacade.getVariableValue("hive_llap_app_id");
        if (llapAppID == null || llapAppID.isEmpty()) {
            return false;
        }
        ApplicationId appId = ApplicationId.fromString((String)llapAppID);
        YarnClient yarnClient = this.yarnClientService.getYarnClientSuper(this.settings.getConfiguration()).getYarnClient();
        try {
            yarnClient.killApplication(appId);
        }
        catch (IOException | YarnException e) {
            LOGGER.log(Level.SEVERE, "Could not kill llap cluster with appId: " + appId.toString(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                yarnClient.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }
}

