/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.trainingdatasets;

import io.hops.hopsworks.common.featurestore.FeaturestoreEntityDTO;
import io.hops.hopsworks.common.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorType;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetType;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class TrainingDatasetDTO
extends FeaturestoreEntityDTO {
    private String dataFormat;
    private TrainingDatasetType trainingDatasetType;
    private Integer storageConnectorId;
    private String storageConnectorName;
    private FeaturestoreStorageConnectorType storageConnectorType;
    private Long inodeId;

    public TrainingDatasetDTO() {
    }

    public TrainingDatasetDTO(TrainingDataset trainingDataset) {
        super(trainingDataset.getFeaturestore().getId(), trainingDataset.getName(), trainingDataset.getCreated(), trainingDataset.getCreator(), trainingDataset.getVersion(), (List)trainingDataset.getStatistics(), (List)trainingDataset.getJobs(), trainingDataset.getId());
        this.setDescription(trainingDataset.getDescription());
        this.setFeatures(trainingDataset.getFeatures().stream().map(tdf -> new FeatureDTO(tdf.getName(), tdf.getType(), tdf.getDescription(), tdf.getPrimary(), false, null)).collect(Collectors.toList()));
        this.dataFormat = trainingDataset.getDataFormat();
        this.trainingDatasetType = trainingDataset.getTrainingDatasetType();
    }

    @XmlElement
    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public Integer getStorageConnectorId() {
        return this.storageConnectorId;
    }

    public void setStorageConnectorId(Integer storageConnectorId) {
        this.storageConnectorId = storageConnectorId;
    }

    public String getStorageConnectorName() {
        return this.storageConnectorName;
    }

    public void setStorageConnectorName(String storageConnectorName) {
        this.storageConnectorName = storageConnectorName;
    }

    public FeaturestoreStorageConnectorType getStorageConnectorType() {
        return this.storageConnectorType;
    }

    public void setStorageConnectorType(FeaturestoreStorageConnectorType storageConnectorType) {
        this.storageConnectorType = storageConnectorType;
    }

    public Long getInodeId() {
        return this.inodeId;
    }

    public void setInodeId(Long inodeId) {
        this.inodeId = inodeId;
    }

    @XmlElement
    public TrainingDatasetType getTrainingDatasetType() {
        return this.trainingDatasetType;
    }

    public void setTrainingDatasetType(TrainingDatasetType trainingDatasetType) {
        this.trainingDatasetType = trainingDatasetType;
    }

    @Override
    public String toString() {
        return "TrainingDatasetDTO{dataFormat='" + this.dataFormat + '\'' + ", trainingDatasetType=" + this.trainingDatasetType + '}';
    }
}

