/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jupyter.config;

import io.hops.hopsworks.common.dao.jupyter.config.JupyterDTO;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.jupyter.JupyterProject;
import io.hops.hopsworks.persistence.entity.jupyter.JupyterSettings;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

public interface JupyterManager {
    public JupyterDTO startJupyterServer(Project var1, String var2, String var3, Users var4, JupyterSettings var5, String var6) throws ServiceException;

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    default public String getJupyterHome(Settings settings, String hdfsUser, Project project, String secret) throws ServiceException {
        if (project == null || secret == null) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.JUPYTER_HOME_ERROR, Level.WARNING, "user: " + hdfsUser);
        }
        return settings.getJupyterDir() + File.separator + "Projects" + File.separator + project.getName() + File.separator + hdfsUser + File.separator + secret;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    default public void projectCleanup(Settings settings, Logger logger, OSProcessExecutor osProcessExecutor, Project project) {
        int exitValue;
        String prog = settings.getSudoersDir() + "/jupyter-project-cleanup.sh";
        ProcessDescriptor.Builder pdBuilder = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand(project.getName());
        if (!logger.isLoggable(Level.FINE)) {
            pdBuilder.ignoreOutErrStreams(true);
        }
        try {
            ProcessResult processResult = osProcessExecutor.execute(pdBuilder.build());
            logger.log(Level.FINE, processResult.getStdout());
            exitValue = processResult.getExitCode();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Problem cleaning up project: " + project.getName() + ": {0}", ex.toString());
            exitValue = -2;
        }
        if (exitValue != 0) {
            logger.log(Level.WARNING, "Problem remove project's jupyter folder: " + project.getName());
        }
    }

    public void waitForStartup(Project var1, Users var2) throws TimeoutException;

    public void stopOrphanedJupyterServer(Long var1, Integer var2) throws ServiceException;

    public void stopJupyterServer(Project var1, Users var2, String var3, String var4, Long var5, Integer var6) throws ServiceException;

    public void projectCleanup(Project var1);

    public boolean ping(JupyterProject var1);

    public List<JupyterProject> getAllNotebooks();
}

