/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.experiments.tensorboard;

import io.hops.hopsworks.common.dao.hdfs.HdfsLeDescriptorsFacade;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsersFacade;
import io.hops.hopsworks.common.dao.tensorflow.TensorBoardFacade;
import io.hops.hopsworks.common.dao.tensorflow.config.TensorBoardDTO;
import io.hops.hopsworks.common.dao.tensorflow.config.TensorBoardProcessMgr;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.tensorflow.TfLibMappingUtil;
import io.hops.hopsworks.exceptions.TensorBoardException;
import io.hops.hopsworks.persistence.entity.hdfs.user.HdfsUsers;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.tensorflow.TensorBoard;
import io.hops.hopsworks.persistence.entity.tensorflow.TensorBoardPK;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.codec.digest.DigestUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class TensorBoardController {
    @EJB
    private TensorBoardFacade tensorBoardFacade;
    @EJB
    private TensorBoardProcessMgr tensorBoardProcessMgr;
    @EJB
    private HdfsLeDescriptorsFacade hdfsLeDescriptorsFacade;
    @EJB
    private HdfsUsersFacade hdfsUsersFacade;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private TfLibMappingUtil tfLibMappingUtil;
    private static final Logger LOGGER = Logger.getLogger(TensorBoardController.class.getName());

    public TensorBoardDTO getTensorBoard(Project project, Users user) {
        TensorBoard tb = this.tensorBoardFacade.findForProjectAndUser(project, user);
        if (tb == null) {
            return null;
        }
        tb.setLastAccessed(new Date());
        this.tensorBoardFacade.update(tb);
        return new TensorBoardDTO(tb);
    }

    public TensorBoardDTO startTensorBoard(String mlId, Project project, Users user, String tensorBoardLogdir) throws TensorBoardException {
        tensorBoardLogdir = this.prependNameNode(tensorBoardLogdir);
        TensorBoardDTO tensorBoardDTO = null;
        TensorBoard tb = this.tensorBoardFacade.findForProjectAndUser(project, user);
        if (tb != null) {
            this.cleanup(tb);
        }
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        HdfsUsers hdfsUser = this.hdfsUsersFacade.findByName(hdfsUsername);
        String tfLdLibraryPath = this.tfLibMappingUtil.getTfLdLibraryPath(project);
        String tensorBoardDirectory = DigestUtils.sha256Hex((String)Integer.toString(ThreadLocalRandom.current().nextInt()));
        tensorBoardDTO = this.tensorBoardProcessMgr.startTensorBoard(project, user, hdfsUser, tensorBoardLogdir, tfLdLibraryPath, tensorBoardDirectory);
        Date lastAccessed = new Date();
        tensorBoardDTO.setMlId(mlId);
        tensorBoardDTO.setLastAccessed(lastAccessed);
        tensorBoardDTO.setHdfsLogdir(tensorBoardLogdir);
        TensorBoard newTensorBoard = new TensorBoard();
        TensorBoardPK tensorBoardPK = new TensorBoardPK();
        tensorBoardPK.setProjectId(project.getId().intValue());
        tensorBoardPK.setUserId(user.getUid().intValue());
        newTensorBoard.setTensorBoardPK(tensorBoardPK);
        newTensorBoard.setPid(tensorBoardDTO.getPid());
        newTensorBoard.setEndpoint(tensorBoardDTO.getEndpoint());
        newTensorBoard.setHdfsUserId(hdfsUser.getId().intValue());
        newTensorBoard.setMlId(mlId);
        newTensorBoard.setLastAccessed(lastAccessed);
        newTensorBoard.setHdfsLogdir(tensorBoardLogdir);
        newTensorBoard.setSecret(tensorBoardDirectory);
        this.tensorBoardFacade.persist(newTensorBoard);
        return tensorBoardDTO;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void cleanup(Project project, Users user) throws TensorBoardException {
        TensorBoard tb = this.tensorBoardFacade.findForProjectAndUser(project, user);
        this.cleanup(tb);
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void cleanup(TensorBoard tb) throws TensorBoardException {
        if (tb != null) {
            if (this.tensorBoardProcessMgr.ping(tb)) {
                this.tensorBoardProcessMgr.killTensorBoard(tb);
            }
            this.tensorBoardFacade.remove(tb);
            this.tensorBoardProcessMgr.cleanup(tb);
        }
    }

    public void removeProject(Project project) throws TensorBoardException {
        Collection instances = project.getTensorBoardCollection();
        if (instances != null) {
            for (TensorBoard tensorBoard : instances) {
                this.cleanup(tensorBoard);
            }
        }
    }

    public String prependNameNode(String hdfsPath) {
        String endPoint = this.hdfsLeDescriptorsFacade.getRPCEndpoint();
        return "hdfs://" + endPoint + hdfsPath;
    }
}

