/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs;

import io.hops.hopsworks.common.dao.jobs.description.JobFacade;
import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.jobs.execution.ExecutionController;
import io.hops.hopsworks.persistence.entity.jobs.configuration.ScheduleDTO;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.ScheduleExpression;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;

@Stateless
public class JobScheduler {
    private static final Logger logger = Logger.getLogger(JobScheduler.class.getName());
    @EJB
    private JobFacade jobFacade;
    @EJB
    private ExecutionController executionController;
    @Resource
    private TimerService timerService;
    @EJB
    private ProjectTeamFacade projectTeamFacade;

    @Timeout
    public void timeout(Timer timer) {
        Serializable jobId = timer.getInfo();
        try {
            if (!(jobId instanceof Integer)) {
                logger.log(Level.WARNING, "Trying to run a scheduled execution, but info is not " + jobId.getClass().getSimpleName());
                return;
            }
            Jobs job = (Jobs)this.jobFacade.find(jobId);
            if (job == null) {
                logger.log(Level.WARNING, "Trying to run a job with non-existing id, canceling timer.");
                timer.cancel();
                return;
            }
            if (this.projectTeamFacade.findCurrentRole(job.getProject(), job.getCreator()) == null) {
                logger.log(Level.INFO, "Trying to run a job created by a user no longer in this project, canceling timer.");
                timer.cancel();
                return;
            }
            this.executionController.start(job, null, job.getCreator());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to start an execution for job " + jobId, e);
        }
    }

    public void scheduleJobPeriodic(Jobs job, int numberOfUnits, ScheduleDTO.TimeUnit timeUnit) {
        long interval = (long)numberOfUnits * timeUnit.getDuration();
        this.timerService.createTimer(new Date().getTime() + interval, interval, (Serializable)job.getId());
    }

    public void scheduleJobOnce(Jobs job, Date when) {
        TimerConfig config = new TimerConfig();
        config.setInfo((Serializable)job.getId());
        this.timerService.createSingleActionTimer(when, config);
    }

    public void scheduleJobOnCalendar(Jobs job, ScheduleExpression when) {
        TimerConfig config = new TimerConfig();
        config.setInfo((Serializable)job.getId());
        this.timerService.createCalendarTimer(when, config);
    }

    public void scheduleJobPeriodic(Jobs job) {
        if (job == null) {
            throw new IllegalArgumentException("Job parameter was null.");
        }
        if (job.getJobConfig().getSchedule() == null) {
            throw new IllegalArgumentException("Trying to schedule a job with null schedule: " + job);
        }
        ScheduleDTO schedule = job.getJobConfig().getSchedule();
        this.timerService.createTimer(new Date(schedule.getStart()), (long)schedule.getNumber() * schedule.getUnit().getDuration(), (Serializable)job.getId());
    }

    public boolean unscheduleJob(Jobs job) {
        Collection timers = this.timerService.getTimers();
        for (Timer timer : timers) {
            int jobId = (Integer)timer.getInfo();
            if (jobId != job.getId()) continue;
            timer.cancel();
            return true;
        }
        return false;
    }
}

