/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.online;

import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretsFacade;
import io.hops.hopsworks.common.featurestore.FeaturestoreController;
import io.hops.hopsworks.common.featurestore.FeaturestoreDTO;
import io.hops.hopsworks.common.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.RowValueQueryResult;
import io.hops.hopsworks.common.featurestore.featuregroup.online.OnlineFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.jdbc.FeaturestoreJdbcConnectorController;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.online.OnlineFeaturegroup;
import io.hops.hopsworks.persistence.entity.hdfs.user.HdfsUsers;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.secrets.SecretId;
import io.hops.hopsworks.persistence.entity.user.security.secrets.VisibilityType;
import io.hops.hopsworks.restutils.RESTCodes;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang3.RandomStringUtils;

@Stateless
public class OnlineFeaturestoreController {
    private static final Logger LOGGER = Logger.getLogger(OnlineFeaturestoreController.class.getName());
    private static final String MYSQL_DRIVER = "com.mysql.jdbc.Driver";
    @EJB
    private SecretsFacade secretsFacade;
    @EJB
    private Settings settings;
    @EJB
    private SecretsController secretsController;
    @EJB
    private ProjectTeamFacade projectTeamFacade;
    @EJB
    private FeaturestoreJdbcConnectorController featurestoreJdbcConnectorController;
    @EJB
    private OnlineFeaturestoreFacade onlineFeaturestoreFacade;
    @EJB
    private CachedFeaturegroupController cachedFeaturegroupController;
    @EJB
    private FeaturestoreController featurestoreController;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private UserFacade userFacade;

    @PostConstruct
    public void init() {
        try {
            Class.forName(MYSQL_DRIVER);
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Could not load the MySQL JDBC driver: com.mysql.jdbc.Driver", e);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    private Connection initConnection(String databaseName, Project project, Users user) throws FeaturestoreException {
        String jdbcString = "";
        String dbUsername = this.onlineDbUsername(project, user);
        String password = "";
        try {
            password = this.secretsController.get(user, dbUsername).getPlaintext();
        }
        catch (UserException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_SECRETS_ERROR, Level.SEVERE, "Problem getting secrets for the JDBC connection to the online FS");
        }
        jdbcString = this.settings.getFeaturestoreJdbcUrl() + databaseName;
        try {
            return DriverManager.getConnection(jdbcString, dbUsername, password);
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Error initiating MySQL JDBC connection to online feature store for user: " + user.getEmail() + " error:" + e);
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_INITIATE_MYSQL_CONNECTION_TO_ONLINE_FEATURESTORE, Level.SEVERE, "project: " + project.getName() + ", database: " + databaseName + ", db user:" + dbUsername + ", jdbcString: " + jdbcString, e.getMessage(), (Throwable)e);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void executeUpdateJDBCQuery(String query, String databaseName, Project project, Users user) throws FeaturestoreException, SQLException {
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.initConnection(databaseName, project, user);
            stmt = conn.createStatement();
            stmt.executeUpdate(query);
        }
        catch (SQLException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.MYSQL_JDBC_UPDATE_STATEMENT_ERROR, Level.SEVERE, "project: " + project.getName() + ", Online featurestore database: " + databaseName + " jdbc query: " + query, e.getMessage(), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            this.closeConnection(conn);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    private List<RowValueQueryResult> executeReadJDBCQuery(String query, String databaseName, Project project, Users user) throws SQLException, FeaturestoreException {
        Connection conn = null;
        Statement stmt = null;
        List<RowValueQueryResult> resultList = null;
        try {
            conn = this.initConnection(databaseName, project, user);
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            resultList = this.cachedFeaturegroupController.parseResultset(rs);
        }
        catch (SQLException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.MYSQL_JDBC_READ_QUERY_ERROR, Level.SEVERE, "project: " + project.getName() + ", mysql database: " + databaseName + " jdbc query: " + query, e.getMessage(), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            this.closeConnection(conn);
        }
        return resultList;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public List<FeatureDTO> getOnlineFeaturegroupFeatures(OnlineFeaturegroup onlineFeaturegroup) {
        return this.onlineFeaturestoreFacade.getMySQLFeatures(onlineFeaturegroup.getTableName(), onlineFeaturegroup.getDbName().toLowerCase());
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    private void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error closing MySQL JDBC connection: " + e);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void setupOnlineFeaturestore(Project project, Users user, Featurestore featurestore) throws FeaturestoreException {
        if (!this.settings.isOnlineFeaturestore().booleanValue()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_NOT_ENABLED, Level.FINE, "Online feature store service is not enabled for this Hopsworks instance");
        }
        this.addOnlineFeatureStoreDB(this.getOnlineFeaturestoreDbName(project));
        this.createDatabaseUser(user, project);
        this.updateUserOnlineFeatureStoreDB(project, user, featurestore);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void createDatabaseUser(Users user, Project project) throws FeaturestoreException {
        if (!this.settings.isOnlineFeaturestore().booleanValue()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_NOT_ENABLED, Level.FINE, "Online Feature Store is not enabled");
        }
        String dbUser = this.onlineDbUsername(project, user);
        String onlineFsPw = this.createOnlineFeaturestoreUserSecret(dbUser, user, project);
        try {
            this.onlineFeaturestoreFacade.createOnlineFeaturestoreUser(dbUser, onlineFsPw);
        }
        catch (Exception e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_CREATING_ONLINE_FEATURESTORE_USER, Level.SEVERE, "An error occurred when trying to create the MySQL database user for an online feature store", e.getMessage(), (Throwable)e);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    private String createOnlineFeaturestoreUserSecret(String dbuser, Users user, Project project) throws FeaturestoreException {
        String onlineFsPw = this.generateRandomUserPw();
        try {
            this.secretsController.delete(user, dbuser);
            this.secretsController.add(user, dbuser, onlineFsPw, VisibilityType.PRIVATE, project.getId());
        }
        catch (UserException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_SECRETS_ERROR, Level.SEVERE, "Problem adding online featurestore password to hopsworks secretsmgr");
        }
        return onlineFsPw;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public String onlineDbUsername(Project project, Users user) {
        return this.onlineDbUsername(project.getName(), user.getUsername());
    }

    public String getOnlineFeaturestoreDbName(Project project) {
        return project.getName().toLowerCase();
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    private String onlineDbUsername(String project, String user) {
        String username = project + "_" + user;
        if (username.length() > 32) {
            username = username.substring(0, 31);
        }
        return username;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void updateUserOnlineFeatureStoreDB(Project project, Users user, Featurestore featurestore) throws FeaturestoreException {
        if (!this.settings.isOnlineFeaturestore().booleanValue() || !this.checkIfDatabaseExists(this.getOnlineFeaturestoreDbName(project)).booleanValue()) {
            return;
        }
        String dbuser = this.onlineDbUsername(project, user);
        String db = this.getOnlineFeaturestoreDbName(project);
        this.onlineFeaturestoreFacade.revokeUserPrivileges(db, dbuser);
        try {
            if (this.projectTeamFacade.findCurrentRole(project, user).equalsIgnoreCase("Data owner")) {
                this.onlineFeaturestoreFacade.grantDataOwnerPrivileges(db, dbuser);
            } else {
                this.onlineFeaturestoreFacade.grantDataScientistPrivileges(db, dbuser);
            }
            try {
                this.featurestoreJdbcConnectorController.createJdbcConnectorForOnlineFeaturestore(dbuser, featurestore, db);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_GRANTING_ONLINE_FEATURESTORE_USER_PRIVILEGES, Level.SEVERE, "An error occurred when trying to create the MySQL database for an online feature store", e.getMessage(), (Throwable)e);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void addOnlineFeatureStoreDB(String db) throws FeaturestoreException {
        if (!this.settings.isOnlineFeaturestore().booleanValue()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_NOT_ENABLED, Level.FINE, "Online Feature Store is not enabled");
        }
        try {
            this.onlineFeaturestoreFacade.createOnlineFeaturestoreDatabase(db);
        }
        catch (Exception e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_CREATING_ONLINE_FEATURESTORE_DB, Level.SEVERE, "An error occurred when trying to create the MySQL database for an online feature store", e.getMessage(), (Throwable)e);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void removeOnlineFeatureStore(Project project) throws FeaturestoreException {
        if (!this.settings.isOnlineFeaturestore().booleanValue() || !this.checkIfDatabaseExists(this.getOnlineFeaturestoreDbName(project)).booleanValue()) {
            return;
        }
        for (HdfsUsers hdfsUser : this.hdfsUsersController.getAllProjectHdfsUsers(project.getName())) {
            Users user = this.userFacade.findByUsername(hdfsUser.getUsername());
            String dbUser = this.onlineDbUsername(project, user);
            try {
                this.secretsController.delete(user, dbUser);
            }
            catch (UserException e) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_SECRETS_ERROR, Level.SEVERE, "Problem removing user-secret to online featurestore");
            }
        }
        String db = this.getOnlineFeaturestoreDbName(project);
        try {
            this.onlineFeaturestoreFacade.removeOnlineFeaturestoreDatabase(db);
        }
        catch (Exception e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_DELETING_ONLINE_FEATURESTORE_DB, Level.SEVERE, "An error occurred when trying to delete the MySQL database user for an online feature store", e.getMessage(), (Throwable)e);
        }
        List<String> users = this.onlineFeaturestoreFacade.getDatabaseUsers(db);
        for (String dbUser : users) {
            try {
                this.onlineFeaturestoreFacade.removeOnlineFeaturestoreUser(dbUser);
            }
            catch (Exception e) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_DELETING_ONLINE_FEATURESTORE_USER, Level.SEVERE, "An error occurred when trying to delete the MySQL database user for an online feature store", e.getMessage(), (Throwable)e);
            }
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void removeOnlineFeaturestoreUser(Project project, Users user) throws FeaturestoreException {
        if (!this.settings.isOnlineFeaturestore().booleanValue()) {
            return;
        }
        String dbUser = this.onlineDbUsername(project.getName(), user.getUsername());
        SecretId id = new SecretId(user.getUid(), dbUser);
        this.secretsFacade.deleteSecret(id);
        try {
            this.onlineFeaturestoreFacade.removeOnlineFeaturestoreUser(dbUser);
        }
        catch (Exception e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_DELETING_ONLINE_FEATURESTORE_USER, Level.SEVERE, "An error occurred when trying to delete the MySQL database user for an online feature store", e.getMessage(), (Throwable)e);
        }
        FeaturestoreDTO featurestoreDTO = this.featurestoreController.getFeaturestoreForProjectWithName(project, this.featurestoreController.getOfflineFeaturestoreDbName(project));
        String connectorName = dbUser + "_onlinefeaturestore";
        List<FeaturestoreStorageConnectorDTO> jdbcConnectors = this.featurestoreJdbcConnectorController.getJdbcConnectorsForFeaturestore(this.featurestoreController.getFeaturestoreWithId(featurestoreDTO.getFeaturestoreId()));
        for (FeaturestoreStorageConnectorDTO storageConnector : jdbcConnectors) {
            if (!storageConnector.getName().equalsIgnoreCase(connectorName)) continue;
            this.featurestoreJdbcConnectorController.removeFeaturestoreJdbcConnector(storageConnector.getId());
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public Double getDbSize(String dbName) {
        Double dbSize = this.onlineFeaturestoreFacade.getDbSize(dbName);
        if (dbSize == null) {
            return 0.0;
        }
        return dbSize;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public Double getTblSize(OnlineFeaturegroupDTO onlineFeaturegroupDTO) {
        return this.onlineFeaturestoreFacade.getTblSize(onlineFeaturegroupDTO.getTableName(), onlineFeaturegroupDTO.getDbName().toLowerCase());
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public String getOnlineFeaturegroupSchema(OnlineFeaturegroupDTO onlineFeaturegroup) {
        return this.onlineFeaturestoreFacade.getMySQLSchema(onlineFeaturegroup.getTableName(), onlineFeaturegroup.getDbName().toLowerCase());
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public List<RowValueQueryResult> getOnlineFeaturegroupPreview(OnlineFeaturegroupDTO onlineFeaturegroup, Users user, Featurestore featurestore) throws FeaturestoreException, SQLException {
        String tbl = onlineFeaturegroup.getTableName();
        String query = "SELECT * FROM " + tbl + " LIMIT 20";
        String db = onlineFeaturegroup.getDbName().toLowerCase();
        try {
            return this.executeReadJDBCQuery(query, db, featurestore.getProject(), user);
        }
        catch (Exception e) {
            return this.executeReadJDBCQuery(query, db, featurestore.getProject(), user);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public String getOnlineFeaturegroupTableType(OnlineFeaturegroupDTO onlineFeaturegroup) {
        return this.onlineFeaturestoreFacade.getMySQLTableType(onlineFeaturegroup.getTableName(), onlineFeaturegroup.getDbName().toLowerCase());
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public Integer getOnlineFeaturegroupTableRows(OnlineFeaturegroupDTO onlineFeaturegroup) {
        return this.onlineFeaturestoreFacade.getMySQLTableRows(onlineFeaturegroup.getTableName(), onlineFeaturegroup.getDbName().toLowerCase());
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    private String generateRandomUserPw() {
        return RandomStringUtils.randomAlphabetic((int)32);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public Boolean checkIfDatabaseExists(String dbName) {
        return this.onlineFeaturestoreFacade.checkIfDatabaseExists(dbName);
    }
}

