/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.environment;

import io.hops.hopsworks.common.agent.AgentController;
import io.hops.hopsworks.common.dao.host.HostsFacade;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.python.CondaCommandFacade;
import io.hops.hopsworks.common.elastic.ElasticController;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.python.commands.CommandsController;
import io.hops.hopsworks.common.python.library.LibraryController;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ElasticException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.PythonException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.host.Hosts;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.CondaCommands;
import io.hops.hopsworks.persistence.entity.python.CondaInstallType;
import io.hops.hopsworks.persistence.entity.python.CondaOp;
import io.hops.hopsworks.persistence.entity.python.CondaStatus;
import io.hops.hopsworks.persistence.entity.python.MachineType;
import io.hops.hopsworks.persistence.entity.python.PythonDep;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class EnvironmentController {
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private HostsFacade hostsFacade;
    @EJB
    private Settings settings;
    @EJB
    private ProjectUtils projectUtils;
    @EJB
    private AgentController agentController;
    @EJB
    private LibraryController libraryController;
    @EJB
    private CondaCommandFacade condaCommandFacade;
    @EJB
    private CommandsController commandsController;
    @EJB
    private ElasticController elasticController;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private DistributedFsService dfs;
    private static final Logger LOGGER = Logger.getLogger(EnvironmentController.class.getName());
    private static final DateTimeFormatter ELASTIC_INDEX_FORMATTER = DateTimeFormatter.ofPattern("yyyy.MM.dd");

    public void checkCondaEnabled(Project project, String pythonVersion) throws PythonException {
        if (!project.getConda().booleanValue() || !pythonVersion.equals(project.getPythonVersion())) {
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_NOT_FOUND, Level.FINE);
        }
    }

    public void checkCondaEnvExists(Project project, Users user) throws ServiceException, ProjectException, PythonException, ElasticException {
        if (!project.getConda().booleanValue()) {
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_NOT_FOUND, Level.FINE);
        }
        if (!project.getCondaEnv().booleanValue()) {
            this.createKibanaIndex(project, user);
            this.copyOnWriteCondaEnv(project, user);
        }
    }

    public void synchronizeDependencies(Project project) throws ServiceException {
        String envStr = this.agentController.listCondaEnvironment(this.projectUtils.getCurrentCondaEnvironment(project));
        Collection<PythonDep> pythonDeps = this.agentController.synchronizeDependencies(envStr, project.getPythonDepCollection());
        this.libraryController.addPythonDepsForProject(project, pythonDeps);
    }

    private Collection<PythonDep> createProjectInDb(Project project, Users user, String pythonVersion, MachineType machineType, String environmentYml, Boolean installJupyter) throws ServiceException {
        if (environmentYml == null && pythonVersion.compareToIgnoreCase("2.7") != 0 && pythonVersion.compareToIgnoreCase("3.5") != 0 && pythonVersion.compareToIgnoreCase("3.6") != 0 && !pythonVersion.contains("X")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.PYTHON_INVALID_VERSION, Level.INFO, "pythonVersion: " + pythonVersion);
        }
        if (environmentYml != null) {
            this.condaEnvironmentOp(CondaOp.YML, pythonVersion, project, user, pythonVersion, machineType, environmentYml, installJupyter, false);
            this.setCondaEnv(project, true);
        } else {
            this.validateCondaHosts(machineType);
        }
        ArrayList<PythonDep> all = new ArrayList<PythonDep>();
        this.enableConda(project);
        return all;
    }

    private void enableConda(Project project) {
        if (project != null) {
            project.setConda(Boolean.valueOf(true));
            this.projectFacade.update(project);
            this.projectFacade.flushEm();
        }
    }

    private void setCondaEnv(Project project, boolean condaEnv) {
        project.setCondaEnv(Boolean.valueOf(condaEnv));
        this.projectFacade.mergeProject(project);
    }

    private List<Hosts> validateCondaHosts(MachineType machineType) throws ServiceException {
        List<Hosts> hosts = this.hostsFacade.getCondaHosts(machineType);
        if (hosts.isEmpty()) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_NODES_UNAVAILABLE, Level.WARNING);
        }
        return hosts;
    }

    public boolean condaEnabledHosts() {
        List<Hosts> hosts = this.hostsFacade.getCondaHosts(MachineType.ALL);
        return !hosts.isEmpty();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void copyOnWriteCondaEnv(Project project, Users user) throws ServiceException {
        this.setCondaEnv(project, true);
        this.condaEnvironmentOp(CondaOp.CREATE, project.getPythonVersion(), project, user, project.getPythonVersion(), MachineType.ALL, null, false, false);
    }

    public void removeEnvironment(Project proj, Users user) throws ServiceException, ElasticException {
        this.commandsController.deleteCommandsForProject(proj);
        if (proj.getCondaEnv().booleanValue()) {
            this.condaEnvironmentRemove(proj, user);
            this.setCondaEnv(proj, false);
        }
        this.deleteKibanaIndex(proj);
        this.removePythonForProject(proj);
    }

    private void condaEnvironmentOp(CondaOp op, String pythonVersion, Project proj, Users user, String arg, MachineType machineType, String environmentYml, Boolean installJupyter, boolean singleHost) throws ServiceException {
        if (this.projectUtils.isReservedProjectName(proj.getName())) {
            throw new IllegalStateException("Tried to execute a conda env op on a reserved project name");
        }
        List<Hosts> hosts = this.validateCondaHosts(machineType);
        if (singleHost) {
            CondaCommands cc = new CondaCommands(hosts.get(new Random().nextInt(hosts.size())), this.settings.getAnacondaUser(), user, op, CondaStatus.NEW, CondaInstallType.ENVIRONMENT, machineType, proj, pythonVersion, "", "defaults", new Date(), arg, environmentYml, installJupyter, this.projectUtils.getCurrentCondaEnvironment(proj));
            this.condaCommandFacade.save(cc);
        } else {
            for (Hosts h : hosts) {
                CondaCommands cc = new CondaCommands(h, this.settings.getAnacondaUser(), user, op, CondaStatus.NEW, CondaInstallType.ENVIRONMENT, machineType, proj, pythonVersion, "", "defaults", new Date(), arg, environmentYml, installJupyter, this.projectUtils.getCurrentCondaEnvironment(proj));
                this.condaCommandFacade.save(cc);
            }
        }
    }

    private void condaEnvironmentRemove(Project proj, Users user) throws ServiceException {
        this.condaEnvironmentOp(CondaOp.REMOVE, "", proj, user, "", MachineType.ALL, null, false, false);
    }

    private void condaEnvironmentClone(Project srcProj, Project destProj, Users user) throws ServiceException {
        this.condaEnvironmentOp(CondaOp.CLONE, "", srcProj, user, destProj.getName(), MachineType.ALL, null, false, false);
    }

    public CondaCommands getOngoingEnvCreation(Project proj) {
        List<CondaCommands> commands = this.condaCommandFacade.getCommandsForProject(proj);
        for (CondaCommands command : commands) {
            if (!command.getOp().equals((Object)CondaOp.YML) && !command.getOp().equals((Object)CondaOp.CREATE) || !command.getStatus().equals((Object)CondaStatus.NEW) && !command.getStatus().equals((Object)CondaStatus.ONGOING)) continue;
            return command;
        }
        return null;
    }

    public void cleanupConda() throws ServiceException {
        List<Project> projects = this.projectFacade.findAll();
        if (projects != null && !projects.isEmpty()) {
            Project project = projects.get(0);
            this.condaEnvironmentOp(CondaOp.CLEAN, "", project, project.getOwner(), "", MachineType.ALL, "", false, false);
        }
    }

    private void removePythonForProject(Project proj) {
        proj.setPythonDepCollection(new ArrayList());
        proj.setPythonVersion("");
        proj.setConda(Boolean.valueOf(false));
        this.projectFacade.update(proj);
    }

    public String findPythonVersion(String ymlFile) throws PythonException {
        String foundVersion = null;
        Pattern urlPattern = Pattern.compile("(- python=(\\d+.\\d+))");
        Matcher urlMatcher = urlPattern.matcher(ymlFile);
        if (!urlMatcher.find()) {
            throw new PythonException(RESTCodes.PythonErrorCode.YML_FILE_MISSING_PYTHON_VERSION, Level.FINE);
        }
        foundVersion = urlMatcher.group(2);
        return foundVersion;
    }

    public String createEnvironmentFromYml(String allYmlPath, String cpuYmlPath, String gpuYmlPath, boolean installJupyter, Users user, Project project) throws PythonException, ServiceException, ProjectException, ElasticException {
        String pythonVersionGPUYml;
        if (project.getConda().booleanValue() || project.getCondaEnv().booleanValue()) {
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_ALREADY_INITIALIZED, Level.FINE);
        }
        String username = this.hdfsUsersController.getHdfsUserName(project, user);
        String version = "0.0";
        if (allYmlPath != null && !allYmlPath.isEmpty()) {
            String pythonVersion;
            if (!allYmlPath.substring(allYmlPath.length() - 4).equals(".yml")) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.INVALID_YML, Level.FINE, "allYmlPath is not a valid .yml file");
            }
            String allYml = this.getYmlFromPath(new Path(allYmlPath), username);
            version = pythonVersion = this.findPythonVersion(allYml);
            this.createKibanaIndex(project, user);
            this.createProjectInDb(project, user, version, MachineType.ALL, allYml, installJupyter);
            project.setPythonVersion(version);
            this.projectFacade.update(project);
            return version;
        }
        if (cpuYmlPath != null && !cpuYmlPath.isEmpty() && !cpuYmlPath.substring(cpuYmlPath.length() - 4).equals(".yml")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.INVALID_YML, Level.FINE, "cpuYmlPath is not a valid .yml file");
        }
        if (gpuYmlPath != null && !gpuYmlPath.isEmpty() && !gpuYmlPath.substring(gpuYmlPath.length() - 4).equals(".yml")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.INVALID_YML, Level.FINE, "gpuYmlPath is not a valid .yml file");
        }
        String cpuYml = cpuYmlPath != null && !cpuYmlPath.isEmpty() ? this.getYmlFromPath(new Path(cpuYmlPath), username) : "";
        String gpuYml = gpuYmlPath != null && !gpuYmlPath.isEmpty() ? this.getYmlFromPath(new Path(gpuYmlPath), username) : "";
        String pythonVersionCPUYml = this.findPythonVersion(cpuYml);
        if (!pythonVersionCPUYml.equals(pythonVersionGPUYml = this.findPythonVersion(gpuYml))) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.INVALID_YML, Level.FINE, "python version mismatch between .yml files.");
        }
        version = pythonVersionCPUYml;
        this.createKibanaIndex(project, user);
        this.createProjectInDb(project, user, version, MachineType.CPU, cpuYml, installJupyter);
        this.createProjectInDb(project, user, version, MachineType.GPU, gpuYml, installJupyter);
        project.setPythonVersion(version);
        this.projectFacade.update(project);
        return version;
    }

    public String[] exportEnv(Project project, Users user, String projectRelativeExportPath) throws PythonException, ServiceException {
        Optional<String> gpuHost;
        if (!project.getConda().booleanValue()) {
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_NOT_FOUND, Level.FINE);
        }
        Optional<String> cpuHost = this.hostsFacade.findCPUHost();
        Date date = new Date();
        ArrayList<String> ymlList = new ArrayList<String>();
        long exportTime = date.getTime();
        if (cpuHost.isPresent()) {
            String cpuYmlPath = projectRelativeExportPath + "/environment_cpu_" + exportTime + ".yml";
            this.condaEnvironmentOp(CondaOp.EXPORT, project.getPythonVersion(), project, user, cpuYmlPath, MachineType.CPU, null, false, true);
            ymlList.add(cpuYmlPath);
        }
        if ((gpuHost = this.hostsFacade.findGPUHost()).isPresent()) {
            String gpuYmlPath = projectRelativeExportPath + "/environment_gpu_" + exportTime + ".yml";
            this.condaEnvironmentOp(CondaOp.EXPORT, project.getPythonVersion(), project, user, gpuYmlPath, MachineType.GPU, null, false, true);
            ymlList.add(gpuYmlPath);
        }
        return ymlList.toArray(new String[0]);
    }

    public void createEnv(Project project, Users user, String version) throws PythonException, ServiceException, ProjectException {
        if (project.getConda().booleanValue() || project.getCondaEnv().booleanValue()) {
            throw new PythonException(RESTCodes.PythonErrorCode.ANACONDA_ENVIRONMENT_ALREADY_INITIALIZED, Level.FINE);
        }
        this.createProjectInDb(project, user, version, MachineType.ALL, null, false);
        project.setPythonVersion(version);
        this.projectFacade.update(project);
        this.synchronizeDependencies(project);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getYmlFromPath(Path fullPath, String username) throws ServiceException {
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(username);
            long fileSize = udfso.getFileStatus(fullPath).getLen();
            byte[] ymlFileInBytes = new byte[(int)fileSize];
            if (fileSize >= 10000L) throw new ServiceException(RESTCodes.ServiceErrorCode.INVALID_YML_SIZE, Level.WARNING);
            try (DataInputStream dis = new DataInputStream((InputStream)udfso.open(fullPath));){
                dis.readFully(ymlFileInBytes, 0, (int)fileSize);
                String ymlFileContents = new String(ymlFileInBytes);
                String string = ymlFileContents = Arrays.stream(ymlFileContents.split(System.lineSeparator())).filter(line -> !line.contains("jupyter")).filter(line -> !line.contains("sparkmagic")).filter(line -> !line.contains("hdfscontents")).collect(Collectors.joining(System.lineSeparator()));
                return string;
            }
            {
                catch (IOException ex) {
                    throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_FROM_YML_ERROR, Level.SEVERE, "path: " + fullPath, ex.getMessage(), (Throwable)ex);
                }
            }
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    public void createKibanaIndex(Project project, Users user) throws ServiceException, ProjectException, ElasticException {
        String indexName = project.getName().toLowerCase() + "_kagent-*".replace("*", LocalDateTime.now().format(ELASTIC_INDEX_FORMATTER));
        if (!this.elasticController.indexExists(indexName)) {
            this.elasticController.createIndex(indexName);
        }
        this.elasticController.createIndexPattern(project, user, project.getName().toLowerCase() + "_kagent-*");
    }

    private void deleteKibanaIndex(Project project) throws ElasticException {
        String indexName = project.getName().toLowerCase() + "_kagent-*";
        this.elasticController.deleteIndex(indexName);
        this.elasticController.deleteIndexPattern(project, indexName);
    }

    public void uploadYmlInProject(Project project, Users user, String environmentYml, String relativePath) throws ServiceException {
        DistributedFileSystemOps udfso = null;
        String hdfsUser = this.hdfsUsersController.getHdfsUserName(project, user);
        try {
            udfso = this.dfs.getDfsOps(hdfsUser);
            Path projectYmlPath = new Path(Utils.getProjectPath(project.getName()) + "/" + relativePath);
            udfso.create(projectYmlPath, environmentYml);
        }
        catch (IOException ex) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_EXPORT_ERROR, Level.SEVERE, "path: " + relativePath, ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }
}

