/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.maggy;

import io.hops.hopsworks.persistence.entity.maggy.MaggyDriver;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class MaggyFacade {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public MaggyDriver findByAppId(String appId) {
        TypedQuery query;
        try {
            query = this.em.createNamedQuery("MaggyDriver.findByAppId", MaggyDriver.class).setParameter("appId", (Object)appId);
        }
        catch (EntityNotFoundException | NoResultException e) {
            Logger.getLogger(MaggyFacade.class.getName()).log(Level.WARNING, null, e);
            return null;
        }
        catch (Throwable e) {
            Logger.getLogger(MaggyFacade.class.getName()).log(Level.WARNING, null, e);
            e.printStackTrace();
            return null;
        }
        return (MaggyDriver)query.getSingleResult();
    }

    public List<MaggyDriver> getAllDrivers() {
        List res;
        try {
            TypedQuery query = this.em.createNamedQuery("MaggyDriver.findAll", MaggyDriver.class);
            res = query.getResultList();
        }
        catch (EntityNotFoundException | NoResultException e) {
            Logger.getLogger(MaggyFacade.class.getName()).log(Level.WARNING, null, e);
            return null;
        }
        catch (Throwable e) {
            Logger.getLogger(MaggyFacade.class.getName()).log(Level.WARNING, null, e);
            e.printStackTrace();
            return null;
        }
        return res;
    }

    public void remove(MaggyDriver driver) {
        if (driver != null) {
            this.em.remove((Object)driver);
        }
    }

    public void add(MaggyDriver driver) {
        if (driver != null) {
            driver.setCreated((Date)Timestamp.valueOf(LocalDateTime.now()));
            this.em.persist((Object)driver);
        }
    }
}

