/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.app;

import io.hops.hopsworks.common.provenance.app.dto.ProvAppStateElastic;
import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticHelper;
import io.hops.hopsworks.common.provenance.core.elastic.ElasticHitsHandler;
import io.hops.hopsworks.common.provenance.core.elastic.ProvElasticController;
import io.hops.hopsworks.common.provenance.util.ProvHelper;
import io.hops.hopsworks.common.provenance.util.functional.CheckedFunction;
import io.hops.hopsworks.common.provenance.util.functional.CheckedSupplier;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ElasticException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.javatuples.Pair;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ProvAppController {
    @EJB
    private Settings settings;
    @EJB
    private ProvElasticController client;

    public Map<String, Map<Provenance.AppState, ProvAppStateElastic>> provAppState(Map<String, ProvParser.FilterVal> appStateFilters) throws ProvenanceException {
        Pair<Long, Map<String, Map<Provenance.AppState, ProvAppStateElastic>>> searchResult;
        CheckedSupplier<SearchRequest, ProvenanceException> srF = ElasticHelper.scrollingSearchRequest("app_prov", this.settings.getElasticDefaultScrollPageSize()).andThen(this.provAppStateQB(appStateFilters));
        SearchRequest request = srF.get();
        try {
            searchResult = this.client.searchScrolling(request, this.appStateParser());
        }
        catch (ElasticException e) {
            String msg = "provenance - elastic query problem";
            throw ProvHelper.fromElastic(e, msg, msg + " - app state");
        }
        return (Map)searchResult.getValue1();
    }

    private ElasticHitsHandler<ProvAppStateElastic, Map<String, Map<Provenance.AppState, ProvAppStateElastic>>, ?, ProvenanceException> appStateParser() {
        return ElasticHitsHandler.instanceBasic(new HashMap(), hit -> ProvAppStateElastic.instance(hit), (item, state) -> {
            Map appStates = state.computeIfAbsent(item.getAppId(), k -> new TreeMap());
            appStates.put(item.getAppState(), item);
        });
    }

    private CheckedFunction<SearchRequest, SearchRequest, ProvenanceException> provAppStateQB(Map<String, ProvParser.FilterVal> appStateFilters) {
        return sr -> {
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query = ElasticHelper.filterByBasicFields(query, appStateFilters);
            sr.source().query((QueryBuilder)query);
            return sr;
        };
    }
}

