/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.user.security.apiKey;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.apiKey.ApiKey;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class ApiKeyFacade
extends AbstractFacade<ApiKey> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public ApiKeyFacade() {
        super(ApiKey.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public ApiKey findByPrefix(String prefix) {
        TypedQuery query = this.em.createNamedQuery("ApiKey.findByPrefix", ApiKey.class).setParameter("prefix", (Object)prefix);
        try {
            return (ApiKey)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public ApiKey findByUserAndName(Users user, String name) {
        TypedQuery query = this.em.createNamedQuery("ApiKey.findByUserAndName", ApiKey.class).setParameter("user", (Object)user).setParameter("name", (Object)name);
        try {
            return (ApiKey)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<ApiKey> findByUser(Users user) {
        TypedQuery query = this.em.createNamedQuery("ApiKey.findByUser", ApiKey.class).setParameter("user", (Object)user);
        return query.getResultList();
    }

    public AbstractFacade.CollectionInfo findByUser(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort, Users user) {
        String queryStr = this.buildQuery("SELECT a FROM ApiKey a ", filter, sort, "a.user = :user ");
        String queryCountStr = this.buildQuery("SELECT COUNT(a.id) FROM ApiKey a ", filter, sort, "a.user = :user ");
        TypedQuery query = this.em.createQuery(queryStr, ApiKey.class).setParameter("user", (Object)user);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, ApiKey.class).setParameter("user", (Object)user);
        return this.findAll(offset, limit, filter, (Query)query, (Query)queryCount);
    }

    private AbstractFacade.CollectionInfo findAll(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Query query, Query queryCount) {
        this.setFilter(filter, query);
        this.setFilter(filter, queryCount);
        this.setOffsetAndLim(offset, limit, query);
        return new AbstractFacade.CollectionInfo(this, (Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filters, Query q) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filters) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filter, Query q) {
        switch (Filters.valueOf(filter.getValue())) {
            case NAME: {
                q.setParameter(filter.getField(), (Object)filter.getParam());
                break;
            }
            case CREATED: 
            case MODIFIED: 
            case CREATED_GT: 
            case CREATED_LT: 
            case MODIFIED_GT: 
            case MODIFIED_LT: {
                Date date = this.getDate(filter.getField(), filter.getParam());
                q.setParameter(filter.getField(), (Object)date);
                break;
            }
        }
    }

    public static enum Filters {
        NAME("NAME", "a.name IN :name ", "name", " "),
        MODIFIED("MODIFIED", "a.modified = :modified ", "modified", "1970-01-01T00:00:00.000"),
        MODIFIED_LT("MODIFIED_LT", "a.modified < :modified_lt ", "modified_lt", "1970-01-01T00:00:00.000"),
        MODIFIED_GT("MODIFIED_GT", "a.modified > :modified_gt ", "modified_gt", "1970-01-01T00:00:00.000"),
        CREATED("CREATED", "a.created = :created ", "created", "1970-01-01T00:00:00.000"),
        CREATED_LT("CREATED_LT", "a.created < :created_lt ", "created_lt", "1970-01-01T00:00:00.000"),
        CREATED_GT("CREATED_GT", "a.created > :created_gt ", "created_gt", "1970-01-01T00:00:00.000");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        NAME("NAME", "a.name ", "ASC"),
        MODIFIED("MODIFIED", "a.modified ", "ASC"),
        CREATED("CREATED", "a.created ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

