/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.serving;

import io.hops.hopsworks.exceptions.ServingException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.serving.Serving;
import io.hops.hopsworks.restutils.RESTCodes;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.LockTimeoutException;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;

@Stateless
public class ServingFacade {
    private static final Logger LOGGER = Logger.getLogger(ServingFacade.class.getName());
    private static final long LOCK_TIMEOUT = 60000L;
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    private String nodeIP = null;

    @PostConstruct
    private void init() {
        try {
            this.nodeIP = Inet4Address.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.log(Level.SEVERE, "Could not get host address", e);
        }
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public List<Serving> findForProject(Project project) {
        return this.em.createNamedQuery("Serving.findByProject", Serving.class).setParameter("project", (Object)project).getResultList();
    }

    public Serving findById(Integer id) {
        return (Serving)this.em.createNamedQuery("Serving.findById", Serving.class).setParameter("id", (Object)id).getSingleResult();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void delete(Serving serving) {
        Serving refetched = (Serving)this.em.find(Serving.class, (Object)serving.getId());
        if (refetched != null) {
            this.em.remove((Object)refetched);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Serving updateDbObject(Serving newServing, Project project) throws ServingException {
        Serving dbServing = this.findByProjectAndId(project, newServing.getId());
        if (newServing.getName() != null && !newServing.getName().isEmpty()) {
            dbServing.setName(newServing.getName());
        }
        if (newServing.getArtifactPath() != null && !newServing.getArtifactPath().isEmpty()) {
            dbServing.setArtifactPath(newServing.getArtifactPath());
        }
        if (newServing.getInstances() != null) {
            dbServing.setInstances(newServing.getInstances());
        }
        if (newServing.getVersion() != null) {
            dbServing.setVersion(newServing.getVersion());
        }
        dbServing.setKafkaTopic(newServing.getKafkaTopic());
        if (newServing.getLocalPid() != null) {
            dbServing.setLocalPid(newServing.getLocalPid());
        }
        if (newServing.getLocalDir() != null) {
            dbServing.setLocalDir(newServing.getLocalDir());
        }
        if (newServing.getLocalPort() != null) {
            dbServing.setLocalPort(newServing.getLocalPort());
        }
        if (newServing.isBatchingEnabled() != null) {
            dbServing.setBatchingEnabled(newServing.isBatchingEnabled());
        }
        if (newServing.getServingType() != null && newServing.getServingType() != dbServing.getServingType()) {
            throw new ServingException(RESTCodes.ServingErrorCode.UPDATE_SERVING_TYPE_ERROR, Level.FINE);
        }
        return this.merge(dbServing);
    }

    public Serving merge(Serving serving) {
        return (Serving)this.em.merge((Object)serving);
    }

    public Serving findByProjectAndId(Project project, Integer id) {
        try {
            return (Serving)this.em.createNamedQuery("Serving.findByProjectAndId", Serving.class).setParameter("project", (Object)project).setParameter("id", (Object)id).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Serving findByProjectAndName(Project project, String servingName) {
        try {
            return (Serving)this.em.createNamedQuery("Serving.findByProjectAndName", Serving.class).setParameter("project", (Object)project).setParameter("name", (Object)servingName).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Serving acquireLock(Project project, Integer id) throws ServingException {
        int retries = 5;
        if (this.nodeIP == null) {
            throw new ServingException(RESTCodes.ServingErrorCode.LIFECYCLEERRORINT, Level.SEVERE);
        }
        while (retries > 0) {
            try {
                Serving serving = (Serving)this.em.createNamedQuery("Serving.findByProjectAndId", Serving.class).setParameter("project", (Object)project).setParameter("id", (Object)id).setLockMode(LockModeType.PESSIMISTIC_WRITE).getSingleResult();
                if (serving == null) {
                    throw new ServingException(RESTCodes.ServingErrorCode.INSTANCENOTFOUND, Level.WARNING);
                }
                if (serving.getLockIP() != null && serving.getLockTimestamp() > System.currentTimeMillis() - 60000L) {
                    --retries;
                    continue;
                }
                serving.setLockIP(this.nodeIP);
                serving.setLockTimestamp(Long.valueOf(System.currentTimeMillis()));
                return (Serving)this.em.merge((Object)serving);
            }
            catch (LockTimeoutException e) {
                --retries;
            }
        }
        throw new ServingException(RESTCodes.ServingErrorCode.LIFECYCLEERRORINT, Level.FINE);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Serving releaseLock(Project project, Integer id) throws ServingException {
        for (int retries = 5; retries > 0; --retries) {
            try {
                Serving serving = (Serving)this.em.createNamedQuery("Serving.findByProjectAndId", Serving.class).setParameter("project", (Object)project).setParameter("id", (Object)id).setLockMode(LockModeType.PESSIMISTIC_WRITE).getSingleResult();
                serving.setLockIP(null);
                serving.setLockTimestamp(null);
                return (Serving)this.em.merge((Object)serving);
            }
            catch (LockTimeoutException e) {
                continue;
            }
        }
        throw new ServingException(RESTCodes.ServingErrorCode.LIFECYCLEERRORINT, Level.FINE);
    }

    public List<Serving> getLocalhostRunning() {
        return this.em.createNamedQuery("Serving.findLocalhostRunning", Serving.class).getResultList();
    }
}

