/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.tensorflow.config;

import com.google.common.io.Files;
import io.hops.hopsworks.common.dao.tensorflow.config.TensorBoardDTO;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.proxies.client.HttpClient;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.TensorBoardException;
import io.hops.hopsworks.persistence.entity.hdfs.user.HdfsUsers;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.tensorflow.TensorBoard;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpHead;

@Stateless
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
@DependsOn(value={"Settings"})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class TensorBoardProcessMgr {
    private static final Logger LOGGER = Logger.getLogger(TensorBoardProcessMgr.class.getName());
    private static final String TENSORBOARD_HOST_TEMPLATE = "http://%s:%d";
    private static final String PING_PATH = "/hopsworks-api/tensorboard/experiments/%s/";
    @EJB
    private Settings settings;
    @EJB
    private DistributedFsService dfsService;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private HttpClient httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TensorBoardDTO startTensorBoard(Project project, Users user, HdfsUsers hdfsUser, String hdfsLogdir, String tfLdLibraryPath, String tensorBoardDirectory) throws TensorBoardException {
        String prog = this.settings.getHopsworksDomainDir() + "/bin/tensorboard.sh";
        Integer port = 0;
        BigInteger pid = null;
        String tbBasePath = this.settings.getStagingDir() + "/tensorboard/";
        String tbSecretDir = tbBasePath + tensorBoardDirectory;
        String certsPath = "";
        File tbDir = new File(tbSecretDir);
        if (!tbDir.exists()) {
            tbDir.mkdirs();
        }
        DistributedFileSystemOps dfso = this.dfsService.getDfsOps();
        try {
            certsPath = tbSecretDir + "/certs";
            File certsDir = new File(certsPath);
            certsDir.mkdirs();
            HopsUtils.materializeCertificatesForUserCustomDir(project.getName(), user.getUsername(), this.settings.getHdfsTmpCertDir(), dfso, this.certificateMaterializer, this.settings, certsPath);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Failed in materializing certificates for " + hdfsUser + " in directory " + certsPath, ioe);
            HopsUtils.cleanupCertificatesForUserCustomDir(user.getUsername(), project.getName(), this.settings.getHdfsTmpCertDir(), this.certificateMaterializer, certsPath, this.settings);
            throw new TensorBoardException(RESTCodes.TensorBoardErrorCode.TENSORBOARD_START_ERROR, Level.SEVERE, "Failed to start TensorBoard", "An exception occurred while materializing certificates", (Throwable)ioe);
        }
        finally {
            if (dfso != null) {
                this.dfsService.closeDfsClient(dfso);
            }
        }
        String anacondaEnvironmentPath = this.settings.getAnacondaProjectDir(project);
        int retries = 3;
        while (retries > 0) {
            try {
                if (retries == 0) {
                    throw new IOException("Failed to start TensorBoard for project=" + project.getName() + ", user=" + user.getUid());
                }
                port = ThreadLocalRandom.current().nextInt(40000, 59999);
                ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand(prog).addCommand("start").addCommand(hdfsUser.getName()).addCommand(hdfsLogdir).addCommand(tbSecretDir).addCommand(port.toString()).addCommand(anacondaEnvironmentPath).addCommand(this.settings.getHadoopVersion()).addCommand(this.settings.getJavaHome()).addCommand(tfLdLibraryPath).ignoreOutErrStreams(true).build();
                LOGGER.log(Level.FINE, processDescriptor.toString());
                ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
                if (!processResult.processExited()) {
                    throw new IOException("TensorBoard start process timed out!");
                }
                int exitValue = processResult.getExitCode();
                String pidPath = tbSecretDir + File.separator + port + ".pid";
                File pidFile = new File(pidPath);
                if (pidFile.exists()) {
                    String pidContents = Files.readFirstLine((File)pidFile, (Charset)Charset.defaultCharset());
                    pid = BigInteger.valueOf(Long.parseLong(pidContents));
                }
                if (exitValue == 0 && pid != null) {
                    TensorBoardDTO tensorBoardDTO = new TensorBoardDTO();
                    String host = null;
                    try {
                        host = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                    tensorBoardDTO.setEndpoint(host + ":" + port);
                    tensorBoardDTO.setPid(pid);
                    TensorBoardDTO tensorBoardDTO2 = tensorBoardDTO;
                    return tensorBoardDTO2;
                }
                LOGGER.log(Level.SEVERE, "Failed starting TensorBoard got exitcode " + exitValue + " retrying on new port");
                if (pid == null) continue;
                this.killTensorBoard(pid);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Problem starting TensorBoard: {0}", ex);
            }
            finally {
                --retries;
            }
        }
        certsPath = tbBasePath + "/certs";
        HopsUtils.cleanupCertificatesForUserCustomDir(user.getUsername(), project.getName(), this.settings.getHdfsTmpCertDir(), this.certificateMaterializer, certsPath, this.settings);
        this.removeTensorBoardDirectory(tbSecretDir);
        throw new TensorBoardException(RESTCodes.TensorBoardErrorCode.TENSORBOARD_START_ERROR, Level.SEVERE, "Failed to start TensorBoard after exhausting retry attempts");
    }

    public int killTensorBoard(BigInteger pid) {
        int exitValue;
        String prog = this.settings.getHopsworksDomainDir() + "/bin/tensorboard.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand(prog).addCommand("kill").addCommand(pid.toString()).ignoreOutErrStreams(true).build();
        LOGGER.log(Level.FINE, processDescriptor.toString());
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (!processResult.processExited()) {
                LOGGER.log(Level.SEVERE, "Failed to kill TensorBoard");
            }
            exitValue = processResult.getExitCode();
        }
        catch (IOException ex) {
            exitValue = 2;
            LOGGER.log(Level.SEVERE, "Failed to kill TensorBoard", ex);
        }
        return exitValue;
    }

    public int killTensorBoard(TensorBoard tb) {
        int exitValue;
        String prog = this.settings.getHopsworksDomainDir() + "/bin/tensorboard.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand(prog).addCommand("kill").addCommand(tb.getPid().toString()).ignoreOutErrStreams(true).build();
        LOGGER.log(Level.FINE, processDescriptor.toString());
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (!processResult.processExited()) {
                LOGGER.log(Level.SEVERE, "Failed to kill TensorBoard, process time-out");
            }
            exitValue = processResult.getExitCode();
        }
        catch (IOException ex) {
            exitValue = 2;
            LOGGER.log(Level.SEVERE, "Failed to kill TensorBoard", ex);
        }
        return exitValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(TensorBoard tb) throws TensorBoardException {
        String tbBasePath = this.settings.getStagingDir() + "/tensorboard/";
        String tbPath = tbBasePath + tb.getSecret();
        String certsPath = tbPath + "/certs";
        DistributedFileSystemOps dfso = this.dfsService.getDfsOps();
        try {
            HopsUtils.cleanupCertificatesForUserCustomDir(tb.getUsers().getUsername(), tb.getProject().getName(), this.settings.getHdfsTmpCertDir(), this.certificateMaterializer, certsPath, this.settings);
        }
        finally {
            if (dfso != null) {
                this.dfsService.closeDfsClient(dfso);
            }
        }
        this.removeTensorBoardDirectory(tbPath);
    }

    public void removeTensorBoardDirectory(String tensorBoardDirectoryPath) throws TensorBoardException {
        String prog = this.settings.getHopsworksDomainDir() + "/bin/tensorboard.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand(prog).addCommand("cleanup").addCommand(tensorBoardDirectoryPath).ignoreOutErrStreams(true).build();
        LOGGER.log(Level.FINE, processDescriptor.toString());
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (!processResult.processExited() || processResult.getExitCode() != 0) {
                throw new TensorBoardException(RESTCodes.TensorBoardErrorCode.TENSORBOARD_CLEANUP_ERROR, Level.SEVERE, "Failed to cleanup TensorBoard", "Could not delete TensorBoard directory: " + tensorBoardDirectoryPath);
            }
        }
        catch (IOException ex) {
            throw new TensorBoardException(RESTCodes.TensorBoardErrorCode.TENSORBOARD_CLEANUP_ERROR, Level.SEVERE, "Failed to cleanup TensorBoard", "Could not delete TensorBoard directory: " + tensorBoardDirectoryPath, (Throwable)ex);
        }
    }

    public boolean ping(TensorBoard tensorBoard) {
        String tensorBoardEndpoint = tensorBoard.getEndpoint();
        String[] hostPortPair = tensorBoardEndpoint.split(":");
        HttpHost host = HttpHost.create((String)String.format(TENSORBOARD_HOST_TEMPLATE, hostPortPair[0], Integer.parseInt(hostPortPair[1])));
        try {
            HttpHead httpRequest = new HttpHead(host.toURI());
            return this.httpClient.execute(host, (HttpRequest)httpRequest, new ResponseHandler<Boolean>(){

                public Boolean handleResponse(HttpResponse response) {
                    int status = response.getStatusLine().getStatusCode();
                    return status == 200;
                }
            });
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Could not parse URI to ping Jupyter server", ex);
            return false;
        }
    }
}

