/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.cached;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.featurestore.FeaturestoreController;
import io.hops.hopsworks.common.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.ColumnValueQueryResult;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeaturegroupPreview;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.RowValueQueryResult;
import io.hops.hopsworks.common.featurestore.featuregroup.online.OnlineFeaturegroupController;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreController;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreInputValidation;
import io.hops.hopsworks.common.hive.HiveController;
import io.hops.hopsworks.common.hive.HiveTableType;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.CryptoPasswordNotFoundException;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.FeaturegroupType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.CachedFeaturegroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.online.OnlineFeaturegroup;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang3.StringUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class CachedFeaturegroupController {
    @EJB
    private CachedFeaturegroupFacade cachedFeaturegroupFacade;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    private Settings settings;
    @EJB
    private FeaturestoreController featurestoreController;
    @EJB
    private OnlineFeaturegroupController onlineFeaturegroupController;
    @EJB
    private OnlineFeaturestoreController onlineFeaturestoreController;
    @EJB
    private FeaturestoreInputValidation featurestoreInputValidation;
    @EJB
    private HiveController hiveController;
    private static final Logger LOGGER = Logger.getLogger(CachedFeaturegroupController.class.getName());
    private static final String HIVE_DRIVER = "org.apache.hive.jdbc.HiveDriver";

    @PostConstruct
    public void init() {
        try {
            Class.forName(HIVE_DRIVER);
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Could not load the Hive driver: org.apache.hive.jdbc.HiveDriver", e);
        }
    }

    private Connection initConnection(String databaseName, Project project, Users user) throws FeaturestoreException {
        try {
            String hiveEndpoint = this.hiveController.getHiveServerInternalEndpoint();
            this.certificateMaterializer.materializeCertificatesLocal(user.getUsername(), project.getName());
            String password = String.copyValueOf(this.certificateMaterializer.getUserMaterial(user.getUsername(), project.getName()).getPassword());
            String jdbcString = "jdbc:hive2://" + hiveEndpoint + "/" + databaseName + ";auth=noSasl;ssl=true;twoWay=true;sslTrustStore=" + this.certificateMaterializer.getUserTransientTruststorePath(project, user) + ";trustStorePassword=" + password + ";sslKeyStore=" + this.certificateMaterializer.getUserTransientKeystorePath(project, user) + ";keyStorePassword=" + password;
            return DriverManager.getConnection(jdbcString);
        }
        catch (ServiceDiscoveryException | CryptoPasswordNotFoundException | FileNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Could not find user certificates for authenticating with Hive: " + e);
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CERTIFICATES_NOT_FOUND, Level.SEVERE, "project: " + project.getName() + ", hive database: " + databaseName, e.getMessage(), e);
        }
        catch (IOException | SQLException e) {
            LOGGER.log(Level.SEVERE, "Error initiating Hive connection: " + e);
            this.certificateMaterializer.removeCertificatesLocal(user.getUsername(), project.getName());
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_INITIATE_HIVE_CONNECTION, Level.SEVERE, "project: " + project.getName() + ", hive database: " + databaseName, e.getMessage(), (Throwable)e);
        }
    }

    public RowValueQueryResult getDDLSchema(FeaturegroupDTO featuregroupDTO, Featurestore featurestore, Project project, Users user) throws SQLException, FeaturestoreException, HopsSecurityException {
        if (featuregroupDTO.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CANNOT_FETCH_HIVE_SCHEMA_FOR_ON_DEMAND_FEATUREGROUPS, Level.FINE, "featuregroupId: " + featuregroupDTO.getId());
        }
        String offlineSqlSchema = this.parseSqlSchemaResult(this.getSQLSchemaForFeaturegroup(featuregroupDTO, project, user, featurestore));
        ColumnValueQueryResult offlineSchemaColumn = new ColumnValueQueryResult("schema", offlineSqlSchema);
        ArrayList<ColumnValueQueryResult> columns = new ArrayList<ColumnValueQueryResult>();
        columns.add(offlineSchemaColumn);
        if (this.settings.isOnlineFeaturestore().booleanValue() && ((CachedFeaturegroupDTO)featuregroupDTO).getOnlineFeaturegroupDTO() != null) {
            String onlineSqlSchema = this.onlineFeaturegroupController.getOnlineFeaturegroupSchema(((CachedFeaturegroupDTO)featuregroupDTO).getOnlineFeaturegroupDTO());
            ColumnValueQueryResult onlineSchemaColumn = new ColumnValueQueryResult("onlineSchema", onlineSqlSchema);
            columns.add(onlineSchemaColumn);
        }
        return new RowValueQueryResult(columns);
    }

    private String parseSqlSchemaResult(List<RowValueQueryResult> rows) {
        return StringUtils.join((Iterable)rows.stream().map(row -> StringUtils.join((Iterable)row.getColumns().stream().map(column -> column.getValue()).collect(Collectors.toList()), (String)"")).collect(Collectors.toList()), (String)"\n");
    }

    private String getTblName(String featuregroupName, Integer version) {
        return featuregroupName + "_" + version.toString();
    }

    public FeaturegroupPreview getFeaturegroupPreview(FeaturegroupDTO featuregroupDTO, Featurestore featurestore, Project project, Users user) throws SQLException, FeaturestoreException, HopsSecurityException {
        FeaturegroupPreview featuregroupPreview = new FeaturegroupPreview();
        List<RowValueQueryResult> offlinePreview = this.getOfflineFeaturegroupPreview(featuregroupDTO, featurestore, project, user);
        featuregroupPreview.setOfflineFeaturegroupPreview(offlinePreview);
        if (this.settings.isOnlineFeaturestore().booleanValue() && ((CachedFeaturegroupDTO)featuregroupDTO).getOnlineFeaturegroupEnabled().booleanValue()) {
            List<RowValueQueryResult> onlinePreview = this.onlineFeaturegroupController.getOnlineFeaturegroupPreview(((CachedFeaturegroupDTO)featuregroupDTO).getOnlineFeaturegroupDTO(), user, featurestore);
            featuregroupPreview.setOnlineFeaturegroupPreview(onlinePreview);
        }
        return featuregroupPreview;
    }

    public List<RowValueQueryResult> getOfflineFeaturegroupPreview(FeaturegroupDTO featuregroupDTO, Featurestore featurestore, Project project, Users user) throws FeaturestoreException, HopsSecurityException, SQLException {
        String tbl = this.getTblName(featuregroupDTO.getName(), featuregroupDTO.getVersion());
        String query = "SELECT * FROM " + tbl + " LIMIT 20";
        String db = this.featurestoreController.getOfflineFeaturestoreDbName(featurestore.getProject());
        try {
            return this.executeReadHiveQuery(query, db, project, user);
        }
        catch (Exception e) {
            return this.executeReadHiveQuery(query, db, project, user);
        }
    }

    public CachedFeaturegroup createCachedFeaturegroup(Featurestore featurestore, CachedFeaturegroupDTO cachedFeaturegroupDTO, Users user) throws FeaturestoreException, HopsSecurityException, SQLException {
        String hiveFeatureStr = this.makeCreateTableColumnsStr(cachedFeaturegroupDTO.getFeatures(), cachedFeaturegroupDTO.getDescription(), false);
        String tableName = this.getTblName(cachedFeaturegroupDTO.getName(), cachedFeaturegroupDTO.getVersion());
        this.createHiveFeaturegroup(cachedFeaturegroupDTO, featurestore, user, hiveFeatureStr, tableName);
        OnlineFeaturegroup onlineFeaturegroup = null;
        if (this.settings.isOnlineFeaturestore().booleanValue() && cachedFeaturegroupDTO.getOnlineFeaturegroupEnabled().booleanValue()) {
            String mySQLFeatureStr = this.makeCreateTableColumnsStr(cachedFeaturegroupDTO.getFeatures(), cachedFeaturegroupDTO.getDescription(), true);
            onlineFeaturegroup = this.onlineFeaturegroupController.createMySQLTable(featurestore, user, mySQLFeatureStr, tableName);
        }
        Long hiveTblId = this.cachedFeaturegroupFacade.getHiveTableId(tableName, featurestore.getHiveDbId());
        return this.persistCachedFeaturegroupMetadata(hiveTblId, onlineFeaturegroup);
    }

    private void createHiveFeaturegroup(CachedFeaturegroupDTO cachedFeaturegroupDTO, Featurestore featurestore, Users user, String featureStr, String tableName) throws FeaturestoreException, SQLException, HopsSecurityException {
        String db = this.featurestoreController.getOfflineFeaturestoreDbName(featurestore.getProject());
        String query = "CREATE TABLE " + db + ".`" + tableName + "` " + featureStr + "STORED AS " + this.settings.getFeaturestoreDbDefaultStorageFormat();
        try {
            this.executeUpdateHiveQuery(query, db, featurestore.getProject(), user);
        }
        catch (Exception e) {
            this.executeUpdateHiveQuery(query, db, featurestore.getProject(), user);
        }
    }

    public CachedFeaturegroupDTO convertCachedFeaturegroupToDTO(Featuregroup featuregroup) {
        CachedFeaturegroupDTO cachedFeaturegroupDTO = new CachedFeaturegroupDTO(featuregroup);
        List<FeatureDTO> featureDTOs = this.cachedFeaturegroupFacade.getHiveFeatures(featuregroup.getCachedFeaturegroup().getHiveTableId());
        List<String> primaryKeys = this.cachedFeaturegroupFacade.getHiveTablePrimaryKey(featuregroup.getCachedFeaturegroup().getHiveTableId());
        if (!featureDTOs.isEmpty() && !primaryKeys.isEmpty()) {
            featureDTOs.stream().filter(f -> primaryKeys.contains(f.getName())).forEach(f -> f.setPrimary(true));
        }
        if (this.settings.isOnlineFeaturestore().booleanValue() && featuregroup.getCachedFeaturegroup().getOnlineFeaturegroup() != null) {
            List<FeatureDTO> onlineFeatureDTOs = this.onlineFeaturegroupController.getOnlineFeaturegroupFeatures(featuregroup.getCachedFeaturegroup().getOnlineFeaturegroup());
            for (FeatureDTO featureDTO : featureDTOs) {
                for (FeatureDTO onlineFeatureDTO : onlineFeatureDTOs) {
                    if (!featureDTO.getName().equalsIgnoreCase(onlineFeatureDTO.getName())) continue;
                    featureDTO.setOnlineType(onlineFeatureDTO.getType());
                }
            }
        }
        cachedFeaturegroupDTO.setFeatures(featureDTOs);
        cachedFeaturegroupDTO.setName(featuregroup.getName());
        List<String> hdfsStorePaths = this.cachedFeaturegroupFacade.getHiveTableHdfsPaths(featuregroup.getCachedFeaturegroup().getHiveTableId());
        cachedFeaturegroupDTO.setHdfsStorePaths(hdfsStorePaths);
        cachedFeaturegroupDTO.setDescription(this.cachedFeaturegroupFacade.getHiveTableComment(featuregroup.getCachedFeaturegroup().getHiveTableId()));
        Long inodeId = this.cachedFeaturegroupFacade.getHiveTableInodeId(featuregroup.getCachedFeaturegroup().getHiveTableId());
        cachedFeaturegroupDTO.setInodeId(inodeId);
        HiveTableType hiveTableType = this.cachedFeaturegroupFacade.getHiveTableType(featuregroup.getCachedFeaturegroup().getHiveTableId());
        cachedFeaturegroupDTO.setHiveTableType(hiveTableType);
        String hiveInputFormat = this.cachedFeaturegroupFacade.getHiveInputFormat(featuregroup.getCachedFeaturegroup().getHiveTableId());
        cachedFeaturegroupDTO.setInputFormat(hiveInputFormat);
        cachedFeaturegroupDTO.setLocation(hdfsStorePaths.get(0));
        if (this.settings.isOnlineFeaturestore().booleanValue() && featuregroup.getCachedFeaturegroup().getOnlineFeaturegroup() != null) {
            cachedFeaturegroupDTO.setOnlineFeaturegroupEnabled(true);
            cachedFeaturegroupDTO.setOnlineFeaturegroupDTO(this.onlineFeaturegroupController.convertOnlineFeaturegroupToDTO(featuregroup.getCachedFeaturegroup().getOnlineFeaturegroup()));
        }
        return cachedFeaturegroupDTO;
    }

    private List<RowValueQueryResult> getSQLSchemaForFeaturegroup(FeaturegroupDTO featuregroupDTO, Project project, Users user, Featurestore featurestore) throws SQLException, FeaturestoreException, HopsSecurityException {
        String tbl = this.getTblName(featuregroupDTO.getName(), featuregroupDTO.getVersion());
        String query = "SHOW CREATE TABLE " + tbl;
        String db = this.featurestoreController.getOfflineFeaturestoreDbName(featurestore.getProject());
        return this.executeReadHiveQuery(query, db, project, user);
    }

    public void dropHiveFeaturegroup(FeaturegroupDTO featuregroupDTO, Featurestore featurestore, Users user) throws SQLException, FeaturestoreException, HopsSecurityException {
        String db = this.featurestoreController.getOfflineFeaturestoreDbName(featurestore.getProject());
        String tableName = this.getTblName(featuregroupDTO.getName(), featuregroupDTO.getVersion());
        String query = "DROP TABLE IF EXISTS `" + tableName + "`";
        try {
            this.executeUpdateHiveQuery(query, db, featurestore.getProject(), user);
        }
        catch (Exception e) {
            this.executeUpdateHiveQuery(query, db, featurestore.getProject(), user);
        }
    }

    public void dropMySQLFeaturegroup(CachedFeaturegroup cachedFeaturegroup, Featurestore featurestore, Users user) throws SQLException, FeaturestoreException {
        if (this.settings.isOnlineFeaturestore().booleanValue() && cachedFeaturegroup.getOnlineFeaturegroup() != null) {
            this.onlineFeaturegroupController.dropMySQLTable(cachedFeaturegroup.getOnlineFeaturegroup(), featurestore, user);
        }
    }

    private void executeUpdateHiveQuery(String query, String databaseName, Project project, Users user) throws SQLException, FeaturestoreException, HopsSecurityException {
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.initConnection(databaseName, project, user);
            stmt = conn.createStatement();
            stmt.executeUpdate(query);
        }
        catch (SQLException e) {
            if (e.getMessage().toLowerCase().contains("permission denied")) {
                throw new HopsSecurityException(RESTCodes.SecurityErrorCode.HDFS_ACCESS_CONTROL, Level.FINE, "project: " + project.getName() + ", hive database: " + databaseName + " hive query: " + query, e.getMessage(), (Throwable)e);
            }
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.HIVE_UPDATE_STATEMENT_ERROR, Level.SEVERE, "project: " + project.getName() + ", hive database: " + databaseName + " hive query: " + query, e.getMessage(), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            this.closeConnection(conn, user, project);
        }
    }

    public List<RowValueQueryResult> parseResultset(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnsNumber = rsmd.getColumnCount();
        ArrayList<RowValueQueryResult> rows = new ArrayList<RowValueQueryResult>();
        while (rs.next()) {
            ArrayList<ColumnValueQueryResult> columnValues = new ArrayList<ColumnValueQueryResult>();
            for (int i = 1; i <= columnsNumber; ++i) {
                String columnName = rsmd.getColumnName(i);
                Object columnValue = rs.getObject(i);
                String columnStrValue = columnValue == null ? null : columnValue.toString();
                ColumnValueQueryResult featuredataDTO = new ColumnValueQueryResult(columnName, columnStrValue);
                columnValues.add(featuredataDTO);
            }
            rows.add(new RowValueQueryResult(columnValues));
        }
        return rows;
    }

    private List<RowValueQueryResult> executeReadHiveQuery(String query, String databaseName, Project project, Users user) throws SQLException, FeaturestoreException, HopsSecurityException {
        Connection conn = null;
        Statement stmt = null;
        List<RowValueQueryResult> resultList = null;
        try {
            conn = this.initConnection(databaseName, project, user);
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            resultList = this.parseResultset(rs);
        }
        catch (SQLException e) {
            if (e.getMessage().toLowerCase().contains("permission denied")) {
                throw new HopsSecurityException(RESTCodes.SecurityErrorCode.HDFS_ACCESS_CONTROL, Level.FINE, "project: " + project.getName() + ", hive database: " + databaseName + " hive query: " + query, e.getMessage(), (Throwable)e);
            }
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.HIVE_READ_QUERY_ERROR, Level.SEVERE, "project: " + project.getName() + ", hive database: " + databaseName + " hive query: " + query, e.getMessage(), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            this.closeConnection(conn, user, project);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Connection conn, Users user, Project project) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error closing Hive JDBC connection: " + e);
        }
        finally {
            this.certificateMaterializer.removeCertificatesLocal(user.getUsername(), project.getName());
        }
    }

    public String makeCreateTableColumnsStr(List<FeatureDTO> features, String featuregroupDoc, Boolean mysqlTable) throws FeaturestoreException {
        StringBuilder schemaStringBuilder = new StringBuilder();
        StringBuilder partitionStringBuilder = new StringBuilder();
        if (features.isEmpty()) {
            schemaStringBuilder.append("(`temp` int COMMENT 'placeholder') COMMENT '");
            schemaStringBuilder.append(featuregroupDoc);
            schemaStringBuilder.append("' ");
            return schemaStringBuilder.toString();
        }
        List primaryKeys = features.stream().filter(f -> f.getPrimary()).collect(Collectors.toList());
        if (primaryKeys.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.NO_PRIMARY_KEY_SPECIFIED, Level.SEVERE, "Out of the " + features.size() + " features provided, none is marked as primary");
        }
        for (FeatureDTO primaryKey : primaryKeys) {
            if (!primaryKey.getPartition().booleanValue()) continue;
            LOGGER.fine("The primary key column: " + primaryKey.getName() + " was specified as a partition column, which is not allowed. Primary key columns can not be partitioned; Ignoring this partition request.");
        }
        schemaStringBuilder.append("(");
        int numPartitions = features.stream().filter(f -> f.getPartition()).collect(Collectors.toList()).size();
        partitionStringBuilder.append("PARTITIONED BY (");
        Boolean firstPartition = true;
        for (int i = 0; i < features.size(); ++i) {
            FeatureDTO feature = features.get(i);
            if (!feature.getPartition().booleanValue() || feature.getPrimary().booleanValue()) {
                schemaStringBuilder.append("`");
                schemaStringBuilder.append(feature.getName());
                schemaStringBuilder.append("` ");
                if (!mysqlTable.booleanValue()) {
                    schemaStringBuilder.append(feature.getType());
                } else {
                    schemaStringBuilder.append(feature.getOnlineType());
                }
                if (!Strings.isNullOrEmpty((String)feature.getDescription())) {
                    schemaStringBuilder.append(" COMMENT '");
                    schemaStringBuilder.append(feature.getDescription());
                    schemaStringBuilder.append("'");
                }
                schemaStringBuilder.append(", ");
            } else {
                if (!firstPartition.booleanValue()) {
                    partitionStringBuilder.append(",");
                } else {
                    firstPartition = false;
                }
                partitionStringBuilder.append("`");
                partitionStringBuilder.append(feature.getName());
                partitionStringBuilder.append("` ");
                if (!mysqlTable.booleanValue()) {
                    partitionStringBuilder.append(feature.getType());
                } else {
                    partitionStringBuilder.append(feature.getOnlineType());
                }
                if (!Strings.isNullOrEmpty((String)feature.getDescription())) {
                    partitionStringBuilder.append(" COMMENT '");
                    partitionStringBuilder.append(feature.getDescription());
                    partitionStringBuilder.append("'");
                }
            }
            if (i != features.size() - 1) continue;
            Boolean firstPrimary = true;
            schemaStringBuilder.append("PRIMARY KEY (");
            for (int j = 0; j < primaryKeys.size(); ++j) {
                if (!firstPrimary.booleanValue()) {
                    schemaStringBuilder.append(",");
                } else {
                    firstPrimary = false;
                }
                schemaStringBuilder.append("`");
                schemaStringBuilder.append(((FeatureDTO)primaryKeys.get(j)).getName());
                schemaStringBuilder.append("` ");
            }
            if (!mysqlTable.booleanValue()) {
                schemaStringBuilder.append(") DISABLE NOVALIDATE) COMMENT '");
            } else {
                schemaStringBuilder.append(")) COMMENT '");
            }
            schemaStringBuilder.append(featuregroupDoc);
            schemaStringBuilder.append("' ");
            if (numPartitions <= 0 || mysqlTable.booleanValue()) continue;
            partitionStringBuilder.append(")");
            schemaStringBuilder.append(" ");
            schemaStringBuilder.append(partitionStringBuilder.toString());
        }
        return schemaStringBuilder.toString();
    }

    public CachedFeaturegroup syncHiveTableWithFeaturestore(Featurestore featurestore, CachedFeaturegroupDTO cachedFeaturegroupDTO) throws FeaturestoreException {
        String tableName = this.getTblName(cachedFeaturegroupDTO.getName(), cachedFeaturegroupDTO.getVersion());
        Long hiveTblId = this.cachedFeaturegroupFacade.getHiveTableId(tableName, featurestore.getHiveDbId());
        if (hiveTblId == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.SYNC_TABLE_NOT_FOUND, Level.FINE, ", tried to sync hive table with name: " + tableName + " with the feature store, but the table was not found in the Hive metastore");
        }
        return this.persistCachedFeaturegroupMetadata(hiveTblId, null);
    }

    private CachedFeaturegroup persistCachedFeaturegroupMetadata(Long hiveTblId, OnlineFeaturegroup onlineFeaturegroup) {
        CachedFeaturegroup cachedFeaturegroup = new CachedFeaturegroup();
        cachedFeaturegroup.setHiveTableId(hiveTblId);
        cachedFeaturegroup.setOnlineFeaturegroup(onlineFeaturegroup);
        this.cachedFeaturegroupFacade.persist(cachedFeaturegroup);
        return cachedFeaturegroup;
    }

    public FeaturegroupDTO enableFeaturegroupOnline(Featurestore featurestore, CachedFeaturegroupDTO cachedFeaturegroupDTO, Featuregroup featuregroup, Users user) throws FeaturestoreException, SQLException {
        if (!this.settings.isOnlineFeaturestore().booleanValue()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_NOT_ENABLED, Level.FINE, "Online Featurestore is not enabled for this Hopsworks cluster.");
        }
        if (!this.onlineFeaturestoreController.checkIfDatabaseExists(this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featurestore.getProject())).booleanValue()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_NOT_ENABLED, Level.FINE, "Online Featurestore is not enabled for this project. To enable online feature store, talk to an administrator.");
        }
        OnlineFeaturegroup onlineFeaturegroup = null;
        String tableName = this.getTblName(cachedFeaturegroupDTO.getName(), cachedFeaturegroupDTO.getVersion());
        if (this.settings.isOnlineFeaturestore().booleanValue() && featuregroup.getCachedFeaturegroup().getOnlineFeaturegroup() == null) {
            String mySQLFeatureStr = this.makeCreateTableColumnsStr(cachedFeaturegroupDTO.getFeatures(), cachedFeaturegroupDTO.getDescription(), true);
            onlineFeaturegroup = this.onlineFeaturegroupController.createMySQLTable(featurestore, user, mySQLFeatureStr, tableName);
        }
        CachedFeaturegroup cachedFeaturegroup = featuregroup.getCachedFeaturegroup();
        cachedFeaturegroup.setOnlineFeaturegroup(onlineFeaturegroup);
        this.cachedFeaturegroupFacade.updateMetadata(cachedFeaturegroup);
        return this.convertCachedFeaturegroupToDTO(featuregroup);
    }

    public FeaturegroupDTO disableFeaturegroupOnline(Featurestore featurestore, Featuregroup featuregroup, Users user) throws FeaturestoreException, SQLException {
        if (!this.settings.isOnlineFeaturestore().booleanValue()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_NOT_ENABLED, Level.FINE, "Online Featurestore is not enabled for this Hopsworks cluster.");
        }
        if (!this.onlineFeaturestoreController.checkIfDatabaseExists(this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featurestore.getProject())).booleanValue()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_NOT_ENABLED, Level.FINE, "Online Featurestore is not enabled for this project. To enable online feature store, talk to an administrator.");
        }
        CachedFeaturegroup cachedFeaturegroup = featuregroup.getCachedFeaturegroup();
        if (this.settings.isOnlineFeaturestore().booleanValue() && featuregroup.getCachedFeaturegroup().getOnlineFeaturegroup() != null) {
            this.dropMySQLFeaturegroup(cachedFeaturegroup, featurestore, user);
        }
        return this.convertCachedFeaturegroupToDTO(featuregroup);
    }
}

