/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.statistics.columns;

import io.hops.hopsworks.common.featurestore.statistics.columns.StatisticColumnFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.columns.StatisticColumn;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class StatisticColumnController {
    @EJB
    private StatisticColumnFacade statisticColumnFacade;

    public void persistStatisticColumns(Featuregroup featuregroup, List<String> statisticColumns) {
        if (statisticColumns != null) {
            statisticColumns.forEach(statisticColumn -> {
                if (!this.isColumnExists((List)featuregroup.getStatisticColumns(), (String)statisticColumn)) {
                    StatisticColumn sc = new StatisticColumn();
                    sc.setFeaturegroup(featuregroup);
                    sc.setName(statisticColumn);
                    this.statisticColumnFacade.persist(sc);
                }
            });
            List columnEntities = (List)featuregroup.getStatisticColumns();
            columnEntities.forEach(scEntity -> {
                if (this.isEntityToBeDropped((StatisticColumn)scEntity, statisticColumns)) {
                    this.statisticColumnFacade.remove(scEntity);
                }
            });
        }
    }

    public boolean isColumnExists(List<StatisticColumn> statisticColumns, String column) {
        return statisticColumns.stream().anyMatch(statisticColumn -> statisticColumn.getName().equals(column));
    }

    public boolean isEntityToBeDropped(StatisticColumn entity, List<String> statisticColumns) {
        return statisticColumns.stream().noneMatch(statisticColumn -> statisticColumn.equals(entity.getName()));
    }
}

