/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import io.hops.hopsworks.restutils.JsonResponse;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ClientWrapper<T> {
    private Client client;
    private final Class<T> respContentClass;
    private String target;
    private String path;
    private Entity payload;
    private String mediaType = "application/json";

    private ClientWrapper(Client client, Class<T> respContentClass) {
        this.client = client;
        this.respContentClass = respContentClass;
        this.payload = Entity.entity((Object)"", (String)this.mediaType);
    }

    public ClientWrapper setTarget(String target) {
        this.target = target;
        return this;
    }

    public ClientWrapper setPath(String path) {
        this.path = path;
        return this;
    }

    public ClientWrapper setMediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public ClientWrapper setPayload(Object jsonObject) {
        this.payload = Entity.entity((Object)jsonObject, (String)this.mediaType);
        return this;
    }

    public T doGet() {
        this.performSanityCheck();
        try {
            WebTarget webTarget = this.client.target(this.target).path(this.path);
            Response response = webTarget.request(new String[]{this.mediaType}).get();
            T t = this.getResponse(response);
            return t;
        }
        catch (ProcessingException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        finally {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
    }

    public List<T> doGetGenericType() {
        this.performSanityCheck();
        try {
            Response response;
            block8: {
                WebTarget webTarget = this.client.target(this.target).path(this.path);
                response = webTarget.request(new String[]{this.mediaType}).get();
                ParameterizedType parameterizedGenericType = new ParameterizedType(){

                    @Override
                    public Type[] getActualTypeArguments() {
                        return new Type[]{ClientWrapper.this.respContentClass};
                    }

                    @Override
                    public Type getRawType() {
                        return List.class;
                    }

                    @Override
                    public Type getOwnerType() {
                        return List.class;
                    }
                };
                GenericType type = new GenericType<List<T>>(parameterizedGenericType){};
                Response.Status.Family status = response.getStatusInfo().getFamily();
                try {
                    List content;
                    if (status != Response.Status.Family.INFORMATIONAL && status != Response.Status.Family.SUCCESSFUL) break block8;
                    List list = content = (List)response.readEntity(type);
                    return list;
                }
                catch (ProcessingException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            JsonResponse jsonRes = (JsonResponse)response.readEntity(JsonResponse.class);
            throw new IllegalStateException(jsonRes.getErrorMsg());
        }
        finally {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
    }

    public T doPost() {
        this.performSanityCheck();
        try {
            WebTarget webTarget = this.client.target(this.target).path(this.path);
            Response response = webTarget.request(new String[]{this.mediaType}).post(this.payload);
            T t = this.getResponse(response);
            return t;
        }
        catch (ProcessingException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        finally {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
    }

    public T doPut() {
        this.performSanityCheck();
        try {
            WebTarget webTarget = this.client.target(this.target).path(this.path);
            Response response = webTarget.request(new String[]{this.mediaType}).put(this.payload);
            T t = this.getResponse(response);
            return t;
        }
        catch (ProcessingException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        finally {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
    }

    public T doDelete() {
        this.performSanityCheck();
        try {
            WebTarget webTarget = this.client.target(this.target).path(this.path);
            Response response = webTarget.request(new String[]{this.mediaType}).delete();
            T t = this.getResponse(response);
            return t;
        }
        catch (ProcessingException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        finally {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
    }

    private T getResponse(Response response) {
        Response.Status.Family statusFamily = response.getStatusInfo().getFamily();
        if (response.getMediaType().getSubtype().equals(MediaType.APPLICATION_JSON_TYPE.getSubtype())) {
            try {
                if (statusFamily == Response.Status.Family.INFORMATIONAL || statusFamily == Response.Status.Family.SUCCESSFUL) {
                    Object content = response.readEntity(this.respContentClass);
                    return (T)content;
                }
                JsonResponse jsonRes = (JsonResponse)response.readEntity(JsonResponse.class);
                throw new IllegalStateException(jsonRes.getErrorMsg());
            }
            catch (ProcessingException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        throw new IllegalStateException("Cannot Connect To Server.");
    }

    private void performSanityCheck() {
        if (this.client == null) {
            throw new IllegalStateException("Client not created.");
        }
        if (this.target == null || this.target.isEmpty()) {
            throw new IllegalStateException("Target not set.");
        }
        if (this.path == null || this.path.isEmpty()) {
            throw new IllegalStateException("Path not set.");
        }
    }

    public String getFullPath() {
        return this.target + "/" + this.path;
    }

    public static <T> ClientWrapper<T> httpsInstance(KeyStore keystore, KeyStore truststore, String password, HostnameVerifier hostnameVerifier, Class<T> resultClass) {
        Client client = ClientBuilder.newBuilder().trustStore(truststore).keyStore(keystore, password.toCharArray()).hostnameVerifier(hostnameVerifier).build();
        return new ClientWrapper<T>(client, resultClass);
    }

    public static <T> ClientWrapper<T> httpsInstance(Class<T> resultClass) {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, ClientWrapper.trustAllCerts(), new SecureRandom());
            Client client = ClientBuilder.newBuilder().sslContext(sc).hostnameVerifier(ClientWrapper.acceptAnyHost()).build();
            return new ClientWrapper<T>(client, resultClass);
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static <T> ClientWrapper httpInstance(Class<T> resultClass) {
        Client client = ClientBuilder.newClient();
        return new ClientWrapper<T>(client, resultClass);
    }

    private static TrustManager[] trustAllCerts() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }

    private static HostnameVerifier acceptAnyHost() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession ssls) {
                return true;
            }
        };
    }
}

