/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.trainingdatasets;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.jobs.description.JobFacade;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.featurestore.FeaturestoreConstants;
import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.feature.FeaturestoreFeatureController;
import io.hops.hopsworks.common.featurestore.jobs.FeaturestoreJobDTO;
import io.hops.hopsworks.common.featurestore.jobs.FeaturestoreJobFacade;
import io.hops.hopsworks.common.featurestore.statistics.FeaturestoreStatisticController;
import io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs.FeaturestoreHopsfsConnectorController;
import io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs.FeaturestoreHopsfsConnectorFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.s3.FeaturestoreS3ConnectorFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.external.ExternalTrainingDatasetController;
import io.hops.hopsworks.common.featurestore.trainingdatasets.external.ExternalTrainingDatasetFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.hopsfs.HopsfsTrainingDatasetController;
import io.hops.hopsworks.common.featurestore.trainingdatasets.hopsfs.HopsfsTrainingDatasetFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.split.TrainingDatasetSplitDTO;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreInputValidation;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreUtils;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.provenance.core.HopsFSProvenanceController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.hopsfs.FeaturestoreHopsfsConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.s3.FeaturestoreS3Connector;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetType;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.external.ExternalTrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.hopsfs.HopsfsTrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.split.TrainingDatasetSplit;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang3.StringUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class TrainingDatasetController {
    @EJB
    private TrainingDatasetFacade trainingDatasetFacade;
    @EJB
    private FeaturestoreFacade featurestoreFacade;
    @EJB
    private FeaturestoreStatisticController featurestoreStatisticController;
    @EJB
    private FeaturestoreFeatureController featurestoreFeatureController;
    @EJB
    private JobFacade jobFacade;
    @EJB
    private DatasetController datasetController;
    @EJB
    private HopsfsTrainingDatasetController hopsfsTrainingDatasetController;
    @EJB
    private HopsfsTrainingDatasetFacade hopsfsTrainingDatasetFacade;
    @EJB
    private ExternalTrainingDatasetController externalTrainingDatasetController;
    @EJB
    private ExternalTrainingDatasetFacade externalTrainingDatasetFacade;
    @EJB
    private FeaturestoreJobFacade featurestoreJobFacade;
    @EJB
    private FeaturestoreInputValidation featurestoreInputValidation;
    @EJB
    private FeaturestoreHopsfsConnectorFacade hopsfsConnectorFacade;
    @EJB
    private FeaturestoreS3ConnectorFacade S3ConnectorFacade;
    @EJB
    private InodeController inodeController;
    @EJB
    private HopsFSProvenanceController fsProvenanceController;
    @EJB
    private FeaturestoreHopsfsConnectorController hopsfsConnectorController;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private HdfsUsersController hdfsUsersBean;
    @EJB
    private FeaturestoreUtils featurestoreUtils;

    public List<TrainingDatasetDTO> getTrainingDatasetsForFeaturestore(Featurestore featurestore) {
        List<TrainingDataset> trainingDatasets = this.trainingDatasetFacade.findByFeaturestore(featurestore);
        return trainingDatasets.stream().map(this::convertTrainingDatasetToDTO).collect(Collectors.toList());
    }

    private TrainingDatasetDTO convertTrainingDatasetToDTO(TrainingDataset trainingDataset) {
        TrainingDatasetDTO trainingDatasetDTO = new TrainingDatasetDTO(trainingDataset);
        String featurestoreName = this.featurestoreFacade.getHiveDbName(trainingDataset.getFeaturestore().getHiveDbId());
        trainingDatasetDTO.setFeaturestoreName(featurestoreName);
        switch (trainingDataset.getTrainingDatasetType()) {
            case HOPSFS_TRAINING_DATASET: {
                return this.hopsfsTrainingDatasetController.convertHopsfsTrainingDatasetToDTO(trainingDatasetDTO, trainingDataset);
            }
            case EXTERNAL_TRAINING_DATASET: {
                return this.externalTrainingDatasetController.convertExternalTrainingDatasetToDTO(trainingDatasetDTO, trainingDataset);
            }
        }
        throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_TYPE.getMessage() + ", Recognized training dataset types are: " + TrainingDatasetType.HOPSFS_TRAINING_DATASET + ", and: " + TrainingDatasetType.EXTERNAL_TRAINING_DATASET + ". The provided training dataset type was not recognized: " + trainingDataset.getTrainingDatasetType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrainingDatasetDTO createTrainingDataset(Users user, Project project, Featurestore featurestore, TrainingDatasetDTO trainingDatasetDTO) throws FeaturestoreException, ProvenanceException, IOException {
        if (this.trainingDatasetFacade.findByNameVersionAndFeaturestore(trainingDatasetDTO.getName(), trainingDatasetDTO.getVersion(), featurestore).isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_ALREADY_EXISTS, Level.FINE, "Training Dataset: " + trainingDatasetDTO.getName() + ", version: " + trainingDatasetDTO.getVersion());
        }
        Inode inode = null;
        FeaturestoreHopsfsConnector hopsfsConnector = null;
        FeaturestoreS3Connector s3Connector = null;
        if (trainingDatasetDTO.getTrainingDatasetType() == TrainingDatasetType.HOPSFS_TRAINING_DATASET) {
            hopsfsConnector = trainingDatasetDTO.getStorageConnectorId() == null ? this.hopsfsConnectorController.getDefaultStorageConnector(featurestore) : this.hopsfsConnectorFacade.findByIdAndFeaturestore(trainingDatasetDTO.getStorageConnectorId(), featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.HOPSFS_CONNECTOR_NOT_FOUND, Level.FINE, "HOPSFS Connector: " + trainingDatasetDTO.getStorageConnectorId()));
            Dataset trainingDatasetsFolder = hopsfsConnector.getHopsfsDataset();
            String trainingDatasetPath = this.getTrainingDatasetPath(this.inodeController.getPath(trainingDatasetsFolder.getInode()), trainingDatasetDTO.getName(), trainingDatasetDTO.getVersion());
            DistributedFileSystemOps udfso = null;
            String username = this.hdfsUsersBean.getHdfsUserName(project, user);
            try {
                udfso = this.dfs.getDfsOps(username);
                udfso.mkdir(trainingDatasetPath);
            }
            finally {
                if (udfso != null) {
                    this.dfs.closeDfsClient(udfso);
                }
            }
            inode = this.inodeController.getInodeAtPath(trainingDatasetPath);
            TrainingDatasetDTO completeTrainingDatasetDTO = this.createTrainingDatasetMetadata(user, featurestore, trainingDatasetDTO, hopsfsConnector, inode, s3Connector);
            this.fsProvenanceController.trainingDatasetAttachXAttr(user, project, trainingDatasetPath, completeTrainingDatasetDTO);
            return completeTrainingDatasetDTO;
        }
        s3Connector = this.S3ConnectorFacade.findByIdAndFeaturestore(trainingDatasetDTO.getStorageConnectorId(), featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.S3_CONNECTOR_NOT_FOUND, Level.FINE, "S3 connector: " + trainingDatasetDTO.getStorageConnectorId()));
        return this.createTrainingDatasetMetadata(user, featurestore, trainingDatasetDTO, hopsfsConnector, inode, s3Connector);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    private TrainingDatasetDTO createTrainingDatasetMetadata(Users user, Featurestore featurestore, TrainingDatasetDTO trainingDatasetDTO, FeaturestoreHopsfsConnector hopsfsConnector, Inode inode, FeaturestoreS3Connector S3Connector) throws FeaturestoreException {
        this.featurestoreInputValidation.verifyUserInput(trainingDatasetDTO);
        this.verifyTrainingDatasetInput(trainingDatasetDTO, featurestore);
        this.verifyStatisticsInput(trainingDatasetDTO);
        HopsfsTrainingDataset hopsfsTrainingDataset = null;
        ExternalTrainingDataset externalTrainingDataset = null;
        switch (trainingDatasetDTO.getTrainingDatasetType()) {
            case HOPSFS_TRAINING_DATASET: {
                hopsfsTrainingDataset = this.hopsfsTrainingDatasetFacade.createHopsfsTrainingDataset(hopsfsConnector, inode);
                break;
            }
            case EXTERNAL_TRAINING_DATASET: {
                externalTrainingDataset = this.externalTrainingDatasetFacade.createExternalTrainingDataset(S3Connector, trainingDatasetDTO.getLocation());
                break;
            }
            default: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_TYPE, Level.FINE, ", Recognized training dataset types are: " + TrainingDatasetType.HOPSFS_TRAINING_DATASET + ", and: " + TrainingDatasetType.EXTERNAL_TRAINING_DATASET + ". The provided training dataset type was not recognized: " + trainingDatasetDTO.getTrainingDatasetType());
            }
        }
        TrainingDataset trainingDataset = new TrainingDataset();
        trainingDataset.setName(trainingDatasetDTO.getName());
        trainingDataset.setHopsfsTrainingDataset(hopsfsTrainingDataset);
        trainingDataset.setExternalTrainingDataset(externalTrainingDataset);
        trainingDataset.setDataFormat(trainingDatasetDTO.getDataFormat());
        trainingDataset.setDescription(trainingDatasetDTO.getDescription());
        trainingDataset.setFeaturestore(featurestore);
        trainingDataset.setCreated(new Date());
        trainingDataset.setCreator(user);
        trainingDataset.setVersion(trainingDatasetDTO.getVersion());
        trainingDataset.setTrainingDatasetType(trainingDatasetDTO.getTrainingDatasetType());
        trainingDataset.setSeed(trainingDatasetDTO.getSeed());
        trainingDataset.setSplits((Collection)trainingDatasetDTO.getSplits().stream().map(tdDTO -> new TrainingDatasetSplit(trainingDataset, tdDTO.getName(), tdDTO.getPercentage())).collect(Collectors.toList()));
        this.trainingDatasetFacade.persist(trainingDataset);
        this.featurestoreStatisticController.updateFeaturestoreStatistics(null, trainingDataset, trainingDatasetDTO.getFeatureCorrelationMatrix(), trainingDatasetDTO.getDescriptiveStatistics(), trainingDatasetDTO.getFeaturesHistogram(), trainingDatasetDTO.getClusterAnalysis());
        this.featurestoreFeatureController.updateTrainingDatasetFeatures(trainingDataset, trainingDatasetDTO.getFeatures());
        List<Jobs> jobs = this.getJobs(trainingDatasetDTO.getJobs(), featurestore.getProject());
        this.featurestoreJobFacade.insertJobs(trainingDataset, jobs);
        return this.getTrainingDatasetWithNameVersionAndFeaturestore(featurestore, trainingDataset.getName(), trainingDataset.getVersion());
    }

    private List<Jobs> getJobs(List<FeaturestoreJobDTO> jobDTOs, Project project) {
        if (jobDTOs != null) {
            return jobDTOs.stream().filter(jobDTO -> jobDTO != null && !Strings.isNullOrEmpty((String)jobDTO.getJobName())).map(FeaturestoreJobDTO::getJobName).distinct().map(jobName -> this.jobFacade.findByProjectAndName(project, (String)jobName)).collect(Collectors.toList());
        }
        return new ArrayList<Jobs>();
    }

    public TrainingDatasetDTO getTrainingDatasetWithIdAndFeaturestore(Featurestore featurestore, Integer id) throws FeaturestoreException {
        TrainingDataset trainingDataset = this.trainingDatasetFacade.findByIdAndFeaturestore(id, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "trainingDatasetId: " + id));
        return this.convertTrainingDatasetToDTO(trainingDataset);
    }

    public List<TrainingDatasetDTO> getTrainingDatasetWithNameAndFeaturestore(Featurestore featurestore, String name) throws FeaturestoreException {
        List<TrainingDataset> trainingDatasetList = this.trainingDatasetFacade.findByNameAndFeaturestore(name, featurestore);
        if (trainingDatasetList == null || trainingDatasetList.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "training dataset name : " + name);
        }
        return trainingDatasetList.stream().map(this::convertTrainingDatasetToDTO).collect(Collectors.toList());
    }

    public TrainingDatasetDTO getTrainingDatasetWithNameVersionAndFeaturestore(Featurestore featurestore, String name, Integer version) throws FeaturestoreException {
        Optional<TrainingDataset> trainingDataset = this.trainingDatasetFacade.findByNameVersionAndFeaturestore(name, version, featurestore);
        return this.convertTrainingDatasetToDTO(trainingDataset.orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "training dataset name : " + name)));
    }

    public Inode getInodeWithTrainingDatasetIdAndFeaturestore(Featurestore featurestore, Integer id) throws FeaturestoreException {
        TrainingDataset trainingDataset = this.trainingDatasetFacade.findByIdAndFeaturestore(id, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "trainingDatasetId: " + id));
        if (trainingDataset.getTrainingDatasetType() != TrainingDatasetType.HOPSFS_TRAINING_DATASET) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CAN_ONLY_GET_INODE_FOR_HOPSFS_TRAINING_DATASETS, Level.FINE, "Training Dataset Type: " + trainingDataset.getTrainingDatasetType());
        }
        return trainingDataset.getHopsfsTrainingDataset().getInode();
    }

    public TrainingDatasetDTO getTrainingDatasetByFeaturestoreAndName(Project project, Featurestore featurestore, String trainingDatasetName, int version) throws FeaturestoreException {
        List<TrainingDataset> trainingDatasets = this.trainingDatasetFacade.findByFeaturestore(featurestore);
        List trainingDatasetDTOS = trainingDatasets.stream().map(td -> this.convertTrainingDatasetToDTO((TrainingDataset)td)).collect(Collectors.toList());
        List trainingDatasetsDTOWithName = trainingDatasetDTOS.stream().filter(td -> td.getName().equals(trainingDatasetName) && td.getVersion() == version).collect(Collectors.toList());
        if (trainingDatasetsDTOWithName.size() != 1) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "featurestoreId: " + featurestore.getId() + " , project: " + project.getName() + " trainingDatasetName: " + trainingDatasetName);
        }
        return (TrainingDatasetDTO)trainingDatasetsDTOWithName.get(0);
    }

    public String delete(Users user, Project project, Featurestore featurestore, Integer trainingDatasetId) throws FeaturestoreException {
        TrainingDataset trainingDataset = this.trainingDatasetFacade.findByIdAndFeaturestore(trainingDatasetId, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "training dataset id:" + trainingDatasetId));
        this.featurestoreUtils.verifyUserRole(trainingDataset, featurestore, user, project);
        this.trainingDatasetFacade.removeTrainingDataset(trainingDataset);
        if (trainingDataset.getTrainingDatasetType() == TrainingDatasetType.HOPSFS_TRAINING_DATASET) {
            String dsPath = this.inodeController.getPath(trainingDataset.getHopsfsTrainingDataset().getInode());
            String username = this.hdfsUsersBean.getHdfsUserName(project, user);
            DistributedFileSystemOps udfso = this.dfs.getDfsOps(username);
            try {
                udfso.rm(dsPath, true);
            }
            catch (IOException e) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_DELETE_TRAINING_DATASET, Level.WARNING, "", e.getMessage(), (Throwable)e);
            }
            finally {
                if (udfso != null) {
                    this.dfs.closeDfsClient(udfso);
                }
            }
        }
        return trainingDataset.getName();
    }

    public TrainingDatasetDTO updateTrainingDatasetMetadata(Featurestore featurestore, TrainingDatasetDTO trainingDatasetDTO) throws FeaturestoreException {
        TrainingDataset trainingDataset = this.verifyTrainingDatasetId(trainingDatasetDTO.getId(), featurestore);
        this.featurestoreInputValidation.verifyUserInput(trainingDatasetDTO);
        List<Jobs> jobs = this.getJobs(trainingDatasetDTO.getJobs(), featurestore.getProject());
        this.featurestoreJobFacade.insertJobs(trainingDataset, jobs);
        trainingDataset.setDescription(trainingDatasetDTO.getDescription());
        this.trainingDatasetFacade.updateTrainingDatasetMetadata(trainingDataset);
        TrainingDataset updatedTrainingDataset = this.trainingDatasetFacade.findByIdAndFeaturestore(trainingDatasetDTO.getId(), featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "training dataset id: " + trainingDatasetDTO.getId()));
        return this.convertTrainingDatasetToDTO(updatedTrainingDataset);
    }

    public TrainingDatasetDTO updateTrainingDatasetStats(Featurestore featurestore, TrainingDatasetDTO trainingDatasetDTO) throws FeaturestoreException {
        TrainingDataset trainingDataset = this.verifyTrainingDatasetId(trainingDatasetDTO.getId(), featurestore);
        this.verifyStatisticsInput(trainingDatasetDTO);
        this.featurestoreStatisticController.updateFeaturestoreStatistics(null, trainingDataset, trainingDatasetDTO.getFeatureCorrelationMatrix(), trainingDatasetDTO.getDescriptiveStatistics(), trainingDatasetDTO.getFeaturesHistogram(), trainingDatasetDTO.getClusterAnalysis());
        return this.convertTrainingDatasetToDTO(trainingDataset);
    }

    public Dataset getTrainingDatasetFolder(Project project) {
        return this.datasetController.getByProjectAndDsName(project, null, this.getTrainingDatasetFolderName(project));
    }

    public String getTrainingDatasetFolderName(Project project) {
        return project.getName() + "_" + Settings.ServiceDataset.TRAININGDATASETS.getName();
    }

    public String getTrainingDatasetPath(String trainingDatasetsFolderPath, String trainingDatasetName, Integer version) {
        return trainingDatasetsFolderPath + "/" + trainingDatasetName + "_" + version;
    }

    private void verifyStatisticsInput(TrainingDatasetDTO trainingDatasetDTO) {
        if (trainingDatasetDTO.getFeatureCorrelationMatrix() != null && trainingDatasetDTO.getFeatureCorrelationMatrix().getFeatureCorrelations().size() > 50) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.CORRELATION_MATRIX_EXCEED_MAX_SIZE.getMessage());
        }
    }

    private TrainingDataset verifyTrainingDatasetId(Integer trainingDatasetId, Featurestore featurestore) throws FeaturestoreException {
        return this.trainingDatasetFacade.findByIdAndFeaturestore(trainingDatasetId, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "training dataset id: " + trainingDatasetId));
    }

    private void verifyTrainingDatasetType(TrainingDatasetType trainingDatasetType) throws FeaturestoreException {
        if (trainingDatasetType != TrainingDatasetType.HOPSFS_TRAINING_DATASET && trainingDatasetType != TrainingDatasetType.EXTERNAL_TRAINING_DATASET) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_TYPE, Level.FINE, ", Recognized Training Dataset types are: " + TrainingDatasetType.HOPSFS_TRAINING_DATASET + ", and: " + TrainingDatasetType.EXTERNAL_TRAINING_DATASET + ". The provided training dataset type was not recognized: " + trainingDatasetType);
        }
    }

    private void verifyTrainingDatasetVersion(Integer version) throws FeaturestoreException {
        if (version == null) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_VERSION_NOT_PROVIDED.getMessage());
        }
        if (version <= 0) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_VERSION, Level.FINE, " version cannot be negative or zero");
        }
    }

    private void verifyTrainingDatasetDataFormat(String dataFormat) throws FeaturestoreException {
        if (!FeaturestoreConstants.TRAINING_DATASET_DATA_FORMATS.contains(dataFormat)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_DATA_FORMAT, Level.FINE, ", the recognized training dataset formats are: " + StringUtils.join((Object[])new List[]{FeaturestoreConstants.TRAINING_DATASET_DATA_FORMATS}) + ". The provided data format:" + dataFormat + " was not recognized.");
        }
    }

    private void verifyTrainingDatasetSplits(List<TrainingDatasetSplitDTO> trainingDatasetSplitDTOs) throws FeaturestoreException {
        if (trainingDatasetSplitDTOs != null && !trainingDatasetSplitDTOs.isEmpty()) {
            Pattern namePattern = FeaturestoreConstants.FEATURESTORE_REGEX;
            for (TrainingDatasetSplitDTO trainingDatasetSplitDTO : trainingDatasetSplitDTOs) {
                if (!namePattern.matcher(trainingDatasetSplitDTO.getName()).matches()) {
                    throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_SPLIT_NAME, Level.FINE, ", the provided training dataset split name " + trainingDatasetSplitDTO.getName() + " is invalid. Split names can only contain lower case characters, numbers and underscores and cannot be longer than " + 63 + " characters or empty.");
                }
                if (trainingDatasetSplitDTO.getPercentage() != null) continue;
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_SPLIT_PERCENTAGE, Level.FINE, ", the provided training dataset split percentage is invalid. Percentages can only be numeric. Weights will be normalized if they don\u2019t sum up to 1.0.");
            }
        }
    }

    private void verifyTrainingDatasetInput(TrainingDatasetDTO trainingDatasetDTO, Featurestore featurestore) throws FeaturestoreException {
        this.verifyTrainingDatasetType(trainingDatasetDTO.getTrainingDatasetType());
        this.verifyTrainingDatasetVersion(trainingDatasetDTO.getVersion());
        this.verifyTrainingDatasetDataFormat(trainingDatasetDTO.getDataFormat());
        this.verifyTrainingDatasetSplits(trainingDatasetDTO.getSplits());
    }
}

