/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jupyter;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsersFacade;
import io.hops.hopsworks.common.dao.jupyter.JupyterSettingsFacade;
import io.hops.hopsworks.common.dao.jupyter.config.JupyterFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.jupyter.JupyterJWTManager;
import io.hops.hopsworks.common.jupyter.JupyterManager;
import io.hops.hopsworks.common.jupyter.JupyterNbVCSController;
import io.hops.hopsworks.common.livy.LivyController;
import io.hops.hopsworks.common.livy.LivyMsg;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.hdfs.user.HdfsUsers;
import io.hops.hopsworks.persistence.entity.jupyter.JupyterProject;
import io.hops.hopsworks.persistence.entity.jupyter.JupyterSettings;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.ws.rs.client.ClientBuilder;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.Path;
import org.json.JSONArray;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class JupyterController {
    private static final Logger LOGGER = Logger.getLogger(JupyterController.class.getName());
    @EJB
    private DistributedFsService dfs;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private Settings settings;
    @EJB
    private LivyController livyController;
    @EJB
    private JupyterFacade jupyterFacade;
    @Inject
    private JupyterManager jupyterManager;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    private DistributedFsService dfsService;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private UserFacade userFacade;
    @EJB
    private JupyterSettingsFacade jupyterSettingsFacade;
    @EJB
    private HdfsUsersFacade hdfsUsersFacade;
    @EJB
    private JupyterJWTManager jupyterJWTManager;
    @Inject
    private JupyterNbVCSController jupyterNbVCSController;

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public String convertIPythonNotebook(String hdfsUsername, String notebookPath, Project project, String pyPath, NotebookConversion notebookConversion) throws ServiceException {
        String conversionDir = DigestUtils.sha256Hex((String)Integer.toString(ThreadLocalRandom.current().nextInt()));
        notebookPath = notebookPath.replace(" ", "\\ ");
        pyPath = pyPath.replace(" ", "\\ ");
        String prog = this.settings.getHopsworksDomainDir() + "/bin/convert-ipython-notebook.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand(prog).addCommand(notebookPath).addCommand(hdfsUsername).addCommand(this.settings.getAnacondaProjectDir(project)).addCommand(pyPath).addCommand(conversionDir).addCommand(notebookConversion.name()).setWaitTimeout(60L, TimeUnit.SECONDS).redirectErrorStream(true).build();
        LOGGER.log(Level.FINE, processDescriptor.toString());
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (!processResult.processExited() || processResult.getExitCode() != 0) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.IPYTHON_CONVERT_ERROR, Level.SEVERE, "error code: " + processResult.getExitCode(), "Failed to convert " + notebookPath + "\nstderr: " + processResult.getStderr() + "\nstdout: " + processResult.getStdout());
            }
            String stdOut = processResult.getStdout();
            if (!Strings.isNullOrEmpty((String)stdOut) && notebookConversion.equals((Object)NotebookConversion.HTML)) {
                StringBuilder renderedNotebookSB = new StringBuilder(stdOut);
                int startIndex = renderedNotebookSB.indexOf("<html>");
                int stopIndex = renderedNotebookSB.length();
                return renderedNotebookSB.substring(startIndex, stopIndex);
            }
            return null;
        }
        catch (IOException ex) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.IPYTHON_CONVERT_ERROR, Level.SEVERE, null, ex.getMessage(), (Throwable)ex);
        }
    }

    public void shutdownOrphan(Long pid, Integer port) throws ServiceException {
        try {
            this.jupyterManager.stopOrphanedJupyterServer(pid, port);
        }
        finally {
            this.jupyterJWTManager.cleanJWT(pid, port);
        }
    }

    public void shutdownQuietly(Project project, String hdfsUser, Users user, String secret, long pid, int port) {
        try {
            this.shutdown(project, hdfsUser, user, secret, pid, port, true);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Encountered exception while cleaning up", e);
        }
        this.jupyterJWTManager.cleanJWT(pid, port);
    }

    public void shutdown(Project project, String hdfsUser, Users user, String secret, long pid, int port) throws ServiceException {
        this.shutdown(project, hdfsUser, user, secret, pid, port, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(Project project, String hdfsUser, Users user, String secret, long pid, int port, boolean quiet) throws ServiceException {
        DistributedFileSystemOps dfso;
        String[] project_user;
        List<LivyMsg.Session> sessions = this.livyController.getLivySessionsForProjectUser(project, user);
        for (int retries = 3; retries > 0 && this.livyController.getLivySessionsForProjectUser(project, user).size() > 0; --retries) {
            LOGGER.log(Level.SEVERE, "Failed previous attempt to delete livy sessions for project " + project.getName() + " user " + hdfsUser + ", retrying...");
            this.livyController.deleteAllLivySessions(hdfsUser);
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException ie) {
                LOGGER.log(Level.SEVERE, "Interrupted while sleeping");
            }
        }
        String jupyterHomePath = this.jupyterManager.getJupyterHome(hdfsUser, project, secret);
        try {
            JupyterProject jupyterProject = this.jupyterFacade.findByUser(hdfsUser);
            JupyterSettings jupyterSettings = this.jupyterSettingsFacade.findByProjectUser(project.getId(), user.getEmail());
            if (jupyterProject != null && jupyterSettings != null && jupyterSettings.isGitBackend().booleanValue() && jupyterSettings.getGitConfig().getShutdownAutoPush().booleanValue()) {
                try {
                    this.jupyterNbVCSController.push(jupyterProject, jupyterSettings, user);
                }
                catch (ServiceException ex) {
                    if (!quiet) {
                        throw ex;
                    }
                    LOGGER.log(Level.WARNING, "Could not push Git repository, shutting down Jupyter nevertheless", ex);
                }
            }
            this.jupyterManager.stopJupyterServer(project, user, hdfsUser, jupyterHomePath, pid, port);
            project_user = hdfsUser.split("__");
            dfso = this.dfsService.getDfsOps();
        }
        catch (Throwable throwable) {
            String[] project_user2 = hdfsUser.split("__");
            DistributedFileSystemOps dfso2 = this.dfsService.getDfsOps();
            try {
                String certificatesDir = Paths.get(jupyterHomePath, "certificates").toString();
                HopsUtils.cleanupCertificatesForUserCustomDir(project_user2[1], project.getName(), this.settings.getHdfsTmpCertDir(), this.certificateMaterializer, certificatesDir, this.settings);
                this.certificateMaterializer.removeCertificatesLocal(project_user2[1], project.getName());
            }
            finally {
                if (dfso2 != null) {
                    this.dfsService.closeDfsClient(dfso2);
                }
            }
            FileUtils.deleteQuietly((File)new File(jupyterHomePath));
            this.jupyterJWTManager.cleanJWT(pid, port);
            this.livyController.deleteAllLivySessions(hdfsUser);
            throw throwable;
        }
        try {
            String certificatesDir = Paths.get(jupyterHomePath, "certificates").toString();
            HopsUtils.cleanupCertificatesForUserCustomDir(project_user[1], project.getName(), this.settings.getHdfsTmpCertDir(), this.certificateMaterializer, certificatesDir, this.settings);
            this.certificateMaterializer.removeCertificatesLocal(project_user[1], project.getName());
        }
        finally {
            if (dfso != null) {
                this.dfsService.closeDfsClient(dfso);
            }
        }
        FileUtils.deleteQuietly((File)new File(jupyterHomePath));
        this.jupyterJWTManager.cleanJWT(pid, port);
        this.livyController.deleteAllLivySessions(hdfsUser);
    }

    public void stopSession(Project project, Users user, String appId) {
        List<LivyMsg.Session> sessions = this.livyController.getLivySessionsForProjectUser(project, user);
        for (LivyMsg.Session session : sessions) {
            if (!session.getAppId().equalsIgnoreCase(appId)) continue;
            this.livyController.deleteLivySession(session.getId());
            break;
        }
    }

    public void removeJupyter(Project project) throws ServiceException {
        for (JupyterProject jp : project.getJupyterProjectCollection()) {
            HdfsUsers hdfsUser = this.hdfsUsersFacade.findById(jp.getHdfsUserId());
            String username = this.hdfsUsersController.getUserName(hdfsUser.getName());
            Users user = this.userFacade.findByUsername(username);
            this.shutdown(project, hdfsUser.getName(), user, jp.getSecret(), jp.getPid(), jp.getPort());
        }
        this.jupyterManager.projectCleanup(project);
    }

    public void updateExpirationDate(Project project, Users user, JupyterSettings jupyterSettings) {
        JupyterSettings js = this.jupyterSettingsFacade.findByProjectUser(project.getId(), user.getEmail());
        js.setShutdownLevel(jupyterSettings.getShutdownLevel());
        this.jupyterSettingsFacade.update(js);
        String hdfsUser = this.hdfsUsersController.getHdfsUserName(project, user);
        JupyterProject jupyterProject = this.jupyterFacade.findByUser(hdfsUser);
        Date expirationDate = jupyterProject.getExpires();
        Calendar cal = Calendar.getInstance();
        cal.setTime(expirationDate);
        cal.add(11, jupyterSettings.getShutdownLevel());
        expirationDate = cal.getTime();
        jupyterProject.setExpires(expirationDate);
        this.jupyterFacade.update(jupyterProject);
    }

    public void versionProgram(Project project, Users user, String sessionKernelId, Path outputPath) throws ServiceException {
        block10: {
            String hdfsUser = this.hdfsUsersController.getHdfsUserName(project, user);
            JupyterProject jp = this.jupyterFacade.findByUser(hdfsUser);
            String relativeNotebookPath = null;
            try {
                JSONArray sessionsArray = new JSONArray((String)ClientBuilder.newClient().target("http://" + this.settings.getJupyterHost() + ":" + jp.getPort() + "/hopsworks-api/jupyter/" + jp.getPort() + "/api/sessions?token=" + jp.getToken()).request().method("GET").readEntity(String.class));
                boolean foundKernel = false;
                for (int i = 0; i < sessionsArray.length(); ++i) {
                    JSONObject session = (JSONObject)sessionsArray.get(i);
                    JSONObject kernel = (JSONObject)session.get("kernel");
                    String kernelId = kernel.getString("id");
                    if (!kernelId.equals(sessionKernelId)) continue;
                    relativeNotebookPath = session.getString("path");
                    foundKernel = true;
                }
                if (!foundKernel) {
                    throw new ServiceException(RESTCodes.ServiceErrorCode.JUPYTER_NOTEBOOK_VERSIONING_FAILED, Level.FINE, "failed to find kernel " + sessionKernelId);
                }
                if (Strings.isNullOrEmpty(relativeNotebookPath)) break block10;
                JSONObject notebookContents = new JSONObject((String)ClientBuilder.newClient().target("http://" + this.settings.getJupyterHost() + ":" + jp.getPort() + "/hopsworks-api/jupyter/" + jp.getPort() + "/api/contents/" + relativeNotebookPath + "?content=1&token=" + jp.getToken()).request().method("GET").readEntity(String.class));
                JSONObject notebookJSON = (JSONObject)notebookContents.get("content");
                DistributedFileSystemOps udfso = null;
                try {
                    String username = this.hdfsUsersController.getHdfsUserName(project, user);
                    udfso = this.dfs.getDfsOps(username);
                    udfso.create(outputPath, notebookJSON.toString());
                    if (udfso != null) {
                        this.dfs.closeDfsClient(udfso);
                    }
                }
                catch (IOException e) {
                    try {
                        throw new ServiceException(RESTCodes.ServiceErrorCode.JUPYTER_NOTEBOOK_VERSIONING_FAILED, Level.FINE, "failed to save notebook content", e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (udfso != null) {
                            this.dfs.closeDfsClient(udfso);
                        }
                        throw throwable;
                    }
                }
            }
            catch (Exception e) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.JUPYTER_NOTEBOOK_VERSIONING_FAILED, Level.FINE, "failed to version notebook", e.getMessage(), (Throwable)e);
            }
        }
    }

    public static enum NotebookConversion {
        PY,
        HTML,
        PY_JOB;

    }
}

