/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security;

import io.hops.hopsworks.common.dao.certificates.CertsFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.security.AcquireLockException;
import io.hops.hopsworks.common.security.CertificatesMgmService;
import io.hops.hopsworks.common.security.RemoteMaterialReferencesFacade;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.CryptoPasswordNotFoundException;
import io.hops.hopsworks.persistence.entity.certificates.UserCerts;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.security.RemoteMaterialRefID;
import io.hops.hopsworks.persistence.entity.security.RemoteMaterialReferences;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.bag.HashBag;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@DependsOn(value={"Settings"})
public class CertificateMaterializer {
    private static final Logger LOG = Logger.getLogger(CertificateMaterializer.class.getName());
    private static final int MAX_NUMBER_OF_RETRIES = 3;
    private static final long RETRY_WAIT_TIMEOUT = 10L;
    private final Map<MaterialKey, Bag> materializedCerts;
    private final Map<MaterialKey, CryptoMaterial> materialCache;
    private final Map<MaterialKey, Map<String, LocalFileRemover>> fileRemovers;
    private final Map<MaterialKey, ReentrantReadWriteLock> materialKeyLocks = new ConcurrentHashMap<MaterialKey, ReentrantReadWriteLock>();
    private String lock_id;
    private String transientDir;
    private Long DELAY_VALUE;
    private TimeUnit DELAY_TIMEUNIT;
    @EJB
    private Settings settings;
    @EJB
    private CertsFacade certsFacade;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private UserFacade userFacade;
    @EJB
    private CertificatesMgmService certificatesMgmService;
    @EJB
    private RemoteMaterialReferencesFacade remoteMaterialReferencesFacade;
    @EJB
    private DistributedFsService distributedFsService;
    @Resource
    private ManagedScheduledExecutorService scheduler;

    public CertificateMaterializer() {
        this.materializedCerts = new HashMap<MaterialKey, Bag>();
        this.materialCache = new HashMap<MaterialKey, CryptoMaterial>();
        this.fileRemovers = new HashMap<MaterialKey, Map<String, LocalFileRemover>>();
    }

    @PostConstruct
    public void init() {
        File tmpDir = new File(this.settings.getHopsworksTmpCertDir());
        if (!tmpDir.exists()) {
            throw new IllegalStateException("Transient certificates directory <" + tmpDir.getAbsolutePath() + "> does NOT exist!");
        }
        try {
            PosixFileAttributeView fileView = Files.getFileAttributeView(tmpDir.toPath(), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            Set<PosixFilePermission> permissions = fileView.readAttributes().permissions();
            boolean ownerRead = permissions.contains((Object)PosixFilePermission.OWNER_READ);
            boolean ownerWrite = permissions.contains((Object)PosixFilePermission.OWNER_WRITE);
            boolean ownerExecute = permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE);
            boolean groupRead = permissions.contains((Object)PosixFilePermission.GROUP_READ);
            boolean groupWrite = permissions.contains((Object)PosixFilePermission.GROUP_WRITE);
            boolean groupExecute = permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE);
            boolean othersRead = permissions.contains((Object)PosixFilePermission.OTHERS_READ);
            boolean othersWrite = permissions.contains((Object)PosixFilePermission.OTHERS_WRITE);
            boolean othersExecute = permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE);
            if (!(ownerRead && ownerWrite && ownerExecute && groupRead && !groupWrite && groupExecute && !othersRead && !othersWrite & !othersExecute)) {
                throw new IllegalStateException("Wrong permissions for " + tmpDir.getAbsolutePath() + ", it should be 0750");
            }
            String owner = fileView.readAttributes().owner().getName();
            String group = fileView.readAttributes().group().getName();
            String permStr = PosixFilePermissions.toString(permissions);
            LOG.log(Level.INFO, "Passed permissions check for " + tmpDir.getAbsolutePath() + ". Owner: " + owner + " Group: " + group + " permissions: " + permStr);
        }
        catch (UnsupportedOperationException ex) {
            LOG.log(Level.WARNING, "Associated filesystem is not POSIX compliant. Continue without checking the permissions of " + tmpDir.getAbsolutePath() + " This might be a security problem.");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error while getting filesystem permissions of " + tmpDir.getAbsolutePath(), ex);
        }
        try {
            FileUtils.cleanDirectory((File)tmpDir);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Could not clean directory " + tmpDir.getAbsolutePath() + " during startup, there might be stale certificates", ex);
        }
        this.transientDir = tmpDir.getAbsolutePath();
        String delayRaw = this.settings.getCertificateMaterializerDelay();
        this.DELAY_VALUE = this.settings.getConfTimeValue(delayRaw);
        this.DELAY_TIMEUNIT = this.settings.getConfTimeTimeUnit(delayRaw);
        try {
            String hostAddress = InetAddress.getLocalHost().getHostAddress();
            long threadId = Thread.currentThread().getId();
            String lock_identifier = hostAddress + "_" + threadId;
            this.lock_id = lock_identifier.length() <= 30 ? lock_identifier : lock_identifier.substring(0, 30);
        }
        catch (UnknownHostException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @PreDestroy
    public void tearDown() {
        try {
            FileUtils.cleanDirectory((File)new File(this.transientDir));
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Could not clean directory " + this.transientDir + " Administrator should clean it manually!", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void materializeCertificatesLocal(String userName, String projectName) throws IOException {
        MaterialKey key = new MaterialKey(userName, projectName);
        ReentrantReadWriteLock.WriteLock lock = null;
        try {
            lock = this.getWriteLockForKey(key);
            lock.lock();
            this.materializeLocalInternal(key, this.transientDir);
        }
        finally {
            lock.unlock();
        }
    }

    private ReentrantReadWriteLock.ReadLock getReadLockForKey(MaterialKey key) {
        ReentrantReadWriteLock lock = this.getLockForKey(key, false);
        return lock != null ? lock.readLock() : null;
    }

    private ReentrantReadWriteLock.WriteLock getWriteLockForKey(MaterialKey key) {
        return this.getLockForKey(key, true).writeLock();
    }

    private ReentrantReadWriteLock getLockForKey(MaterialKey key, boolean createIfMissing) {
        if (createIfMissing) {
            this.materialKeyLocks.putIfAbsent(key, new ReentrantReadWriteLock(true));
        }
        return this.materialKeyLocks.get(key);
    }

    private void removeLockForKey(MaterialKey key) {
        this.materialKeyLocks.remove(key);
    }

    public void materializeCertificatesLocalCustomDir(String projectName, String localDirectory) throws IOException {
        this.materializeCertificatesLocalCustomDir(null, projectName, localDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void materializeCertificatesLocalCustomDir(String userName, String projectName, String localDirectory) throws IOException {
        MaterialKey key = new MaterialKey(userName, projectName);
        localDirectory = localDirectory != null ? localDirectory : this.transientDir;
        ReentrantReadWriteLock.WriteLock lock = null;
        try {
            lock = this.getWriteLockForKey(key);
            lock.lock();
            this.materializeLocalInternal(key, localDirectory);
        }
        finally {
            lock.unlock();
        }
    }

    public void removeCertificatesLocal(String projectName) {
        this.removeCertificatesLocal(null, projectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCertificatesLocal(String userName, String projectName) {
        MaterialKey key = new MaterialKey(userName, projectName);
        ReentrantReadWriteLock.WriteLock lock = null;
        boolean materialExist = false;
        try {
            lock = this.getWriteLockForKey(key);
            lock.lock();
            materialExist = this.removeLocal(key, this.transientDir);
        }
        finally {
            if (!materialExist) {
                this.removeLockForKey(key);
            }
            lock.unlock();
        }
    }

    public void removeCertificatesLocalCustomDir(String projectName, String localDirectory) {
        this.removeCertificatesLocalCustomDir(null, projectName, localDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCertificatesLocalCustomDir(String username, String projectName, String localDirectory) {
        MaterialKey key = new MaterialKey(username, projectName);
        localDirectory = localDirectory != null ? localDirectory : this.transientDir;
        ReentrantReadWriteLock.WriteLock lock = null;
        boolean materialExist = false;
        try {
            lock = this.getWriteLockForKey(key);
            lock.lock();
            materialExist = this.removeLocal(key, localDirectory);
        }
        finally {
            if (!materialExist) {
                this.removeLockForKey(key);
            }
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void materializeCertificatesRemote(String userName, String projectName, String ownerName, String groupName, FsPermission permissions, String remoteDirectory) throws IOException {
        if (remoteDirectory == null) {
            throw new IllegalArgumentException("Remote directory should not be null");
        }
        remoteDirectory = this.normalizeURI(remoteDirectory);
        MaterialKey key = new MaterialKey(userName, projectName);
        ReentrantReadWriteLock.WriteLock lock = null;
        try {
            lock = this.getWriteLockForKey(key);
            lock.lock();
            this.materializeRemoteInternal(key, ownerName, groupName, permissions, remoteDirectory);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCertificatesRemote(String userName, String projectName, String remoteDirectory) {
        if (remoteDirectory == null) {
            throw new IllegalArgumentException("Remote directory cannot be null");
        }
        remoteDirectory = this.normalizeURI(remoteDirectory);
        MaterialKey key = new MaterialKey(userName, projectName);
        ReentrantReadWriteLock.WriteLock lock = null;
        boolean materialExist = false;
        try {
            lock = this.getWriteLockForKey(key);
            lock.lock();
            materialExist = this.removeRemoteInternal(key, remoteDirectory, false);
        }
        finally {
            if (!materialExist) {
                this.removeLockForKey(key);
            }
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRemoveRemoteMaterial(String username, String projectName, String remoteDirectory, boolean bothProjectAndUser) {
        block9: {
            if (remoteDirectory == null) {
                throw new IllegalArgumentException("Remote directory cannot be null");
            }
            remoteDirectory = this.normalizeURI(remoteDirectory);
            MaterialKey key = new MaterialKey(username, projectName);
            ReentrantReadWriteLock.WriteLock lock = null;
            boolean deletedMaterial = false;
            try {
                lock = this.getWriteLockForKey(key);
                lock.lock();
                deletedMaterial = this.removeRemoteInternal(key, remoteDirectory, true);
                if (!bothProjectAndUser) break block9;
                ReentrantReadWriteLock.WriteLock projectLock = null;
                boolean deletedProjectMaterial = false;
                key = new MaterialKey(null, projectName);
                try {
                    projectLock = this.getWriteLockForKey(key);
                    projectLock.lock();
                    deletedProjectMaterial = this.removeRemoteInternal(key, remoteDirectory, true);
                }
                finally {
                    if (!deletedProjectMaterial) {
                        this.removeLockForKey(key);
                    }
                    projectLock.unlock();
                }
            }
            finally {
                if (!deletedMaterial) {
                    this.removeLockForKey(key);
                }
                lock.unlock();
            }
        }
    }

    public CryptoMaterial getUserMaterial(String projectName) throws CryptoPasswordNotFoundException {
        return this.getUserMaterial(null, projectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CryptoMaterial getUserMaterial(String username, String projectName) throws CryptoPasswordNotFoundException {
        MaterialKey key = new MaterialKey(username, projectName);
        ReentrantReadWriteLock.ReadLock lock = null;
        try {
            lock = this.getReadLockForKey(key);
            if (lock == null) {
                throw new CryptoPasswordNotFoundException("Could not find a lock associated with this key " + key.getExtendedUsername());
            }
            lock.lock();
            CryptoMaterial material = this.materialCache.get(key);
            if (material == null) {
                throw new CryptoPasswordNotFoundException("Cryptographic material for user <" + key.getExtendedUsername() + " does not exist in the cache!");
            }
            CryptoMaterial cryptoMaterial = material;
            return cryptoMaterial;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public void forceRemoveLocalMaterial(String username, String projectName, String materializationDirectory, boolean bothProjectAndUser) {
        this.forceRemoveLocalMaterial(username, projectName, materializationDirectory);
        if (bothProjectAndUser) {
            this.forceRemoveLocalMaterial(null, projectName, materializationDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsInLocalStore(String username, String projectName, String directory) {
        directory = directory != null ? directory : this.transientDir;
        MaterialKey key = new MaterialKey(username, projectName);
        ReentrantReadWriteLock.ReadLock lock = null;
        try {
            lock = this.getReadLockForKey(key);
            if (lock == null) {
                LOG.log(Level.WARNING, "Could not find read lock for key " + key.getExtendedUsername());
                boolean bl = false;
                return bl;
            }
            lock.lock();
            Bag materializedPaths = this.materializedCerts.get(key);
            if (materializedPaths == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = materializedPaths.contains((Object)directory);
            return bl;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public boolean existsInRemoteStore(String username, String projectName, String remoteDirectory) {
        if (remoteDirectory == null) {
            throw new IllegalArgumentException("Remote directory cannot be null");
        }
        MaterialKey key = new MaterialKey(username, projectName);
        RemoteMaterialRefID identifier = new RemoteMaterialRefID(key.getExtendedUsername(), remoteDirectory);
        RemoteMaterialReferences ref = this.remoteMaterialReferencesFacade.findById(identifier);
        return ref != null;
    }

    public MaterializerState<Map<String, Map<String, Integer>>, Map<String, Map<String, Integer>>, Map<String, Set<String>>, Map<String, Boolean>> getState() {
        MaterializerState<Map<MaterialKey, Bag>, List<RemoteMaterialReferences>, Map<MaterialKey, Map<String, Runnable>>, Map<MaterialKey, ReentrantReadWriteLock>> state = this.getImmutableState();
        Map<MaterialKey, Bag> localMaterialState = state.getLocalMaterial();
        HashMap simpleLocalMaterialState = new HashMap(localMaterialState.size());
        for (Map.Entry<MaterialKey, Bag> entry : localMaterialState.entrySet()) {
            String username = entry.getKey().getExtendedUsername();
            HashMap<String, Integer> referencesMap = new HashMap<String, Integer>();
            Bag pathsBag = entry.getValue();
            Set set = pathsBag.uniqueSet();
            for (String string : set) {
                referencesMap.put(string, pathsBag.getCount((Object)string));
            }
            simpleLocalMaterialState.put(username, referencesMap);
        }
        List<RemoteMaterialReferences> remoteMaterialState = state.getRemoteMaterial();
        HashMap simpleRemoteMaterialState = new HashMap(remoteMaterialState.size());
        for (RemoteMaterialReferences ref : remoteMaterialState) {
            String username = ref.getIdentifier().getUsername();
            Map map = (Map)simpleRemoteMaterialState.get(username);
            if (map == null) {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                hashMap.put(ref.getIdentifier().getPath(), ref.getReferences());
                simpleRemoteMaterialState.put(username, hashMap);
                continue;
            }
            map.put(ref.getIdentifier().getPath(), ref.getReferences());
        }
        Map<MaterialKey, Map<String, Runnable>> fileRemovals = state.getScheduledRemovals();
        HashMap simpleScheduledRemovals = new HashMap();
        for (Map.Entry entry : fileRemovals.entrySet()) {
            String username = ((MaterialKey)entry.getKey()).getExtendedUsername();
            simpleScheduledRemovals.put(username, ((Map)entry.getValue()).keySet());
        }
        Map<MaterialKey, ReentrantReadWriteLock> materialKeyLocks = state.getMaterialKeyLocks();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(materialKeyLocks.size());
        for (Map.Entry entry : materialKeyLocks.entrySet()) {
            hashMap.put(((MaterialKey)entry.getKey()).getExtendedUsername(), ((ReentrantReadWriteLock)entry.getValue()).isWriteLocked());
        }
        return new MaterializerState<Map<String, Map<String, Integer>>, Map<String, Map<String, Integer>>, Map<String, Set<String>>, Map<String, Boolean>>(simpleLocalMaterialState, simpleRemoteMaterialState, simpleScheduledRemovals, hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MaterializerState<Map<MaterialKey, Bag>, List<RemoteMaterialReferences>, Map<MaterialKey, Map<String, Runnable>>, Map<MaterialKey, ReentrantReadWriteLock>> getImmutableState() {
        Map localMaterial = null;
        Map scheduledRemovals = null;
        List<RemoteMaterialReferences> remoteMaterial = null;
        Map materialKeyLocks = null;
        TreeSet<ReentrantReadWriteLock> acquiredLocks = this.acquireWriteLocks(this.materialKeyLocks);
        try {
            localMaterial = MapUtils.unmodifiableMap(this.materializedCerts);
            scheduledRemovals = MapUtils.unmodifiableMap(this.fileRemovers);
            materialKeyLocks = MapUtils.unmodifiableMap(this.materialKeyLocks);
            remoteMaterial = this.remoteMaterialReferencesFacade.findAll();
        }
        finally {
            this.releaseWriteLocks(acquiredLocks);
        }
        return new MaterializerState<Map<MaterialKey, Bag>, List<RemoteMaterialReferences>, Map<MaterialKey, Map<String, Runnable>>, Map<MaterialKey, ReentrantReadWriteLock>>(localMaterial, remoteMaterial, scheduledRemovals, materialKeyLocks);
    }

    private TreeSet<ReentrantReadWriteLock> acquireWriteLocks(Map<MaterialKey, ReentrantReadWriteLock> lockSet) {
        TreeSet<ReentrantReadWriteLock> acquiredLocks = new TreeSet<ReentrantReadWriteLock>(new Comparator<ReentrantReadWriteLock>(){

            @Override
            public int compare(ReentrantReadWriteLock t0, ReentrantReadWriteLock t1) {
                if (t0.hashCode() < t1.hashCode()) {
                    return -1;
                }
                if (t0.hashCode() > t1.hashCode()) {
                    return 1;
                }
                return 0;
            }
        });
        lockSet.values().stream().forEach(l -> {
            l.writeLock().lock();
            acquiredLocks.add((ReentrantReadWriteLock)l);
        });
        return acquiredLocks;
    }

    private void releaseWriteLocks(TreeSet<ReentrantReadWriteLock> acquiredLocks) {
        NavigableSet<ReentrantReadWriteLock> reversedLocks = acquiredLocks.descendingSet();
        reversedLocks.stream().forEach(l -> l.writeLock().unlock());
    }

    private void materializeLocalInternal(MaterialKey key, String localDirectory) throws IOException {
        Bag materializedDirs = this.materializedCerts.get(key);
        if (materializedDirs == null) {
            boolean shouldContinue = this.checkWithScheduledRemovalsLocal(key, localDirectory);
            if (shouldContinue) {
                CryptoMaterial material = this.getMaterialFromDatabase(key);
                this.materialCache.put(key, material);
                this.flushToLocalFileSystem(key, material, localDirectory);
                HashBag materialBag = new HashBag();
                String targetDir = localDirectory != null ? localDirectory : this.transientDir;
                materialBag.add((Object)targetDir, 1);
                this.materializedCerts.put(key, (Bag)materialBag);
            }
        } else {
            int cardinality = materializedDirs.getCount((Object)localDirectory);
            if (cardinality == 0) {
                boolean shouldContinue = this.checkWithScheduledRemovalsLocal(key, localDirectory);
                if (shouldContinue) {
                    CryptoMaterial material = this.materialCache.get(key);
                    if (material == null) {
                        material = this.getMaterialFromDatabase(key);
                        this.materialCache.put(key, material);
                    }
                    this.flushToLocalFileSystem(key, material, localDirectory);
                    Bag materialBag = this.materializedCerts.get(key);
                    if (materialBag != null) {
                        materialBag.add((Object)localDirectory, 1);
                    } else {
                        materialBag = new HashBag();
                        materialBag.add((Object)localDirectory, 1);
                        this.materializedCerts.put(key, materialBag);
                    }
                }
            } else {
                materializedDirs.add((Object)localDirectory, 1);
            }
        }
    }

    private boolean checkWithScheduledRemovalsLocal(MaterialKey key, String materializationDirectory) throws IOException {
        Map<String, LocalFileRemover> materialRemovers = this.fileRemovers.get(key);
        if (materialRemovers == null) {
            return true;
        }
        LocalFileRemover localFileRemover = materialRemovers.get(materializationDirectory);
        if (localFileRemover == null) {
            return true;
        }
        boolean managedToCancel = localFileRemover.scheduledFuture.cancel(false);
        if (managedToCancel) {
            Bag materializeBag;
            if (!this.materialCache.containsKey(key)) {
                if (localFileRemover.cryptoMaterial != null) {
                    this.materialCache.put(key, localFileRemover.cryptoMaterial);
                } else {
                    CryptoMaterial material = this.getMaterialFromDatabase(key);
                    this.materialCache.put(key, material);
                }
            }
            if ((materializeBag = this.materializedCerts.get(key)) != null) {
                materializeBag.add((Object)materializationDirectory, 1);
            } else {
                HashBag materializedBag = new HashBag();
                materializedBag.add((Object)materializationDirectory);
                this.materializedCerts.put(key, (Bag)materializedBag);
            }
            materialRemovers.remove(materializationDirectory);
            if (materialRemovers.isEmpty()) {
                this.fileRemovers.remove(key);
            }
            return false;
        }
        this.forceRemoveLocalMaterial(key.username, key.projectName, materializationDirectory);
        this.materialKeyLocks.putIfAbsent(key, new ReentrantReadWriteLock(true));
        return true;
    }

    private void flushToLocalFileSystem(MaterialKey key, CryptoMaterial cryptoMaterial, String materializationDirectory) throws IOException {
        String targetDir = materializationDirectory != null ? materializationDirectory : this.transientDir;
        File keyStoreFile = Paths.get(targetDir, key.getExtendedUsername() + "__kstore.jks").toFile();
        File trustStoreFile = Paths.get(targetDir, key.getExtendedUsername() + "__tstore.jks").toFile();
        File passwordFile = Paths.get(targetDir, key.getExtendedUsername() + "__cert.key").toFile();
        FileUtils.writeByteArrayToFile((File)keyStoreFile, (byte[])cryptoMaterial.getKeyStore().array(), (boolean)false);
        FileUtils.writeByteArrayToFile((File)trustStoreFile, (byte[])cryptoMaterial.getTrustStore().array(), (boolean)false);
        FileUtils.write((File)passwordFile, (CharSequence)new String(cryptoMaterial.getPassword()), (boolean)false);
    }

    private boolean removeLocal(MaterialKey key, String materializationDirectory) {
        Bag materialBag = this.materializedCerts.get(key);
        if (materialBag != null) {
            materialBag.remove((Object)materializationDirectory, 1);
            if (materialBag.getCount((Object)materializationDirectory) <= 0) {
                this.scheduleFileRemover(key, materializationDirectory);
            }
            return true;
        }
        return false;
    }

    private void scheduleFileRemover(MaterialKey key, String materializationDirectory) {
        LocalFileRemover fileRemover = new LocalFileRemover(key, this.materialCache.get(key), materializationDirectory);
        fileRemover.scheduledFuture = this.scheduler.schedule((Runnable)fileRemover, this.DELAY_VALUE.longValue(), this.DELAY_TIMEUNIT);
        Map<String, LocalFileRemover> materialRemovesForKey = this.fileRemovers.get(key);
        if (materialRemovesForKey != null) {
            materialRemovesForKey.put(materializationDirectory, fileRemover);
        } else {
            materialRemovesForKey = new HashMap<String, LocalFileRemover>();
            materialRemovesForKey.put(materializationDirectory, fileRemover);
            this.fileRemovers.put(key, materialRemovesForKey);
        }
        LOG.log(Level.FINEST, "Scheduled local file removal for <" + key.getExtendedUsername() + ">");
    }

    private void deleteMaterialFromLocalFs(MaterialKey key, String materializationDirectory) {
        File keyStoreFile = Paths.get(materializationDirectory, key.getExtendedUsername() + "__kstore.jks").toFile();
        File trustStoreFile = Paths.get(materializationDirectory, key.getExtendedUsername() + "__tstore.jks").toFile();
        File passwordFile = Paths.get(materializationDirectory, key.getExtendedUsername() + "__cert.key").toFile();
        FileUtils.deleteQuietly((File)keyStoreFile);
        FileUtils.deleteQuietly((File)trustStoreFile);
        FileUtils.deleteQuietly((File)passwordFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceRemoveLocalMaterial(String username, String projectName, String materializationDirectory) {
        ReentrantReadWriteLock.WriteLock lock = null;
        try {
            Bag materialBag;
            materializationDirectory = materializationDirectory != null ? materializationDirectory : this.transientDir;
            MaterialKey key = new MaterialKey(username, projectName);
            lock = this.getWriteLockForKey(key);
            lock.lock();
            Map<String, LocalFileRemover> materialRemovers = this.fileRemovers.get(key);
            if (materialRemovers != null) {
                LocalFileRemover fileRemover = materialRemovers.remove(materializationDirectory);
                if (fileRemover != null) {
                    fileRemover.scheduledFuture.cancel(true);
                }
                if (materialRemovers.isEmpty()) {
                    this.fileRemovers.remove(key);
                }
            }
            if ((materialBag = this.materializedCerts.get(key)) != null) {
                materialBag.remove((Object)materializationDirectory);
                if (materialBag.isEmpty()) {
                    this.materializedCerts.remove(key);
                    CryptoMaterial material = this.materialCache.remove(key);
                    if (material != null) {
                        material.wipePassword();
                    }
                }
            }
            this.deleteMaterialFromLocalFs(key, materializationDirectory);
            this.removeLockForKey(key);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void materializeRemoteInternal(MaterialKey key, String ownerName, String groupName, FsPermission permissions, String remoteDirectory) throws IOException {
        RemoteMaterialReferences materialRef = null;
        RemoteMaterialRefID identifier = new RemoteMaterialRefID(key.getExtendedUsername(), remoteDirectory);
        int retries = 0;
        while (materialRef == null && retries < 3) {
            try {
                materialRef = this.remoteMaterialReferencesFacade.acquireLock(identifier, this.lock_id);
                if (materialRef == null) {
                    this.remoteMaterialReferencesFacade.createNewMaterialReference(identifier);
                    materialRef = this.remoteMaterialReferencesFacade.acquireLock(identifier, this.lock_id);
                    CryptoMaterial material = this.materialCache.get(key);
                    if (material == null) {
                        material = this.getMaterialFromDatabase(key);
                    }
                    DistributedFileSystemOps dfso = this.distributedFsService.getDfsOps();
                    try {
                        Path keyStore = new Path(remoteDirectory + "/" + key.getExtendedUsername() + "__kstore.jks");
                        this.writeToHDFS(dfso, keyStore, material.getKeyStore().array());
                        dfso.setOwner(keyStore, ownerName, groupName);
                        dfso.setPermission(keyStore, permissions);
                        Path trustStore = new Path(remoteDirectory + "/" + key.getExtendedUsername() + "__tstore.jks");
                        this.writeToHDFS(dfso, trustStore, material.getTrustStore().array());
                        dfso.setOwner(trustStore, ownerName, groupName);
                        dfso.setPermission(trustStore, permissions);
                        Path passwordFile = new Path(remoteDirectory + "/" + key.getExtendedUsername() + "__cert.key");
                        this.writeToHDFS(dfso, passwordFile, new String(material.getPassword()).getBytes());
                        dfso.setOwner(passwordFile, ownerName, groupName);
                        dfso.setPermission(passwordFile, permissions);
                    }
                    finally {
                        if (dfso != null) {
                            this.distributedFsService.closeDfsClient(dfso);
                        }
                    }
                    materialRef.setReferences(Integer.valueOf(1));
                    this.remoteMaterialReferencesFacade.update(materialRef);
                    continue;
                }
                materialRef.incrementReferences();
                this.remoteMaterialReferencesFacade.update(materialRef);
            }
            catch (Exception ex) {
                if (ex instanceof AcquireLockException) {
                    LOG.log(Level.WARNING, ex.getMessage(), ex);
                    ++retries;
                    try {
                        TimeUnit.MILLISECONDS.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException iex) {
                        throw new IOException(iex);
                    }
                }
                throw new IOException(ex);
            }
            finally {
                try {
                    this.remoteMaterialReferencesFacade.releaseLock(identifier, this.lock_id);
                }
                catch (AcquireLockException ex) {
                    LOG.log(Level.SEVERE, "Cannot release lock for " + identifier, ex);
                }
            }
        }
        if (materialRef == null) {
            throw new IOException("Could not materialize certificates for " + key.getExtendedUsername() + " in remote directory " + remoteDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToHDFS(DistributedFileSystemOps dfso, Path path, byte[] data) throws IOException {
        if (dfso == null) {
            throw new IOException("DistributedFilesystemOps is null");
        }
        try (FSDataOutputStream fsStream = dfso.getFilesystem().create(path);){
            fsStream.write(data);
            fsStream.hflush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeRemoteInternal(MaterialKey key, String remoteDirectory, boolean force) {
        RemoteMaterialReferences materialRef = null;
        RemoteMaterialRefID identifier = new RemoteMaterialRefID(key.getExtendedUsername(), remoteDirectory);
        int retries = 0;
        boolean deletedMaterial = false;
        while (materialRef == null && retries < 3) {
            try {
                materialRef = force ? new RemoteMaterialReferences(identifier) : this.remoteMaterialReferencesFacade.acquireLock(identifier, this.lock_id);
                if (materialRef != null) {
                    materialRef.decrementReferences();
                    if (materialRef.getReferences() <= 0 || force) {
                        DistributedFileSystemOps dfso = this.distributedFsService.getDfsOps();
                        try {
                            dfso.rm(new Path(remoteDirectory), true);
                        }
                        catch (IOException ex) {
                            LOG.log(Level.SEVERE, "Crypto material for <" + key.getExtendedUsername() + "> could not be removed from HDFS. You SHOULD clean them manually!");
                        }
                        this.remoteMaterialReferencesFacade.delete(materialRef.getIdentifier());
                        deletedMaterial = true;
                        continue;
                    }
                    this.remoteMaterialReferencesFacade.update(materialRef);
                    continue;
                }
                LOG.log(Level.WARNING, "Could not find remote crypto material for " + key.getExtendedUsername() + " to remove");
                break;
            }
            catch (Exception ex) {
                if (ex instanceof AcquireLockException) {
                    LOG.log(Level.WARNING, ex.getMessage(), ex);
                    ++retries;
                    try {
                        TimeUnit.MILLISECONDS.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException iex) {
                        throw new IllegalStateException(iex);
                    }
                }
                throw new RuntimeException(ex);
            }
            finally {
                try {
                    if (!deletedMaterial) {
                        this.remoteMaterialReferencesFacade.releaseLock(identifier, this.lock_id);
                        continue;
                    }
                    this.removeLockForKey(key);
                }
                catch (AcquireLockException ex) {
                    LOG.log(Level.SEVERE, "Cannot release lock for " + identifier, ex);
                }
            }
        }
        return deletedMaterial;
    }

    private String normalizeURI(String uri) {
        Path path = new Path(uri);
        if (path.toUri().getScheme() == null) {
            path.setScheme("hopsfs");
        }
        return path.toString();
    }

    public String getUserTransientPasswordPath(Project project, Users user) {
        String transientDir = this.settings.getHopsworksTmpCertDir();
        String keyName = project.getName() + "__" + user.getUsername() + "__cert.key";
        return transientDir + "/" + keyName;
    }

    public String getUserTransientTruststorePath(Project project, Users user) {
        String transientDir = this.settings.getHopsworksTmpCertDir();
        String truststoreName = project.getName() + "__" + user.getUsername() + "__tstore.jks";
        return transientDir + "/" + truststoreName;
    }

    public String getUserTransientKeystorePath(Project project, Users user) {
        String transientDir = this.settings.getHopsworksTmpCertDir();
        String keystoreName = project.getName() + "__" + user.getUsername() + "__kstore.jks";
        return transientDir + "/" + keystoreName;
    }

    private void deleteFromHDFS(DistributedFileSystemOps dfso, Path path) throws IOException {
        dfso.rm(path, false);
    }

    private CryptoMaterial getMaterialFromDatabase(MaterialKey key) throws IOException {
        UserCerts projectSpecificCerts = this.certsFacade.findUserCert(key.projectName, key.username);
        ByteBuffer keyStore = ByteBuffer.wrap(projectSpecificCerts.getUserKey());
        ByteBuffer trustStore = ByteBuffer.wrap(projectSpecificCerts.getUserCert());
        char[] password = this.decryptMaterialPassword(key.getExtendedUsername(), projectSpecificCerts.getUserKeyPwd());
        return new CryptoMaterial(keyStore, trustStore, password);
    }

    private char[] decryptMaterialPassword(String certificateIdentifier, String encryptedPassword) throws IOException {
        String username = this.hdfsUsersController.getUserName(certificateIdentifier);
        Users user = this.userFacade.findByUsername(username);
        if (user == null) {
            String msg = "Could not find user <" + certificateIdentifier + "> in the system";
            LOG.log(Level.SEVERE, msg);
            throw new IOException(msg);
        }
        String userPassword = user.getPassword();
        try {
            String decryptedPassword = HopsUtils.decrypt(userPassword, encryptedPassword, this.certificatesMgmService.getMasterEncryptionPassword());
            return decryptedPassword.toCharArray();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error while decrypting certificate password for user <" + certificateIdentifier + ">");
            throw new IOException(ex);
        }
    }

    private class LocalFileRemover
    implements Runnable {
        private final MaterialKey key;
        private final CryptoMaterial cryptoMaterial;
        private final String materializationDirectory;
        private ScheduledFuture scheduledFuture;

        private LocalFileRemover(MaterialKey key, CryptoMaterial cryptoMaterial, String materializationDirectory) {
            this.key = key;
            this.cryptoMaterial = cryptoMaterial;
            this.materializationDirectory = materializationDirectory != null ? materializationDirectory : CertificateMaterializer.this.transientDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ReentrantReadWriteLock.WriteLock lock = null;
            try {
                lock = CertificateMaterializer.this.getWriteLockForKey(this.key);
                lock.lock();
                CertificateMaterializer.this.deleteMaterialFromLocalFs(this.key, this.materializationDirectory);
                Map materialRemovers = (Map)CertificateMaterializer.this.fileRemovers.get(this.key);
                if (materialRemovers != null) {
                    Bag materialBag;
                    materialRemovers.remove(this.materializationDirectory);
                    if (materialRemovers.isEmpty()) {
                        CertificateMaterializer.this.fileRemovers.remove(this.key);
                    }
                    if ((materialBag = (Bag)CertificateMaterializer.this.materializedCerts.get(this.key)) != null && materialBag.isEmpty()) {
                        CertificateMaterializer.this.materializedCerts.remove(this.key);
                        CryptoMaterial material = (CryptoMaterial)CertificateMaterializer.this.materialCache.remove(this.key);
                        if (material != null) {
                            material.wipePassword();
                        }
                    }
                    LOG.log(Level.FINEST, "Deleted crypto material for <" + this.key.getExtendedUsername() + "> from directory " + this.materializationDirectory);
                }
                CertificateMaterializer.this.removeLockForKey(this.key);
            }
            finally {
                lock.unlock();
            }
        }
    }

    private class MaterialKey {
        private final String username;
        private final String projectName;

        private MaterialKey(String username, String projectName) {
            this.username = username;
            this.projectName = projectName;
        }

        private String getExtendedUsername() {
            return this.projectName + "__" + this.username;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof MaterialKey) {
                if (null != this.username && null != ((MaterialKey)other).username) {
                    return this.username.equals(((MaterialKey)other).username) && this.projectName.equals(((MaterialKey)other).projectName);
                }
                return this.projectName.equals(((MaterialKey)other).projectName);
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            if (null != this.username) {
                result = 31 * result + this.username.hashCode();
            }
            result = 31 * result + this.projectName.hashCode();
            return result;
        }
    }

    public class CryptoMaterial {
        private final ByteBuffer keyStore;
        private final ByteBuffer trustStore;
        private final char[] password;

        public CryptoMaterial(ByteBuffer keyStore, ByteBuffer trustStore, char[] password) {
            this.keyStore = keyStore;
            this.trustStore = trustStore;
            this.password = password;
        }

        public ByteBuffer getKeyStore() {
            return this.keyStore;
        }

        public ByteBuffer getTrustStore() {
            return this.trustStore;
        }

        public char[] getPassword() {
            return this.password;
        }

        public void wipePassword() {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = '\u0000';
            }
        }
    }

    public class MaterializerState<T, S, R, P> {
        private final T localMaterial;
        private final S remoteMaterial;
        private final R scheduledRemovals;
        private final P materialKeyLocks;

        public MaterializerState(T localMaterial, S remoteMaterial, R scheduledRemovals, P materialKeyLocks) {
            this.localMaterial = localMaterial;
            this.remoteMaterial = remoteMaterial;
            this.scheduledRemovals = scheduledRemovals;
            this.materialKeyLocks = materialKeyLocks;
        }

        public T getLocalMaterial() {
            return this.localMaterial;
        }

        public S getRemoteMaterial() {
            return this.remoteMaterial;
        }

        public R getScheduledRemovals() {
            return this.scheduledRemovals;
        }

        public P getMaterialKeyLocks() {
            return this.materialKeyLocks;
        }
    }
}

