/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.python;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.AnacondaRepo;
import io.hops.hopsworks.persistence.entity.python.CondaInstallType;
import io.hops.hopsworks.persistence.entity.python.CondaStatus;
import io.hops.hopsworks.persistence.entity.python.MachineType;
import io.hops.hopsworks.persistence.entity.python.PythonDep;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class LibraryFacade
extends AbstractFacade<PythonDep> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public LibraryFacade() {
        super(PythonDep.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public AnacondaRepo getRepo(String channelUrl, boolean create) throws ServiceException {
        AnacondaRepo repo;
        block3: {
            TypedQuery query = this.em.createNamedQuery("AnacondaRepo.findByUrl", AnacondaRepo.class);
            query.setParameter("url", (Object)channelUrl);
            repo = null;
            try {
                repo = (AnacondaRepo)query.getSingleResult();
            }
            catch (NoResultException ex) {
                if (!create) break block3;
                repo = new AnacondaRepo();
                repo.setUrl(channelUrl);
                this.em.persist((Object)repo);
                this.em.flush();
            }
        }
        if (repo == null) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_REPO_ERROR, Level.SEVERE);
        }
        return repo;
    }

    public PythonDep getOrCreateDep(AnacondaRepo repo, MachineType machineType, CondaInstallType installType, String dependency, String version, boolean create, boolean preinstalled) {
        PythonDep dep;
        block2: {
            TypedQuery deps = this.em.createNamedQuery("PythonDep.findUniqueDependency", PythonDep.class);
            deps.setParameter("dependency", (Object)dependency);
            deps.setParameter("version", (Object)version);
            deps.setParameter("installType", (Object)installType);
            deps.setParameter("repoUrl", (Object)repo);
            deps.setParameter("machineType", (Object)machineType);
            dep = null;
            try {
                dep = (PythonDep)deps.getSingleResult();
            }
            catch (NoResultException ex) {
                if (!create) break block2;
                dep = new PythonDep();
                dep.setRepoUrl(repo);
                dep.setDependency(dependency);
                dep.setVersion(version);
                dep.setPreinstalled(preinstalled);
                dep.setInstallType(installType);
                dep.setMachineType(machineType);
                this.em.persist((Object)dep);
                this.em.flush();
            }
        }
        return dep;
    }

    public PythonDep findByDependencyAndProject(String dependency, Project project) {
        try {
            return (PythonDep)this.em.createNamedQuery("PythonDep.findByDependencyAndProject", PythonDep.class).setParameter("dependency", (Object)dependency).setParameter("project", (Object)project).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public AbstractFacade.CollectionInfo findInstalledPythonDepsByProject(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort, Project project) {
        String queryStr = this.buildQuery("SELECT p FROM PythonDep p ", filter, sort, ":project MEMBER OF p.projectCollection ");
        String queryCountStr = this.buildQuery("SELECT COUNT(p.id) FROM PythonDep p ", filter, sort, ":project MEMBER OF p.projectCollection ");
        TypedQuery query = this.em.createQuery(queryStr, PythonDep.class).setParameter("project", (Object)project);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, PythonDep.class).setParameter("project", (Object)project);
        return this.findAll(offset, limit, filter, (Query)query, (Query)queryCount);
    }

    private AbstractFacade.CollectionInfo findAll(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Query query, Query queryCount) {
        this.setFilter(filter, query);
        this.setFilter(filter, queryCount);
        this.setOffsetAndLim(offset, limit, query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case PREINSTALLED: {
                this.setPreinstall(filterBy, q);
                break;
            }
            case STATUS: 
            case STATUS_NEQ: {
                this.setStatus(filterBy, q);
                break;
            }
            case MACHINE_TYPE: 
            case MACHINE_TYPE_NEQ: {
                this.setMachineType(filterBy, q);
                break;
            }
        }
    }

    private void setPreinstall(AbstractFacade.FilterBy filterBy, Query q) {
        String field = filterBy.getField();
        boolean val = this.getBooleanValue(filterBy.getParam());
        q.setParameter(field, (Object)val);
    }

    private void setStatus(AbstractFacade.FilterBy filterBy, Query q) {
        List<CondaStatus> status = this.getEnumValues(filterBy, CondaStatus.class);
        q.setParameter(filterBy.getField(), status);
    }

    private void setMachineType(AbstractFacade.FilterBy filterBy, Query q) {
        List<MachineType> machineTypes = this.getEnumValues(filterBy, MachineType.class);
        q.setParameter(filterBy.getField(), machineTypes);
    }

    public static enum Filters {
        PREINSTALLED("PREINSTALLED", "p.preinstalled = :preinstalled ", "preinstalled", "1"),
        STATUS("STATUS", "p.status IN :status ", "status", "NEW"),
        STATUS_NEQ("STATUS_NEQ", "p.status NOT IN :status_neq ", "status_neq", "NEW"),
        MACHINE_TYPE("MACHINE_TYPE", "p.machineType IN :machineType ", "machineType", "ALL"),
        MACHINE_TYPE_NEQ("MACHINE_TYPE_NEQ", "p.machineType NOT IN :machineType_neq ", "machineType_neq", "CPU");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", "p.id ", "ASC"),
        DEPENDENCY("DEPENDENCY", "p.dependency ", "ASC"),
        STATUS("STATUS", "p.status ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

